/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.controls.keyboard;

import com.google.gwt.user.client.Timer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.PreDestroy;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.stunner.core.client.canvas.controls.keyboard.KeyEventHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.keyboard.KeyboardControl;
import org.kie.workbench.common.stunner.core.client.event.keyboard.KeyDownEvent;
import org.kie.workbench.common.stunner.core.client.event.keyboard.KeyUpEvent;
import org.kie.workbench.common.stunner.core.client.event.keyboard.KeyboardEvent;

@Dependent
public class KeyEventHandlerImpl
implements KeyEventHandler {
    private static final int KEYS_TIMER_DELAY = 100;
    private final Set<KeyboardEvent.Key> keys = new HashSet<KeyboardEvent.Key>();
    private final List<KeyboardControl.KeyShortcutCallback> shortcutCallbacks = new ArrayList<KeyboardControl.KeyShortcutCallback>();
    private boolean enabled = true;
    private KeyboardEvent.Key[] _keys;
    private Timer timer;
    private int delay = 100;

    @Override
    public KeyEventHandler addKeyShortcutCallback(KeyboardControl.KeyShortcutCallback shortcutCallback) {
        this.shortcutCallbacks.add(shortcutCallback);
        return this;
    }

    @Override
    public KeyEventHandler setTimerDelay(int millis) {
        this.delay = millis;
        return this;
    }

    @Override
    @PreDestroy
    public void clear() {
        if (null != this.timer && this.timer.isRunning()) {
            this.timer.cancel();
        }
        this.shortcutCallbacks.clear();
        this.reset();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void onKeyUpEvent(@Observes KeyUpEvent event) {
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        this.onKeyUp(event.getKey());
    }

    void onKeyDownEvent(@Observes KeyDownEvent event) {
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        this.onKeyDown(event.getKey());
    }

    private void onKeyDown(KeyboardEvent.Key key) {
        if (!this.enabled) {
            return;
        }
        if (!this.shortcutCallbacks.isEmpty()) {
            this.startKeysTimer(key);
        }
    }

    private void onKeyUp(KeyboardEvent.Key key) {
        if (!this.enabled) {
            return;
        }
        this.keys.remove(key);
        this.shortcutCallbacks.stream().forEach(s -> s.onKeyUp(key));
    }

    private void startKeysTimer(KeyboardEvent.Key key) {
        this.keys.add(key);
        this._keys = this.keys.toArray(new KeyboardEvent.Key[this.keys.size()]);
        if (null == this.timer) {
            this.timer = new Timer(){

                public void run() {
                    KeyEventHandlerImpl.this.keysTimerTimeIsUp();
                }
            };
        }
        this.timer.schedule(this.delay);
    }

    void keysTimerTimeIsUp() {
        if (!this.shortcutCallbacks.isEmpty() && null != this._keys) {
            this.shortcutCallbacks.stream().forEach(s -> s.onKeyShortcut(this._keys));
        }
    }

    void reset() {
        this.setEnabled(false);
        this._keys = null;
        this.keys.clear();
        this.timer = null;
    }
}

