/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.command;

import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.appformer.client.stateControl.registry.Registry;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.event.registration.RegisterChangedEvent;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.client.session.impl.EditorSession;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.CommandManager;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;

@Dependent
public class RedoCommandHandler<C extends Command> {
    private final Event<RegisterChangedEvent> registerChangedEvent;
    private final SessionManager sessionManager;

    protected RedoCommandHandler() {
        this(null, null);
    }

    @Inject
    public RedoCommandHandler(SessionManager sessionManager, Event<RegisterChangedEvent> registerChangedEvent) {
        this.sessionManager = sessionManager;
        this.registerChangedEvent = registerChangedEvent;
    }

    public boolean onUndoCommandExecuted(C command) {
        this.getRegistry().register(command);
        return this.isEnabled();
    }

    public boolean onCommandExecuted(C command) {
        if (this.isEnabled()) {
            Command last = (Command)this.getRegistry().peek();
            if (last.equals(command)) {
                this.getRegistry().pop();
            } else {
                this.clear();
            }
        }
        return this.isEnabled();
    }

    public CommandResult<?> execute(Object context, CommandManager commandManager) {
        if (this.getRegistry().isEmpty()) {
            return GraphCommandResultBuilder.SUCCESS;
        }
        Command last = (Command)this.getRegistry().peek();
        return commandManager.execute(context, last);
    }

    public void setSession(ClientSession clientSession) {
        this.getRegistry().setRegistryChangeListener(() -> this.registerChangedEvent.fire((Object)new RegisterChangedEvent(clientSession.getCanvasHandler())));
    }

    public boolean isEnabled() {
        return !this.getRegistry().isEmpty();
    }

    public void clear() {
        this.getRegistry().clear();
    }

    protected Registry<C> getRegistry() {
        ClientSession currentSession = this.sessionManager.getCurrentSession();
        if (currentSession instanceof EditorSession) {
            return ((EditorSession)currentSession).getRedoCommandRegistry();
        }
        throw new IllegalStateException("'RedoCommandRegistry' not available.");
    }
}

