/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.components.proxies;

import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.Canvas;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandFactory;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.client.components.proxies.ElementProxy;
import org.kie.workbench.common.stunner.core.client.components.proxies.ShapeProxy;
import org.kie.workbench.common.stunner.core.client.components.proxies.ShapeProxyView;
import org.kie.workbench.common.stunner.core.client.event.keyboard.KeyDownEvent;
import org.kie.workbench.common.stunner.core.client.shape.NodeShape;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.ShapeState;
import org.kie.workbench.common.stunner.core.client.shape.view.event.AbstractMouseEvent;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.impl.DeferredCompositeCommand;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.Connection;
import org.kie.workbench.common.stunner.core.graph.content.view.MagnetConnection;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewConnector;
import org.kie.workbench.common.stunner.core.graph.util.GraphUtils;

@Dependent
public class NodeProxy
implements ShapeProxy {
    private final ElementProxy proxy;
    private final ShapeProxyView<NodeShape> view;
    private Node<View<?>, Edge> targetNode;
    private Edge<ViewConnector<?>, Node> edge;
    private Node<View<?>, Edge> sourceNode;

    @Inject
    public NodeProxy(ElementProxy proxy, ShapeProxyView<NodeShape> view) {
        this.proxy = proxy;
        this.view = view;
    }

    @PostConstruct
    public void init() {
        this.proxy.setView(this.view).setProxyBuilder(this::onCreateProxy);
    }

    public NodeProxy setCanvasHandler(AbstractCanvasHandler canvasHandler) {
        this.proxy.setCanvasHandler(canvasHandler);
        return this;
    }

    public NodeProxy setTargetNode(Node<View<?>, Edge> targetNode) {
        this.targetNode = targetNode;
        return this;
    }

    public NodeProxy setEdge(Edge<ViewConnector<?>, Node> edge) {
        this.edge = edge;
        return this;
    }

    public NodeProxy setSourceNode(Node<View<?>, Edge> sourceNode) {
        this.sourceNode = sourceNode;
        return this;
    }

    public NodeProxy start(AbstractMouseEvent event) {
        this.start(event.getX(), event.getY());
        return this;
    }

    @Override
    public void start(double x, double y) {
        this.proxy.start(x, y);
    }

    @Override
    public void destroy() {
        this.proxy.destroy();
        this.targetNode = null;
        this.edge = null;
        this.sourceNode = null;
    }

    void onKeyDownEvent(@Observes KeyDownEvent event) {
        this.proxy.handleCancelKey(event.getKey());
    }

    private NodeShape onCreateProxy() {
        CanvasCommandFactory<AbstractCanvasHandler> commandFactory = this.proxy.lookupCanvasFactory();
        Node<View<?>, Edge> parent = this.getParent();
        this.proxy.execute((Command<AbstractCanvasHandler, CanvasViolation>)new DeferredCompositeCommand.Builder().deferCommand(() -> null != parent ? commandFactory.addChildNode(parent, this.targetNode, this.getShapeSetId()) : commandFactory.addNode(this.targetNode, this.getShapeSetId())).deferCommand(() -> commandFactory.addConnector(this.sourceNode, this.edge, (Connection)MagnetConnection.Builder.atCenter(this.sourceNode), this.getShapeSetId())).deferCommand(() -> commandFactory.setTargetNode(this.targetNode, this.edge, (Connection)MagnetConnection.Builder.forTarget(this.sourceNode, this.targetNode))).build());
        Canvas canvas = this.proxy.getCanvas();
        NodeShape targetShape = this.getTargetShape();
        Shape edgeShape = canvas.getShape(this.edge.getUUID());
        edgeShape.applyState(ShapeState.SELECTED);
        return targetShape;
    }

    private Node<View<?>, Edge> getParent() {
        return (Node)GraphUtils.getParent(this.sourceNode);
    }

    private NodeShape getTargetShape() {
        return (NodeShape)this.proxy.getCanvas().getShape(this.targetNode.getUUID());
    }

    private Metadata getMetadata() {
        return this.proxy.getCanvasHandler().getDiagram().getMetadata();
    }

    private String getShapeSetId() {
        return this.getMetadata().getShapeSetId();
    }
}

