/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.i18n;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.i18n.CoreTranslationMessages;
import org.kie.workbench.common.stunner.core.i18n.StunnerTranslationService;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;
import org.kie.workbench.common.stunner.core.validation.ModelBeanViolation;

@ApplicationScoped
public class ClientTranslationMessages
extends CoreTranslationMessages {
    private final StunnerTranslationService translationService;

    @Inject
    public ClientTranslationMessages(StunnerTranslationService translationService) {
        this.translationService = translationService;
    }

    public String getCanvasValidationsErrorMessage(String key, Iterable<CanvasViolation> result) {
        return ClientTranslationMessages.getCanvasValidationsErrorMessage(this.translationService, key, result);
    }

    public String getCanvasCommandValidationsErrorMessage(Iterable<CanvasViolation> result) {
        return ClientTranslationMessages.getCanvasCommandValidationsErrorMessage(this.translationService, result);
    }

    public static String getCanvasValidationsErrorMessage(StunnerTranslationService translationService, String key, Iterable<CanvasViolation> result) {
        String message = translationService.getValue(key) + "." + "\n" + translationService.getValue("org.kie.workbench.common.stunner.core.reason") + ": " + "\n" + ClientTranslationMessages.getValidationMessages(translationService, result);
        return message;
    }

    public static String getCanvasCommandValidationsErrorMessage(StunnerTranslationService translationService, Iterable<CanvasViolation> result) {
        return ClientTranslationMessages.getCanvasValidationsErrorMessage(translationService, "org.kie.workbench.common.stunner.core.command.fail", result);
    }

    public String getRuleValidationMessage(RuleViolation violation) {
        return ClientTranslationMessages.getRuleValidationMessage((StunnerTranslationService)this.translationService, (RuleViolation)violation);
    }

    public String getBeanValidationMessage(ModelBeanViolation violation) {
        return ClientTranslationMessages.getBeanValidationMessage((StunnerTranslationService)this.translationService, (ModelBeanViolation)violation);
    }

    private static String getValidationMessages(StunnerTranslationService translationService, Iterable<CanvasViolation> violations) {
        StringBuilder message = new StringBuilder();
        int[] i = new int[]{1};
        violations.forEach(v -> {
            int n = i[0];
            i[0] = n + 1;
            message.append("[").append(n).append("] ").append(ClientTranslationMessages.getRuleValidationMessage((StunnerTranslationService)translationService, (RuleViolation)v)).append("\n");
        });
        return message.toString();
    }
}

