/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.i18n;

import java.util.Objects;
import java.util.Optional;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.i18n.AbstractTranslationService;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;
import org.kie.workbench.common.stunner.core.util.StringUtils;
import org.kie.workbench.common.stunner.core.validation.DiagramElementNameProvider;

@Singleton
public class ClientTranslationService
extends AbstractTranslationService {
    private final TranslationService erraiTranslationService;
    private final ManagedInstance<DiagramElementNameProvider> elementNameProviders;
    private SessionManager sessionManager;
    private DefinitionUtils definitionUtils;

    @Inject
    public ClientTranslationService(TranslationService erraiTranslationService, ManagedInstance<DiagramElementNameProvider> elementNameProviders, SessionManager sessionManager, DefinitionUtils definitionUtils) {
        this.erraiTranslationService = erraiTranslationService;
        this.elementNameProviders = elementNameProviders;
        this.sessionManager = sessionManager;
        this.definitionUtils = definitionUtils;
    }

    public String getValue(String key) {
        return this.erraiTranslationService.getTranslation(key);
    }

    public String getNotNullValue(String key) {
        String value = this.getValue(key);
        if (null == value) {
            return key;
        }
        return value;
    }

    public String getValue(String key, Object ... args) {
        return this.erraiTranslationService.format(key, args);
    }

    public String getViolationMessage(RuleViolation ruleViolation) {
        if (ruleViolation instanceof CanvasViolation) {
            return this.getCanvasViolationMessage((CanvasViolation)ruleViolation);
        }
        return super.getViolationMessage(ruleViolation);
    }

    private String getCanvasViolationMessage(CanvasViolation canvasViolation) {
        return this.getRuleViolationMessage(canvasViolation.getRuleViolation());
    }

    public Optional<String> getElementName(String uuid) {
        return this.getNameProvider(uuid).map(nameProvider -> nameProvider.getElementName(uuid)).orElse(Optional.of(this.defaultElementName(uuid)));
    }

    private String defaultElementName(String uuid) {
        Node node = this.sessionManager.getCurrentSession().getCanvasHandler().getDiagram().getGraph().getNode(uuid);
        Optional<Object> definition = Optional.ofNullable(node).map(Element::getContent).map(Definition::getDefinition);
        return definition.map(arg_0 -> ((DefinitionUtils)this.definitionUtils).getName(arg_0)).filter(StringUtils::nonEmpty).orElse(uuid);
    }

    private Optional<DiagramElementNameProvider> getNameProvider(String uuid) {
        return StreamSupport.stream(this.elementNameProviders.spliterator(), false).filter(elementNameProvider -> Objects.equals(elementNameProvider.getDefinitionSetId(), this.getSessionDefinitionSetId())).findFirst();
    }

    private String getSessionDefinitionSetId() {
        return this.sessionManager.getCurrentSession().getCanvasHandler().getDiagram().getMetadata().getDefinitionSetId();
    }
}

