/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.session.command.impl;

import java.util.Objects;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Default;
import javax.inject.Inject;
import org.appformer.client.stateControl.registry.Registry;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.keyboard.KeysMatcher;
import org.kie.workbench.common.stunner.core.client.canvas.event.registration.CurrentRegistryChangedEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.registration.RegisterChangedEvent;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.client.event.keyboard.KeyboardEvent;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.client.session.command.AbstractClientSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.ClientSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.impl.EditorSession;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.util.CommandUtils;

@Dependent
@Default
public class UndoSessionCommand
extends AbstractClientSessionCommand<EditorSession> {
    private final SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    private final SessionManager sessionManager;

    @Inject
    public UndoSessionCommand(SessionCommandManager<AbstractCanvasHandler> sessionCommandManager, SessionManager sessionManager) {
        super(false);
        this.sessionCommandManager = sessionCommandManager;
        this.sessionManager = sessionManager;
    }

    @Override
    public void bind(EditorSession session) {
        super.bind(session);
        this.bindCommand();
    }

    protected void bindCommand() {
        this.getSession().getKeyboardControl().addKeyShortcutCallback(this::onKeyDownEvent);
    }

    @Override
    public boolean accepts(ClientSession session) {
        return session instanceof EditorSession;
    }

    void onKeyDownEvent(KeyboardEvent.Key ... keys) {
        if (this.isEnabled()) {
            this.handleCtrlZ(keys);
        }
    }

    private void handleCtrlZ(KeyboardEvent.Key[] keys) {
        if (KeysMatcher.doKeysMatch(keys, KeyboardEvent.Key.CONTROL, KeyboardEvent.Key.Z)) {
            this.execute();
        }
    }

    @Override
    public <V> void execute(ClientSessionCommand.Callback<V> callback) {
        PortablePreconditions.checkNotNull((String)"callback", callback);
        Registry<Command<AbstractCanvasHandler, CanvasViolation>> registry = this.getSession().getCommandRegistry();
        if (!registry.isEmpty()) {
            CommandResult result = this.sessionCommandManager.undo((CanvasHandler)((AbstractCanvasHandler)this.getSession().getCanvasHandler()));
            this.checkState();
            if (CommandUtils.isError((CommandResult)result)) {
                callback.onError(result);
                this.getSession().getCommandRegistry().clear();
            } else {
                callback.onSuccess();
            }
            this.getSession().getSelectionControl().clearSelection();
        }
    }

    void onCommandAdded(@Observes RegisterChangedEvent registerChangedEvent) {
        PortablePreconditions.checkNotNull((String)"registerChangedEvent", (Object)registerChangedEvent);
        if (!Objects.isNull(this.getSession()) && Objects.equals(registerChangedEvent.getCanvasHandler(), this.getCanvasHandler())) {
            this.checkState();
        }
    }

    void onCurrentRegistryChanged(@Observes CurrentRegistryChangedEvent currentRegistryChangedEvent) {
        this.checkState();
    }

    void checkState() {
        if (this.getSession() != null) {
            this.setEnabled(!this.getSession().getCommandRegistry().getHistory().isEmpty());
            this.fire();
        }
    }

    @Override
    protected EditorSession getSession() {
        return (EditorSession)this.sessionManager.getCurrentSession();
    }
}

