/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.session.impl;

import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.appformer.client.stateControl.registry.DefaultRegistry;
import org.appformer.client.stateControl.registry.Registry;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.CanvasControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.CanvasInlineTextEditorControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.ClipboardControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.ContainmentAcceptorControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.DockingAcceptorControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.LocationControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.MediatorsControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.ResizeControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.SelectionControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.ToolboxControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.builder.EdgeBuilderControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.builder.ElementBuilderControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.builder.NodeBuilderControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.builder.impl.Observer;
import org.kie.workbench.common.stunner.core.client.canvas.controls.connection.ConnectionAcceptorControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.connection.ControlPointControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.keyboard.AbstractCanvasShortcutsControlImpl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.keyboard.KeyboardControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.select.MultipleSelection;
import org.kie.workbench.common.stunner.core.client.canvas.event.registration.RegisterChangedEvent;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandManager;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.client.command.RequiresCommandManager;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.client.session.impl.AbstractSession;
import org.kie.workbench.common.stunner.core.client.session.impl.EditorSession;
import org.kie.workbench.common.stunner.core.client.session.impl.ManagedSession;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.uberfire.mvp.Command;

@Dependent
public class DefaultEditorSession
extends EditorSession {
    private final ManagedSession session;
    private final CanvasCommandManager<AbstractCanvasHandler> canvasCommandManager;
    private final SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    private final Registry<org.kie.workbench.common.stunner.core.command.Command<AbstractCanvasHandler, CanvasViolation>> commandRegistry;
    private final Event<RegisterChangedEvent> registerChangedEvent;
    private final DefaultRegistry<org.kie.workbench.common.stunner.core.command.Command<AbstractCanvasHandler, CanvasViolation>> redoCommandRegistry;

    @Inject
    public DefaultEditorSession(ManagedSession session, CanvasCommandManager<AbstractCanvasHandler> canvasCommandManager, SessionCommandManager<AbstractCanvasHandler> sessionCommandManager, Registry<org.kie.workbench.common.stunner.core.command.Command<AbstractCanvasHandler, CanvasViolation>> commandRegistry, DefaultRegistry<org.kie.workbench.common.stunner.core.command.Command<AbstractCanvasHandler, CanvasViolation>> redoCommandRegistry, Event<RegisterChangedEvent> registerChangedEvent) {
        this.session = session;
        this.commandRegistry = commandRegistry;
        this.sessionCommandManager = sessionCommandManager;
        this.canvasCommandManager = canvasCommandManager;
        this.registerChangedEvent = registerChangedEvent;
        this.redoCommandRegistry = redoCommandRegistry;
    }

    @PostConstruct
    public void constructInstance() {
        this.session.onCanvasControlRegistered(this::onControlRegistered).onCanvasHandlerControlRegistered(this::onCanvasHandlerControlRegistered).onCanvasControlDestroyed(AbstractSession::onControlDestroyed).onCanvasHandlerControlDestroyed(AbstractSession::onControlDestroyed);
        Optional.ofNullable(this.getCommandRegistry()).ifPresent(registry -> registry.setRegistryChangeListener(() -> this.fireRegistryChangedEvent()));
    }

    protected void fireRegistryChangedEvent() {
        this.registerChangedEvent.fire((Object)new RegisterChangedEvent((CanvasHandler)this.session.getCanvasHandler()));
    }

    @Override
    public void init(Metadata metadata, Command callback) {
        this.init(s -> s.registerCanvasControl(MediatorsControl.class).registerCanvasHandlerControl(SelectionControl.class, MultipleSelection.class).registerCanvasHandlerControl(ResizeControl.class).registerCanvasHandlerControl(ConnectionAcceptorControl.class).registerCanvasHandlerControl(ContainmentAcceptorControl.class).registerCanvasHandlerControl(DockingAcceptorControl.class).registerCanvasHandlerControl(CanvasInlineTextEditorControl.class).registerCanvasHandlerControl(LocationControl.class).registerCanvasHandlerControl(ToolboxControl.class).registerCanvasHandlerControl(ElementBuilderControl.class, Observer.class).registerCanvasHandlerControl(NodeBuilderControl.class).registerCanvasHandlerControl(EdgeBuilderControl.class).registerCanvasHandlerControl(AbstractCanvasShortcutsControlImpl.class).registerCanvasControl(KeyboardControl.class).registerCanvasControl(ClipboardControl.class).registerCanvasHandlerControl(ControlPointControl.class), metadata, callback);
    }

    public void init(Consumer<ManagedSession> sessionControls, Metadata metadata, Command callback) {
        sessionControls.accept(this.session);
        this.session.init(metadata, callback);
    }

    @Override
    public void open() {
        this.session.open();
    }

    @Override
    public void close() {
        this.session.close();
    }

    @Override
    public void destroy() {
        this.commandRegistry.clear();
        this.session.destroy();
    }

    protected ManagedSession getSession() {
        return this.session;
    }

    public String getSessionUUID() {
        return this.session.getSessionUUID();
    }

    public AbstractCanvas getCanvas() {
        return this.session.getCanvas();
    }

    public AbstractCanvasHandler getCanvasHandler() {
        return this.session.getCanvasHandler();
    }

    @Override
    public CanvasCommandManager<AbstractCanvasHandler> getCommandManager() {
        return this.canvasCommandManager;
    }

    @Override
    public Registry<org.kie.workbench.common.stunner.core.command.Command<AbstractCanvasHandler, CanvasViolation>> getCommandRegistry() {
        return this.commandRegistry;
    }

    @Override
    public Registry<org.kie.workbench.common.stunner.core.command.Command<AbstractCanvasHandler, CanvasViolation>> getRedoCommandRegistry() {
        return this.redoCommandRegistry;
    }

    @Override
    public MediatorsControl<AbstractCanvas> getMediatorsControl() {
        return (MediatorsControl)this.session.getCanvasControl(MediatorsControl.class);
    }

    @Override
    public KeyboardControl<AbstractCanvas, ClientSession> getKeyboardControl() {
        return (KeyboardControl)this.session.getCanvasControl(KeyboardControl.class);
    }

    @Override
    public ClipboardControl<Element, AbstractCanvas, ClientSession> getClipboardControl() {
        return (ClipboardControl)this.session.getCanvasControl(ClipboardControl.class);
    }

    @Override
    public SelectionControl<AbstractCanvasHandler, Element> getSelectionControl() {
        return (SelectionControl)this.session.getCanvasHandlerControl(SelectionControl.class);
    }

    @Override
    public ConnectionAcceptorControl<AbstractCanvasHandler> getConnectionAcceptorControl() {
        return (ConnectionAcceptorControl)this.session.getCanvasHandlerControl(ConnectionAcceptorControl.class);
    }

    @Override
    public ContainmentAcceptorControl<AbstractCanvasHandler> getContainmentAcceptorControl() {
        return (ContainmentAcceptorControl)this.session.getCanvasHandlerControl(ContainmentAcceptorControl.class);
    }

    @Override
    public DockingAcceptorControl<AbstractCanvasHandler> getDockingAcceptorControl() {
        return (DockingAcceptorControl)this.session.getCanvasHandlerControl(DockingAcceptorControl.class);
    }

    private void onCanvasHandlerControlRegistered(CanvasControl<AbstractCanvasHandler> control) {
        if (control instanceof RequiresCommandManager) {
            ((RequiresCommandManager)control).setCommandManagerProvider(() -> this.sessionCommandManager);
        }
        this.onControlRegistered(control);
    }
}

