/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.util;

import elemental2.dom.DomGlobal;
import elemental2.dom.Element;
import elemental2.dom.HTMLDocument;
import elemental2.dom.HTMLElement;
import elemental2.dom.Node;
import elemental2.dom.NodeList;
import elemental2.dom.Window;
import java.util.Objects;
import org.uberfire.mvp.Command;

public class PrintHelper {
    static final String PREVIEW_SCREEN_CSS_CLASS = "kie-print-preview-screen";

    public void print(HTMLElement element) {
        Window globalWindow = this.getGlobalWindow();
        Window printWindow = globalWindow.open((Object)"", "_blank");
        HTMLDocument printDocument = this.getWindowDocument(printWindow);
        this.writeElementIntoDocument(element, printDocument);
        this.changeMediaAttributesToAll(printDocument);
        this.copyStylesFromWindow(printDocument, globalWindow);
        this.setupPrintCommandOnPageLoad(printDocument, printWindow);
    }

    void writeElementIntoDocument(HTMLElement element, HTMLDocument document) {
        document.open();
        document.write(element.innerHTML);
        document.close();
        document.body.classList.add(new String[]{PREVIEW_SCREEN_CSS_CLASS});
    }

    void changeMediaAttributesToAll(HTMLDocument printDocument) {
        NodeList links = printDocument.querySelectorAll("link");
        String attribute = "media";
        for (int i = 0; i < links.length; ++i) {
            Element link = this.asElement(links.item(i));
            if (!Objects.equals(link.getAttribute("media"), "print")) continue;
            link.setAttribute("media", "all");
        }
    }

    void copyStylesFromWindow(HTMLDocument printDocument, Window window) {
        HTMLDocument topDocument = this.getWindowDocument(window.top);
        NodeList parentStyles = topDocument.querySelectorAll("style");
        Element documentHead = this.asElement(printDocument.querySelector("head"));
        for (int i = 0; i < parentStyles.length; ++i) {
            Element copiedStyle = this.createElement("style");
            copiedStyle.innerHTML = this.asElement((Object)parentStyles.item((int)i)).innerHTML;
            documentHead.appendChild((Node)copiedStyle);
        }
    }

    void setupPrintCommandOnPageLoad(HTMLDocument printDocument, Window printWindow) {
        printDocument.body.onload = e -> this.setTimeout(() -> {
            printWindow.focus();
            printWindow.print();
            printWindow.close();
        }, 10);
    }

    void setTimeout(Command command, int delay) {
        DomGlobal.setTimeout(e -> command.execute(), (double)delay, (Object[])new Object[0]);
    }

    Element asElement(Object object) {
        return this.nativeAsElement(object);
    }

    HTMLDocument getWindowDocument(Window window) {
        return this.nativeGetWindowDocument(window);
    }

    Element createElement(String tagName) {
        return DomGlobal.document.createElement(tagName);
    }

    Window getGlobalWindow() {
        return DomGlobal.window;
    }

    private native Element nativeAsElement(Object var1);

    private native HTMLDocument nativeGetWindowDocument(Window var1);
}

