/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.canvas.controls;

import com.ait.lienzo.client.core.shape.wires.WiresContainer;
import com.ait.lienzo.client.core.shape.wires.WiresLayer;
import com.ait.lienzo.client.core.shape.wires.WiresShape;
import com.google.gwt.logging.client.LogConfiguration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kie.workbench.common.stunner.client.lienzo.canvas.wires.WiresCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.CanvasControl;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandManager;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.client.command.RequiresCommandManager;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.CompositeCommand;
import org.kie.workbench.common.stunner.core.command.impl.CompositeCommandImpl;
import org.kie.workbench.common.stunner.core.command.util.CommandUtils;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Child;

public abstract class AbstractContainmentBasedControl
implements CanvasControl<AbstractCanvasHandler>,
RequiresCommandManager<AbstractCanvasHandler> {
    private static Logger LOGGER = Logger.getLogger(AbstractContainmentBasedControl.class.getName());
    private AbstractCanvasHandler canvasHandler;
    private RequiresCommandManager.CommandManagerProvider<AbstractCanvasHandler> commandManagerProvider;

    protected abstract void doEnable(WiresCanvas.View var1);

    protected abstract void doDisable(WiresCanvas.View var1);

    protected abstract boolean isEdgeAccepted(Edge var1);

    protected abstract Command<AbstractCanvasHandler, CanvasViolation> getAddEdgeCommand(Node var1, Node var2);

    protected abstract Command<AbstractCanvasHandler, CanvasViolation> getDeleteEdgeCommand(Node var1, Node var2);

    public void enable(AbstractCanvasHandler canvasHandler) {
        this.canvasHandler = canvasHandler;
        WiresCanvas.View canvasView = (WiresCanvas.View)canvasHandler.getAbstractCanvas().getView();
        this.doEnable(canvasView);
    }

    public void disable() {
        if (null != this.canvasHandler && null != this.canvasHandler.getCanvas()) {
            WiresCanvas.View canvasView = (WiresCanvas.View)this.canvasHandler.getAbstractCanvas().getView();
            this.doDisable(canvasView);
        }
        this.canvasHandler = null;
        this.commandManagerProvider = null;
    }

    public void setCommandManagerProvider(RequiresCommandManager.CommandManagerProvider<AbstractCanvasHandler> provider) {
        this.commandManagerProvider = provider;
    }

    public boolean allow(Node parent, Node child) {
        if (parent == null && child == null) {
            return false;
        }
        boolean isAllow = false;
        Edge<Object, Node> dockEdge = this.getTheEdge(child);
        boolean isSameParent = this.isSameParent(parent, dockEdge);
        if (isSameParent) {
            this.log(Level.FINE, "Is same parent. isAllow=true");
            isAllow = true;
        } else {
            Command<AbstractCanvasHandler, CanvasViolation> command = this.getAddEdgeCommand(parent, child);
            CommandResult violations = this.getCommandManager().allow((Object)this.canvasHandler, command);
            isAllow = this.isAccept((CommandResult<CanvasViolation>)violations);
            this.logResults("isAllow", command, (CommandResult<CanvasViolation>)violations);
        }
        return isAllow;
    }

    public boolean accept(Node parent, Node child) {
        if (parent == null && child == null) {
            return false;
        }
        Edge<Object, Node> dockEdge = this.getTheEdge(child);
        boolean isSameParent = this.isSameParent(parent, dockEdge);
        boolean isAccept = true;
        if (!isSameParent) {
            CompositeCommandImpl.CompositeCommandBuilder builder = null;
            if (null != dockEdge && null != dockEdge.getSourceNode()) {
                builder = new CompositeCommandImpl.CompositeCommandBuilder().reverse().addCommand(this.getDeleteEdgeCommand(dockEdge.getSourceNode(), child));
            }
            CompositeCommand c = this.getAddEdgeCommand(parent, child);
            CompositeCommand command = null == builder ? c : builder.addCommand(c).build();
            CommandResult violations = this.getCommandManager().execute((Object)this.canvasHandler, (Command)command);
            isAccept = this.isAccept((CommandResult<CanvasViolation>)violations);
            this.logResults("isAccept", (Command<AbstractCanvasHandler, CanvasViolation>)command, (CommandResult<CanvasViolation>)violations);
        } else {
            this.log(Level.FINE, "isAccept = TRUE");
        }
        return isAccept;
    }

    protected boolean isAccept(WiresContainer wiresContainer, WiresShape wiresShape) {
        return this.isEnabled() && this.isWiresShape(wiresContainer) && this.isWiresShape((WiresContainer)wiresShape);
    }

    protected AbstractCanvasHandler getCanvasHandler() {
        return this.canvasHandler;
    }

    private boolean isEnabled() {
        return this.canvasHandler != null;
    }

    private boolean isSameParent(Node parent, Edge<Child, Node> edge) {
        Node sourceNode;
        if (null != edge && null != (sourceNode = edge.getSourceNode())) {
            String parentUUID = null != parent ? parent.getUUID() : this.canvasHandler.getDiagram().getMetadata().getCanvasRootUUID();
            return null != parentUUID && sourceNode.getUUID().equals(parentUUID);
        }
        return parent == null;
    }

    private Edge<Object, Node> getTheEdge(Node child) {
        List outEdges;
        if (child != null && null != (outEdges = child.getInEdges()) && !outEdges.isEmpty()) {
            for (Edge edge : outEdges) {
                if (!this.isEdgeAccepted(edge)) continue;
                return edge;
            }
        }
        return null;
    }

    private boolean isWiresShape(WiresContainer wiresShape) {
        return this.isWiresLayer(wiresShape) || null != wiresShape && null != wiresShape.getContainer().getUserData() && wiresShape.getContainer().getUserData().equals("stnner.wiresCanvas");
    }

    private boolean isWiresLayer(WiresContainer wiresShape) {
        return null != wiresShape && wiresShape instanceof WiresLayer;
    }

    private boolean isAccept(CommandResult<CanvasViolation> result) {
        return !CommandUtils.isError(result);
    }

    private CanvasCommandManager<AbstractCanvasHandler> getCommandManager() {
        return this.commandManagerProvider.getCommandManager();
    }

    private void logResults(String prefix, Command<AbstractCanvasHandler, CanvasViolation> command, CommandResult<CanvasViolation> violations) {
        if (LogConfiguration.loggingIsEnabled()) {
            boolean isOk = this.isAccept(violations);
            if (isOk) {
                this.log(Level.FINE, prefix + "= TRUE");
            } else {
                this.log(Level.FINE, prefix + "= FALSE ");
                this.log(Level.FINE, "*************** Command = { " + command.toString() + " } ");
                this.log(Level.FINE, "*************** Violations = { " + violations.getMessage() + " } ");
            }
        }
    }

    private void log(Level level, String message) {
        if (LogConfiguration.loggingIsEnabled()) {
            LOGGER.log(level, message);
        }
    }
}

