/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.canvas.controls.containment;

import com.ait.lienzo.client.core.shape.wires.IContainmentAcceptor;
import com.ait.lienzo.client.core.shape.wires.WiresContainer;
import com.ait.lienzo.client.core.shape.wires.WiresShape;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.client.lienzo.canvas.controls.AbstractContainmentBasedControl;
import org.kie.workbench.common.stunner.client.lienzo.canvas.wires.WiresCanvas;
import org.kie.workbench.common.stunner.client.lienzo.canvas.wires.WiresUtils;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.CanvasCommandFactory;
import org.kie.workbench.common.stunner.core.client.canvas.controls.containment.ContainmentAcceptorControl;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Child;

@Dependent
public class ContainmentAcceptorControlImpl
extends AbstractContainmentBasedControl
implements ContainmentAcceptorControl<AbstractCanvasHandler> {
    private CanvasCommandFactory canvasCommandFactory;
    private final IContainmentAcceptor CONTAINMENT_ACCEPTOR = new IContainmentAcceptor(){

        public boolean containmentAllowed(WiresContainer wiresContainer, WiresShape wiresShape) {
            if (!ContainmentAcceptorControlImpl.this.isAccept(wiresContainer, wiresShape)) {
                return false;
            }
            Node childNode = WiresUtils.getNode(ContainmentAcceptorControlImpl.this.getCanvasHandler(), (WiresContainer)wiresShape);
            Node parentNode = WiresUtils.getNode(ContainmentAcceptorControlImpl.this.getCanvasHandler(), wiresContainer);
            return ContainmentAcceptorControlImpl.this.allow(parentNode, childNode);
        }

        public boolean acceptContainment(WiresContainer wiresContainer, WiresShape wiresShape) {
            if (!ContainmentAcceptorControlImpl.this.isAccept(wiresContainer, wiresShape)) {
                return false;
            }
            Node childNode = WiresUtils.getNode(ContainmentAcceptorControlImpl.this.getCanvasHandler(), (WiresContainer)wiresShape);
            Node parentNode = WiresUtils.getNode(ContainmentAcceptorControlImpl.this.getCanvasHandler(), wiresContainer);
            return ContainmentAcceptorControlImpl.this.accept(parentNode, childNode);
        }
    };

    @Inject
    public ContainmentAcceptorControlImpl(CanvasCommandFactory canvasCommandFactory) {
        this.canvasCommandFactory = canvasCommandFactory;
    }

    @Override
    protected void doEnable(WiresCanvas.View view) {
        view.setContainmentAcceptor(this.CONTAINMENT_ACCEPTOR);
    }

    @Override
    protected void doDisable(WiresCanvas.View view) {
        view.setContainmentAcceptor(IContainmentAcceptor.NONE);
    }

    @Override
    protected boolean isEdgeAccepted(Edge edge) {
        return edge.getContent() instanceof Child;
    }

    @Override
    protected Command<AbstractCanvasHandler, CanvasViolation> getAddEdgeCommand(Node parent, Node child) {
        return this.canvasCommandFactory.setChildNode(parent, child);
    }

    @Override
    protected Command<AbstractCanvasHandler, CanvasViolation> getDeleteEdgeCommand(Node parent, Node child) {
        return this.canvasCommandFactory.removeChild(parent, child);
    }
}

