/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.canvas.wires;

import com.ait.lienzo.client.core.shape.IDrawable;
import com.ait.lienzo.client.core.shape.wires.WiresConnector;
import com.ait.lienzo.client.core.shape.wires.WiresContainer;
import com.ait.lienzo.client.core.shape.wires.WiresLayer;
import com.ait.lienzo.client.core.shape.wires.WiresMagnet;
import com.ait.lienzo.client.core.shape.wires.WiresShape;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.Point2D;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeView;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;

public final class WiresUtils {
    public static Point2D getAbsolute(IDrawable<?> shape) {
        com.ait.lienzo.client.core.types.Point2D p = com.ait.lienzo.client.core.shape.wires.WiresUtils.getLocation(shape);
        return new Point2D(p.getX(), p.getY());
    }

    public static Node getNode(AbstractCanvasHandler canvasHandler, WiresContainer shape) {
        String canvasRoot;
        if (null == shape) {
            return null;
        }
        if (shape instanceof ShapeView) {
            ShapeView view = (ShapeView)shape;
            return canvasHandler.getGraphIndex().getNode(view.getUUID());
        }
        if (shape instanceof WiresLayer && null != (canvasRoot = canvasHandler.getDiagram().getMetadata().getCanvasRootUUID())) {
            return canvasHandler.getGraphIndex().getNode(canvasRoot);
        }
        return null;
    }

    public static Node getNode(AbstractCanvasHandler canvasHandler, WiresMagnet magnet) {
        if (null == magnet) {
            return null;
        }
        WiresShape shape = magnet.getMagnets().getWiresShape();
        return WiresUtils.getNode(canvasHandler, (WiresContainer)shape);
    }

    public static Edge getEdge(AbstractCanvasHandler canvasHandler, WiresConnector connector) {
        if (connector instanceof ShapeView) {
            ShapeView view = (ShapeView)connector;
            return canvasHandler.getGraphIndex().getEdge(view.getUUID());
        }
        return null;
    }

    public static boolean isWiresShape(ShapeView<?> shapeView) {
        return shapeView instanceof WiresShape;
    }

    public static boolean isWiresContainer(ShapeView<?> shapeView) {
        return shapeView instanceof WiresContainer;
    }

    public static boolean isWiresConnector(ShapeView<?> shapeView) {
        return shapeView instanceof WiresConnector;
    }
}

