/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.components.palette;

import com.ait.lienzo.client.core.shape.Group;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kie.workbench.common.stunner.client.lienzo.components.palette.AbstractLienzoPalette;
import org.kie.workbench.common.stunner.client.lienzo.components.palette.LienzoGlyphItemsPalette;
import org.kie.workbench.common.stunner.client.lienzo.components.palette.view.LienzoPaletteView;
import org.kie.workbench.common.stunner.client.lienzo.components.palette.view.element.LienzoGlyphPaletteItemView;
import org.kie.workbench.common.stunner.client.lienzo.components.palette.view.element.LienzoGlyphPaletteItemViewImpl;
import org.kie.workbench.common.stunner.client.lienzo.components.palette.view.element.LienzoPaletteElementView;
import org.kie.workbench.common.stunner.core.client.api.ShapeManager;
import org.kie.workbench.common.stunner.core.client.components.glyph.DefinitionGlyphTooltip;
import org.kie.workbench.common.stunner.core.client.components.glyph.GlyphTooltip;
import org.kie.workbench.common.stunner.core.client.components.palette.ClientPaletteUtils;
import org.kie.workbench.common.stunner.core.client.components.palette.model.GlyphPaletteItem;
import org.kie.workbench.common.stunner.core.client.components.palette.model.HasPaletteItems;
import org.kie.workbench.common.stunner.core.client.components.palette.view.PaletteGrid;
import org.kie.workbench.common.stunner.core.client.shape.factory.ShapeFactory;
import org.kie.workbench.common.stunner.core.client.shape.view.glyph.Glyph;

public abstract class AbstractLienzoGlyphItemsPalette<I extends HasPaletteItems<? extends GlyphPaletteItem>, V extends LienzoPaletteView>
extends AbstractLienzoPalette<I, V>
implements LienzoGlyphItemsPalette<I, V> {
    private static Logger LOGGER = Logger.getLogger(AbstractLienzoGlyphItemsPalette.class.getName());
    protected DefinitionGlyphTooltip<Group> definitionGlyphTooltip;
    protected LienzoGlyphItemsPalette.GlyphTooltipCallback glyphTooltipCallback;
    protected final List<LienzoPaletteElementView> itemViews = new LinkedList<LienzoPaletteElementView>();
    private ShapeFactory shapeFactory;

    protected AbstractLienzoGlyphItemsPalette() {
        this(null, null, null);
    }

    public AbstractLienzoGlyphItemsPalette(ShapeManager shapeManager, DefinitionGlyphTooltip definitionGlyphTooltip, V view) {
        super(shapeManager, view);
        this.definitionGlyphTooltip = definitionGlyphTooltip;
    }

    @Override
    public LienzoGlyphItemsPalette<I, V> setShapeSetId(String shapeSetId) {
        this.shapeFactory = this.shapeManager.getShapeSet(shapeSetId).getShapeFactory();
        return this;
    }

    @Override
    public LienzoGlyphItemsPalette<I, V> onShowGlyTooltip(LienzoGlyphItemsPalette.GlyphTooltipCallback callback) {
        this.glyphTooltipCallback = callback;
        return this;
    }

    public DefinitionGlyphTooltip getDefinitionGlyphTooltip() {
        return this.definitionGlyphTooltip;
    }

    protected void doClose() {
        super.doClose();
        this.getView().hide();
        this.definitionGlyphTooltip.hide();
    }

    @Override
    protected void beforeBind() {
        super.beforeBind();
        this.itemViews.clear();
    }

    @Override
    protected void doBind() {
        PaletteGrid grid = this.getGrid();
        for (GlyphPaletteItem item : this.getItems()) {
            this.addGlyphItemIntoView(item, grid);
        }
    }

    @Override
    protected void afterBind() {
        super.afterBind();
        this.doExpandCollapse();
    }

    protected void addGlyphItemIntoView(GlyphPaletteItem item, PaletteGrid grid) {
        Glyph<Group> glyph = this.getGlyph(item.getDefinitionId(), grid.getIconSize(), grid.getIconSize());
        if (null != glyph) {
            LienzoGlyphPaletteItemViewImpl paletteItemView = new LienzoGlyphPaletteItemViewImpl(item, (LienzoPaletteView)this.getView(), glyph);
            this.itemViews.add(paletteItemView);
            this.view.add(paletteItemView);
        } else {
            LOGGER.log(Level.WARNING, "Could not create glyph for [" + item.getDefinitionId() + "]");
        }
    }

    protected Glyph<Group> getGlyph(String id, double width, double height) {
        ShapeFactory shapeFactory = this.getShapeFactory();
        if (null != shapeFactory) {
            return shapeFactory.glyph(id, width, height);
        }
        LOGGER.log(Level.SEVERE, "No shape factory available.");
        return null;
    }

    @Override
    public List<GlyphPaletteItem> getItems() {
        HasPaletteItems paletteItems = this.paletteDefinition;
        return paletteItems.getItems();
    }

    protected String getPaletteItemId(int index) {
        List<GlyphPaletteItem> items = this.getItems();
        if (null != items && items.size() > index) {
            return items.get(index).getId();
        }
        return null;
    }

    @Override
    public double[] computePaletteSize() {
        int titleLength;
        PaletteGrid grid = this.getGrid();
        String longestTitle = null;
        if (this.expanded) {
            List<GlyphPaletteItem> paletteItems = this.getItems();
            longestTitle = ClientPaletteUtils.getLongestText(paletteItems);
        }
        int n = titleLength = null != longestTitle ? longestTitle.length() : 0;
        if (this.isHorizontalLayout()) {
            return ClientPaletteUtils.computeSizeForHorizontalLayout((int)this.getItems().size(), (int)grid.getIconSize(), (int)grid.getPadding(), (int)titleLength);
        }
        return ClientPaletteUtils.computeSizeForVerticalLayout((int)this.getItems().size(), (int)grid.getIconSize(), (int)grid.getPadding(), (int)titleLength);
    }

    public boolean onItemHover(int pos, double mouseX, double mouseY, double itemX, double itemY) {
        GlyphPaletteItem item;
        if (super.onItemHover(pos, mouseX, mouseY, itemX, itemY) && null != (item = this.getItem(pos))) {
            return this.onItemHover(item, mouseX, mouseY, itemX, itemY);
        }
        return true;
    }

    @Override
    public GlyphPaletteItem getItem(int pos) {
        LienzoPaletteElementView itemView = this.itemViews.get(pos);
        if (itemView instanceof LienzoGlyphPaletteItemView) {
            String iid = ((GlyphPaletteItem)((LienzoGlyphPaletteItemView)itemView).getPaletteItem()).getId();
            return this.getItem(iid);
        }
        return null;
    }

    protected GlyphPaletteItem getItem(String id) {
        List<GlyphPaletteItem> paletteItems = this.getItems();
        if (null != paletteItems && !paletteItems.isEmpty()) {
            for (GlyphPaletteItem item : paletteItems) {
                if (!item.getId().equals(id)) continue;
                return item;
            }
        }
        return null;
    }

    protected boolean onItemHover(GlyphPaletteItem item, double mouseX, double mouseY, double itemX, double itemY) {
        if (null != this.glyphTooltipCallback) {
            this.glyphTooltipCallback.onShowTooltip(this.definitionGlyphTooltip, item, mouseX, mouseY, itemX, itemY);
        } else if (!this.expanded) {
            PaletteGrid grid = this.getGrid();
            this.definitionGlyphTooltip.showTooltip(item.getDefinitionId(), itemX + (double)(grid.getIconSize() / 2), itemY, GlyphTooltip.Direction.WEST);
        }
        return true;
    }

    public boolean onItemOut(int index) {
        if (super.onItemOut(index)) {
            this.definitionGlyphTooltip.hide();
        }
        return true;
    }

    protected ShapeFactory getShapeFactory() {
        return this.shapeFactory;
    }

    @Override
    protected void doExpandCollapse() {
        for (LienzoPaletteElementView itemView : this.itemViews) {
            if (!(itemView instanceof LienzoGlyphPaletteItemView)) continue;
            LienzoGlyphPaletteItemView glyphPaletteItemView = (LienzoGlyphPaletteItemView)itemView;
            if (this.expanded) {
                glyphPaletteItemView.expand();
                continue;
            }
            glyphPaletteItemView.collapse();
        }
        this.getView().draw();
    }

    @Override
    protected void doDestroy() {
        this.itemViews.clear();
        super.doDestroy();
    }
}

