/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.components.palette.impl;

import com.ait.lienzo.client.core.shape.Layer;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.client.lienzo.components.palette.AbstractLienzoGlyphItemsPalette;
import org.kie.workbench.common.stunner.client.lienzo.components.palette.LienzoDefinitionSetPalette;
import org.kie.workbench.common.stunner.client.lienzo.components.palette.LienzoGlyphItemsPalette;
import org.kie.workbench.common.stunner.client.lienzo.components.palette.LienzoGlyphsHoverPalette;
import org.kie.workbench.common.stunner.client.lienzo.components.palette.LienzoPalette;
import org.kie.workbench.common.stunner.client.lienzo.components.palette.view.LienzoHoverPaletteView;
import org.kie.workbench.common.stunner.core.client.api.ShapeManager;
import org.kie.workbench.common.stunner.core.client.components.glyph.DefinitionGlyphTooltip;
import org.kie.workbench.common.stunner.core.client.components.glyph.GlyphTooltip;
import org.kie.workbench.common.stunner.core.client.components.palette.ClientPaletteUtils;
import org.kie.workbench.common.stunner.core.client.components.palette.Palette;
import org.kie.workbench.common.stunner.core.client.components.palette.model.GlyphPaletteItem;
import org.kie.workbench.common.stunner.core.client.components.palette.model.HasPaletteItems;
import org.kie.workbench.common.stunner.core.client.components.palette.model.definition.DefinitionPaletteCategory;
import org.kie.workbench.common.stunner.core.client.components.palette.model.definition.DefinitionSetPalette;
import org.kie.workbench.common.stunner.core.client.components.palette.view.PaletteGrid;

@Dependent
public class LienzoDefinitionSetPaletteImpl
extends AbstractLienzoGlyphItemsPalette<DefinitionSetPalette, LienzoHoverPaletteView>
implements LienzoDefinitionSetPalette {
    private final LienzoGlyphsHoverPalette glyphsFloatingPalette;
    private final List<GlyphPaletteItem> items = new LinkedList<GlyphPaletteItem>();
    private final Palette.CloseCallback floatingPaletteCloseCallback = () -> {
        this.clearFloatingPalette();
        return true;
    };
    private final LienzoGlyphItemsPalette.GlyphTooltipCallback floatingPaletteGlyphTooltipCallback = (glyphTooltip, item, mouseX, mouseY, itemX, itemY) -> {
        glyphTooltip.show(this.getGlyphTooltipText(item), mouseX, mouseY + (double)this.getIconSize() + (double)this.getPadding(), GlyphTooltip.Direction.NORTH);
        return false;
    };

    protected LienzoDefinitionSetPaletteImpl() {
        this(null, null, null, null);
    }

    @Inject
    public LienzoDefinitionSetPaletteImpl(ShapeManager shapeManager, LienzoHoverPaletteView view, DefinitionGlyphTooltip definitionGlyphTooltip, LienzoGlyphsHoverPalette glyphsFloatingPalette) {
        super(shapeManager, definitionGlyphTooltip, view);
        this.glyphsFloatingPalette = glyphsFloatingPalette;
    }

    @PostConstruct
    public void init() {
        super.doInit();
        this.onShowGlyTooltip((glyphTooltip, item, mouseX, mouseY, itemX, itemY) -> {
            if (!this.hasPaletteItems(item)) {
                glyphTooltip.show(this.getGlyphTooltipText(item), mouseX, mouseY, GlyphTooltip.Direction.WEST);
            }
            return false;
        });
        this.glyphsFloatingPalette.setExpandable(false);
        this.glyphsFloatingPalette.setLayout(LienzoPalette.Layout.HORIZONTAL);
        this.glyphsFloatingPalette.onClose(this.floatingPaletteCloseCallback);
        this.glyphsFloatingPalette.onShowGlyTooltip(this.floatingPaletteGlyphTooltipCallback);
    }

    protected void doItemHover(String id, double mouseX, double mouseY, double itemX, double itemY) {
        super.doItemHover(id, mouseX, mouseY, itemX, itemY);
        this.showFloatingPalette(id, mouseX, mouseY, itemX, itemY);
    }

    private String getGlyphTooltipText(GlyphPaletteItem item) {
        return "Create a " + item.getTitle();
    }

    @Override
    protected void doBind() {
        this.items.clear();
        DefinitionSetPalette definitionSetPalette = (DefinitionSetPalette)this.paletteDefinition;
        String ssid = this.shapeManager.getDefaultShapeSet(((DefinitionSetPalette)this.paletteDefinition).getDefinitionSetId()).getId();
        this.glyphsFloatingPalette.setShapeSetId(ssid);
        List categories = definitionSetPalette.getItems();
        if (null != categories && !categories.isEmpty()) {
            PaletteGrid grid = this.getGrid();
            for (DefinitionPaletteCategory category : categories) {
                List categoryItems = category.getItems();
                if (null == categoryItems || categoryItems.isEmpty()) continue;
                for (GlyphPaletteItem item : categoryItems) {
                    this.addGlyphItemIntoView(item, grid);
                    this.items.add(item);
                }
            }
        }
    }

    @Override
    public List<GlyphPaletteItem> getItems() {
        return this.items;
    }

    @Override
    protected void doDestroy() {
        super.doDestroy();
    }

    private boolean showFloatingPalette(String id, double x, double y, double itemX, double itemY) {
        GlyphPaletteItem item = this.getItem(id);
        if (this.hasPaletteItems(item)) {
            final HasPaletteItems hasPaletteItems = (HasPaletteItems)item;
            this.glyphsFloatingPalette.setIconSize(this.getIconSize());
            this.glyphsFloatingPalette.setPadding(this.getPadding());
            this.glyphsFloatingPalette.bind(hasPaletteItems);
            int[] mainPaletteSize = this.getMainPaletteSize();
            double pX = ((LienzoHoverPaletteView)this.getView()).getX() + (double)mainPaletteSize[0] - (double)this.getPadding() * 1.5 - (double)this.getIconSize();
            double pY = ((LienzoHoverPaletteView)this.getView()).getY() + itemY - (double)(this.getPadding() * 3) + (double)(this.getIconSize() / 2);
            Layer paletteLayer = ((LienzoHoverPaletteView)this.getView()).getLayer();
            ((LienzoHoverPaletteView)((LienzoHoverPaletteView)((LienzoHoverPaletteView)this.glyphsFloatingPalette.getView()).attach(paletteLayer)).setX(pX)).setY(pY);
            this.glyphsFloatingPalette.onItemHover((id12, mouseX, mouseY, itemX12, itemY12) -> {
                ((LienzoHoverPaletteView)this.getView()).clearTimeOut();
                return true;
            });
            this.glyphsFloatingPalette.onItemOut(id13 -> {
                ((LienzoHoverPaletteView)this.getView()).startTimeOut();
                return false;
            });
            this.glyphsFloatingPalette.onItemClick(new Palette.ItemClickCallback(){

                public boolean onItemClick(String id14, double mouseX, double mouseY, double itemX, double itemY) {
                    GlyphPaletteItem item1 = LienzoDefinitionSetPaletteImpl.this.getPaletteItem(id14, hasPaletteItems.getItems());
                    if (!LienzoDefinitionSetPaletteImpl.this.hasPaletteItems(item1)) {
                        LienzoDefinitionSetPaletteImpl.this.onItemClick(id14, mouseX, mouseY, ((LienzoHoverPaletteView)LienzoDefinitionSetPaletteImpl.this.getView()).getX(), ((LienzoHoverPaletteView)LienzoDefinitionSetPaletteImpl.this.getView()).getY());
                    }
                    LienzoDefinitionSetPaletteImpl.this.clearFloatingPalette();
                    return true;
                }
            });
            ((LienzoHoverPaletteView)this.glyphsFloatingPalette.getView()).show();
            return false;
        }
        return true;
    }

    @Override
    protected String getPaletteItemId(int index) {
        GlyphPaletteItem item = this.getMainPaletteItem(index);
        return null != item ? item.getId() : null;
    }

    private void clearFloatingPalette() {
        ((LienzoHoverPaletteView)this.glyphsFloatingPalette.getView()).clear();
    }

    private void hideFloatingPalette() {
        ((LienzoHoverPaletteView)this.glyphsFloatingPalette.getView()).hide();
    }

    private int[] getMainPaletteSize() {
        double width = 0.0;
        double height = 0.0;
        if (null != this.paletteDefinition) {
            List<GlyphPaletteItem> items = this.getItems();
            int itemsSize = null != items ? items.size() : 0;
            double[] mainPaletteSize = ClientPaletteUtils.computeSizeForVerticalLayout((int)itemsSize, (int)this.getIconSize(), (int)this.getPadding(), (int)0);
            width = mainPaletteSize[0];
            height = mainPaletteSize[1];
        }
        return new int[]{(int)width, (int)height};
    }

    private boolean hasPaletteItems(GlyphPaletteItem item) {
        return item instanceof HasPaletteItems;
    }

    private GlyphPaletteItem getMainPaletteItem(int index) {
        return this.getItems().get(index);
    }

    private GlyphPaletteItem getPaletteItem(String id, List<GlyphPaletteItem> items) {
        if (null != items && !items.isEmpty()) {
            for (GlyphPaletteItem item : items) {
                if (!item.getId().equals(id)) continue;
                return item;
            }
        }
        return null;
    }

    private int getPadding() {
        return this.getGrid().getPadding();
    }

    private int getIconSize() {
        return this.getGrid().getIconSize();
    }
}

