/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.shape.view;

import com.ait.lienzo.client.core.shape.AbstractDirectionalMultiPointShape;
import com.ait.lienzo.client.core.shape.MultiPathDecorator;
import com.ait.lienzo.client.core.shape.OrthogonalPolyLine;
import com.ait.lienzo.client.core.shape.wires.MagnetManager;
import com.ait.lienzo.client.core.shape.wires.WiresConnector;
import com.ait.lienzo.client.core.shape.wires.WiresMagnet;
import com.ait.lienzo.client.core.shape.wires.WiresShape;
import com.ait.lienzo.client.core.shape.wires.handlers.WiresConnectorControl;
import com.ait.lienzo.client.core.types.DragBounds;
import com.ait.lienzo.client.core.types.Point2DArray;
import com.ait.lienzo.shared.core.types.ColorName;
import com.ait.lienzo.shared.core.types.IColor;
import org.kie.workbench.common.stunner.client.lienzo.canvas.wires.WiresUtils;
import org.kie.workbench.common.stunner.core.client.canvas.Point2D;
import org.kie.workbench.common.stunner.core.client.shape.view.HasControlPoints;
import org.kie.workbench.common.stunner.core.client.shape.view.IsConnector;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeView;
import org.kie.workbench.common.stunner.core.client.shape.view.event.HandlerRegistrationImpl;

public abstract class AbstractConnectorView<T>
extends WiresConnector
implements ShapeView<T>,
IsConnector<T>,
HasControlPoints<T> {
    protected String uuid;
    private int zindex;
    private WiresConnectorControl connectorControl;
    private final HandlerRegistrationImpl handlerRegistration = new HandlerRegistrationImpl();

    public AbstractConnectorView(AbstractDirectionalMultiPointShape<?> line, MultiPathDecorator headDecorator, MultiPathDecorator tailDecorator) {
        super(line, headDecorator, tailDecorator);
        this.init();
    }

    public AbstractConnectorView(WiresMagnet headMagnet, WiresMagnet tailMagnet, AbstractDirectionalMultiPointShape<?> line, MultiPathDecorator headDecorator, MultiPathDecorator tailDecorator) {
        super(headMagnet, tailMagnet, line, headDecorator, tailDecorator);
        this.init();
    }

    protected abstract void doDestroy();

    private void init() {
        ((AbstractDirectionalMultiPointShape)this.getLine().setFillColor((IColor)ColorName.WHITE)).setStrokeWidth(0.0);
    }

    public T setUUID(String uuid) {
        this.uuid = uuid;
        this.getGroup().setUserData((Object)("stunner:" + uuid));
        return (T)((Object)this);
    }

    public String getUUID() {
        return this.uuid;
    }

    public T setZIndex(int zindez) {
        this.zindex = zindez;
        return (T)((Object)this);
    }

    public int getZIndex() {
        return this.zindex;
    }

    public T setControl(WiresConnectorControl connectorControl) {
        this.connectorControl = connectorControl;
        return (T)((Object)this);
    }

    public WiresConnectorControl getControl() {
        return this.connectorControl;
    }

    public T connect(ShapeView headShapeView, int _headMagnetsIndex, ShapeView tailShapeView, int _tailMagnetsIndex, boolean tailArrow, boolean headArrow) {
        WiresShape headWiresShape = (WiresShape)headShapeView;
        WiresShape tailWiresShape = (WiresShape)tailShapeView;
        MagnetManager.Magnets headMagnets = headWiresShape.getMagnets();
        MagnetManager.Magnets tailMagnets = tailWiresShape.getMagnets();
        int headMagnetsIndex = _headMagnetsIndex;
        int tailMagnetsIndex = _tailMagnetsIndex;
        if (headMagnetsIndex < 0) {
            headMagnetsIndex = 0;
        }
        if (tailMagnetsIndex < 0) {
            tailMagnetsIndex = 0;
        }
        WiresMagnet m0_1 = headMagnets.getMagnet(headMagnetsIndex);
        WiresMagnet m1_1 = tailMagnets.getMagnet(tailMagnetsIndex);
        this.setHeadMagnet(m0_1);
        this.setTailMagnet(m1_1);
        return (T)((Object)this);
    }

    private OrthogonalPolyLine createLine(double ... points) {
        return (OrthogonalPolyLine)new OrthogonalPolyLine(Point2DArray.fromArrayOfDouble((double[])points)).setCornerRadius(5.0).setDraggable(true);
    }

    public void removeFromParent() {
        super.removeFromLayer();
    }

    public double getShapeX() {
        return this.getGroup().getX();
    }

    public double getShapeY() {
        return this.getGroup().getY();
    }

    public T setShapeX(double x) {
        this.getGroup().setX(x);
        return (T)((Object)this);
    }

    public T setShapeY(double y) {
        this.getGroup().setY(y);
        return (T)((Object)this);
    }

    public Point2D getShapeAbsoluteLocation() {
        return WiresUtils.getAbsolute(this.getGroup());
    }

    public String getFillColor() {
        return this.getLine().getFillColor();
    }

    public T setFillColor(String color) {
        this.getLine().setFillColor(color);
        return (T)((Object)this);
    }

    public double getFillAlpha() {
        return this.getLine().getFillAlpha();
    }

    public T setFillAlpha(double alpha) {
        this.getLine().setFillAlpha(alpha);
        return (T)((Object)this);
    }

    public String getStrokeColor() {
        return this.getLine().getStrokeColor();
    }

    public T setStrokeColor(String color) {
        this.getLine().setStrokeColor(color);
        return (T)((Object)this);
    }

    public double getStrokeAlpha() {
        return this.getLine().getStrokeAlpha();
    }

    public T setStrokeAlpha(double alpha) {
        this.getLine().setStrokeAlpha(alpha);
        return (T)((Object)this);
    }

    public double getStrokeWidth() {
        return this.getLine().getStrokeWidth();
    }

    public T setStrokeWidth(double width) {
        this.getLine().setStrokeWidth(width);
        return (T)((Object)this);
    }

    public T setDragBounds(double x1, double y1, double x2, double y2) {
        this.getGroup().setDragBounds(new DragBounds(x1, y1, x2, y2));
        return (T)((Object)this);
    }

    public T moveToTop() {
        this.getLine().moveToTop();
        return (T)((Object)this);
    }

    public T moveToBottom() {
        this.getLine().moveToBottom();
        return (T)((Object)this);
    }

    public T moveUp() {
        this.getLine().moveUp();
        return (T)((Object)this);
    }

    public T moveDown() {
        this.getLine().moveDown();
        return (T)((Object)this);
    }

    public T showControlPoints(HasControlPoints.ControlPointType type) {
        if (null != this.getControl()) {
            if (HasControlPoints.ControlPointType.MAGNET.equals((Object)type)) {
                this.getControl().showControlPoints();
            } else {
                throw new UnsupportedOperationException("Control point type [" + type + "] not supported yet");
            }
        }
        return (T)((Object)this);
    }

    public T hideControlPoints() {
        if (null != this.getControl()) {
            this.setStrokeWidth(this.getStrokeWidth() / 2.0);
        }
        return (T)((Object)this);
    }

    public boolean areControlsVisible() {
        return this.getPointHandles().isVisible();
    }

    public void destroy() {
        this.handlerRegistration.removeHandler();
        this.doDestroy();
        this.removeFromParent();
        this.connectorControl = null;
    }

    protected void enableShowControlsOnMouseEnter() {
        this.handlerRegistration.register(this.getLine().addNodeMouseEnterHandler(nodeMouseEnterEvent -> this.showControlPoints(HasControlPoints.ControlPointType.MAGNET)));
        if (null != this.getHead()) {
            this.handlerRegistration.register(this.getHead().addNodeMouseEnterHandler(nodeMouseEnterEvent -> this.showControlPoints(HasControlPoints.ControlPointType.MAGNET)));
        }
        if (null != this.getTail()) {
            this.handlerRegistration.register(this.getTail().addNodeMouseEnterHandler(nodeMouseEnterEvent -> this.showControlPoints(HasControlPoints.ControlPointType.MAGNET)));
        }
    }
}

