/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.shape.view;

import com.ait.lienzo.client.core.event.AbstractNodeGestureEvent;
import com.ait.lienzo.client.core.event.AbstractNodeTouchEvent;
import com.ait.lienzo.client.core.event.NodeGestureChangeEvent;
import com.ait.lienzo.client.core.event.NodeGestureChangeHandler;
import com.ait.lienzo.client.core.event.NodeGestureEndEvent;
import com.ait.lienzo.client.core.event.NodeGestureEndHandler;
import com.ait.lienzo.client.core.event.NodeGestureStartEvent;
import com.ait.lienzo.client.core.event.NodeGestureStartHandler;
import com.ait.lienzo.client.core.event.TouchPoint;
import com.ait.lienzo.client.core.shape.Node;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Timer;
import java.util.HashMap;
import java.util.Map;
import org.kie.workbench.common.stunner.core.client.shape.view.event.GestureEvent;
import org.kie.workbench.common.stunner.core.client.shape.view.event.GestureEventImpl;
import org.kie.workbench.common.stunner.core.client.shape.view.event.GestureHandler;
import org.kie.workbench.common.stunner.core.client.shape.view.event.HandlerRegistrationImpl;
import org.kie.workbench.common.stunner.core.client.shape.view.event.MouseClickEvent;
import org.kie.workbench.common.stunner.core.client.shape.view.event.MouseDoubleClickEvent;
import org.kie.workbench.common.stunner.core.client.shape.view.event.TouchEvent;
import org.kie.workbench.common.stunner.core.client.shape.view.event.TouchEventImpl;
import org.kie.workbench.common.stunner.core.client.shape.view.event.TouchHandler;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewEvent;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewEventType;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewHandler;

public class ViewEventHandlerManager {
    private static final int CLICK_HANDLER_TIMER_DURATION = 150;
    protected final HandlerRegistrationImpl registrationManager = new HandlerRegistrationImpl();
    protected final Map<ViewEventType, HandlerRegistration[]> registrationMap = new HashMap<ViewEventType, HandlerRegistration[]>();
    private final Node<?> node;
    private final ViewEventType[] supportedTypes;
    private boolean enabled;
    private boolean fireClickHandler;

    public ViewEventHandlerManager(Node<?> node, ViewEventType ... supportedTypes) {
        this.node = node;
        this.supportedTypes = supportedTypes;
        this.fireClickHandler = true;
        this.enable();
    }

    public void enable() {
        this.enabled = true;
    }

    public void disable() {
        this.enabled = false;
    }

    private boolean isEnabled() {
        return this.enabled;
    }

    public boolean supports(ViewEventType type) {
        if (null != this.supportedTypes) {
            for (ViewEventType type1 : this.supportedTypes) {
                if (!type.equals((Object)type1)) continue;
                return true;
            }
        }
        return false;
    }

    public void addHandler(ViewEventType type, ViewHandler<? extends ViewEvent> eventHandler) {
        if (this.supports(type)) {
            HandlerRegistration[] registrations = this.doAddHandler(type, eventHandler);
            this.addHandlersRegistration(type, registrations);
        }
    }

    public void addHandlersRegistration(ViewEventType type, HandlerRegistration ... registrations) {
        if (null != registrations && registrations.length > 0) {
            this.registrationMap.put(type, registrations);
            for (HandlerRegistration registration : registrations) {
                this.registrationManager.register(registration);
            }
        }
    }

    protected HandlerRegistration[] doAddHandler(ViewEventType type, ViewHandler<? extends ViewEvent> eventHandler) {
        if (ViewEventType.MOUSE_CLICK.equals((Object)type)) {
            return this.registerClickHandler(eventHandler);
        }
        if (ViewEventType.MOUSE_DBL_CLICK.equals((Object)type)) {
            return this.registerDoubleClickHandler(eventHandler);
        }
        if (ViewEventType.TOUCH.equals((Object)type)) {
            return this.registerTouchHandler((TouchHandler)eventHandler);
        }
        if (ViewEventType.GESTURE.equals((Object)type)) {
            return this.registerGestureHandler((GestureHandler)eventHandler);
        }
        return null;
    }

    public void removeHandler(ViewHandler<? extends ViewEvent> eventHandler) {
        HandlerRegistration[] registrations;
        ViewEventType type = eventHandler.getType();
        if (this.registrationMap.containsKey(type) && null != (registrations = this.registrationMap.get(type)) && registrations.length > 0) {
            for (HandlerRegistration registration : registrations) {
                this.registrationManager.deregister(registration);
            }
        }
    }

    public void destroy() {
        this.fireClickHandler = true;
        this.registrationManager.removeHandler();
        this.registrationMap.clear();
    }

    protected HandlerRegistration[] registerGestureHandler(final GestureHandler gestureHandler) {
        HandlerRegistration gestureStartReg = this.node.addNodeGestureStartHandler(new NodeGestureStartHandler(){

            public void onNodeGestureStart(NodeGestureStartEvent event) {
                GestureEventImpl event1;
                if (ViewEventHandlerManager.this.isEnabled() && null != (event1 = ViewEventHandlerManager.this.buildGestureEvent((AbstractNodeGestureEvent)event))) {
                    gestureHandler.start((GestureEvent)event1);
                }
            }
        });
        HandlerRegistration gestureChangeReg = this.node.addNodeGestureChangeHandler(new NodeGestureChangeHandler(){

            public void onNodeGestureChange(NodeGestureChangeEvent event) {
                GestureEventImpl event1;
                if (ViewEventHandlerManager.this.isEnabled() && null != (event1 = ViewEventHandlerManager.this.buildGestureEvent((AbstractNodeGestureEvent)event))) {
                    gestureHandler.change((GestureEvent)event1);
                }
            }
        });
        HandlerRegistration gestureEndReg = this.node.addNodeGestureEndHandler(new NodeGestureEndHandler(){

            public void onNodeGestureEnd(NodeGestureEndEvent event) {
                GestureEventImpl event1;
                if (ViewEventHandlerManager.this.isEnabled() && null != (event1 = ViewEventHandlerManager.this.buildGestureEvent((AbstractNodeGestureEvent)event))) {
                    gestureHandler.end((GestureEvent)event1);
                }
            }
        });
        return new HandlerRegistration[]{gestureStartReg, gestureChangeReg, gestureEndReg};
    }

    protected GestureEventImpl buildGestureEvent(AbstractNodeGestureEvent event) {
        return new GestureEventImpl(event.getScale(), event.getRotation());
    }

    protected HandlerRegistration[] registerClickHandler(final ViewHandler<ViewEvent> eventHandler) {
        return new HandlerRegistration[]{this.node.addNodeMouseClickHandler(nodeMouseClickEvent -> {
            if (this.isEnabled()) {
                this.fireClickHandler = true;
                final int x = nodeMouseClickEvent.getX();
                final int y = nodeMouseClickEvent.getY();
                final int clientX = nodeMouseClickEvent.getMouseEvent().getClientX();
                final int clientY = nodeMouseClickEvent.getMouseEvent().getClientY();
                final boolean isShiftKeyDown = nodeMouseClickEvent.isShiftKeyDown();
                final boolean isAltKeyDown = nodeMouseClickEvent.isAltKeyDown();
                final boolean isMetaKeyDown = nodeMouseClickEvent.isMetaKeyDown();
                final boolean isButtonLeft = nodeMouseClickEvent.isButtonLeft();
                final boolean isButtonMiddle = nodeMouseClickEvent.isButtonMiddle();
                final boolean isButtonRight = nodeMouseClickEvent.isButtonRight();
                new Timer(){

                    public void run() {
                        if (ViewEventHandlerManager.this.fireClickHandler) {
                            ViewEventHandlerManager.this.onMouseClick((ViewHandler<ViewEvent>)eventHandler, x, y, clientX, clientY, isShiftKeyDown, isAltKeyDown, isMetaKeyDown, isButtonLeft, isButtonMiddle, isButtonRight);
                        }
                    }
                }.schedule(150);
            }
        })};
    }

    protected HandlerRegistration[] registerDoubleClickHandler(ViewHandler<ViewEvent> eventHandler) {
        return new HandlerRegistration[]{this.node.addNodeMouseDoubleClickHandler(nodeMouseDoubleClickEvent -> {
            if (this.isEnabled()) {
                this.fireClickHandler = false;
                MouseDoubleClickEvent event = new MouseDoubleClickEvent((double)nodeMouseDoubleClickEvent.getX(), (double)nodeMouseDoubleClickEvent.getY(), (double)nodeMouseDoubleClickEvent.getMouseEvent().getClientX(), (double)nodeMouseDoubleClickEvent.getMouseEvent().getClientY());
                event.setShiftKeyDown(nodeMouseDoubleClickEvent.isShiftKeyDown());
                event.setAltKeyDown(nodeMouseDoubleClickEvent.isAltKeyDown());
                event.setMetaKeyDown(nodeMouseDoubleClickEvent.isMetaKeyDown());
                event.setButtonLeft(nodeMouseDoubleClickEvent.isButtonLeft());
                event.setButtonMiddle(nodeMouseDoubleClickEvent.isButtonMiddle());
                event.setButtonRight(nodeMouseDoubleClickEvent.isButtonRight());
                eventHandler.handle((ViewEvent)event);
                this.fireClickHandler = true;
            }
        })};
    }

    private void onMouseClick(ViewHandler<ViewEvent> eventHandler, int x, int y, int clientX, int clientY, boolean isShiftKeyDown, boolean isAltKeyDown, boolean isMetaKeyDown, boolean isButtonLeft, boolean isButtonMiddle, boolean isButtonRight) {
        MouseClickEvent event = new MouseClickEvent((double)x, (double)y, (double)clientX, (double)clientY);
        event.setShiftKeyDown(isShiftKeyDown);
        event.setAltKeyDown(isAltKeyDown);
        event.setMetaKeyDown(isMetaKeyDown);
        event.setButtonLeft(isButtonLeft);
        event.setButtonMiddle(isButtonMiddle);
        event.setButtonRight(isButtonRight);
        eventHandler.handle((ViewEvent)event);
    }

    protected HandlerRegistration[] registerTouchHandler(TouchHandler touchHandler) {
        HandlerRegistration touchStartReg = this.node.addNodeTouchStartHandler(event -> {
            TouchEventImpl event1;
            if (this.isEnabled() && null != (event1 = this.buildTouchEvent((AbstractNodeTouchEvent)event))) {
                touchHandler.start((TouchEvent)event1);
            }
        });
        HandlerRegistration touchMoveReg = this.node.addNodeTouchMoveHandler(event -> {
            TouchEventImpl event1;
            if (this.isEnabled() && null != (event1 = this.buildTouchEvent((AbstractNodeTouchEvent)event))) {
                touchHandler.move((TouchEvent)event1);
            }
        });
        HandlerRegistration touchEndReg = this.node.addNodeTouchEndHandler(event -> {
            TouchEventImpl event1;
            if (this.isEnabled() && null != (event1 = this.buildTouchEvent((AbstractNodeTouchEvent)event))) {
                touchHandler.end((TouchEvent)event1);
            }
        });
        HandlerRegistration touchCancelReg = this.node.addNodeTouchCancelHandler(event -> {
            TouchEventImpl event1;
            if (this.isEnabled() && null != (event1 = this.buildTouchEvent((AbstractNodeTouchEvent)event))) {
                touchHandler.cancel((TouchEvent)event1);
            }
        });
        return new HandlerRegistration[]{touchStartReg, touchMoveReg, touchEndReg, touchCancelReg};
    }

    private TouchEventImpl buildTouchEvent(AbstractNodeTouchEvent event) {
        TouchPoint touchPoint;
        TouchPoint touchPoint2 = touchPoint = null != event.getTouches() && !event.getTouches().isEmpty() ? (TouchPoint)event.getTouches().get(0) : null;
        if (null != touchPoint) {
            int tx = touchPoint.getX();
            int ty = touchPoint.getY();
            return new TouchEventImpl((double)event.getX(), (double)event.getY(), (double)tx, (double)ty);
        }
        return null;
    }
}

