/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.canvas.controls.connection;

import com.ait.lienzo.client.core.shape.wires.IConnectionAcceptor;
import com.ait.lienzo.client.core.shape.wires.MagnetManager;
import com.ait.lienzo.client.core.shape.wires.WiresConnection;
import com.ait.lienzo.client.core.shape.wires.WiresContainer;
import com.ait.lienzo.client.core.shape.wires.WiresMagnet;
import com.ait.lienzo.client.core.shape.wires.WiresShape;
import com.google.gwt.logging.client.LogConfiguration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.client.lienzo.canvas.wires.WiresCanvas;
import org.kie.workbench.common.stunner.client.lienzo.canvas.wires.WiresUtils;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.connection.ConnectionAcceptorControl;
import org.kie.workbench.common.stunner.core.client.canvas.util.CanvasHighlight;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandFactory;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandManager;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.client.command.RequiresCommandManager;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.util.CommandUtils;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;

@Dependent
public class ConnectionAcceptorControlImpl
implements ConnectionAcceptorControl<AbstractCanvasHandler> {
    private static Logger LOGGER = Logger.getLogger(ConnectionAcceptorControlImpl.class.getName());
    CanvasCommandFactory<AbstractCanvasHandler> canvasCommandFactory;
    private RequiresCommandManager.CommandManagerProvider<AbstractCanvasHandler> provider;
    private AbstractCanvasHandler canvasHandler;
    private CanvasHighlight canvasHighlight;
    private final IConnectionAcceptor CONNECTION_ACCEPTOR = new IConnectionAcceptor(){

        public boolean acceptHead(WiresConnection head, WiresMagnet magnet) {
            ConnectionAcceptorControlImpl.this.log(Level.FINE, "## Accept Head ##");
            Edge edge = WiresUtils.getEdge(ConnectionAcceptorControlImpl.this.canvasHandler, head.getConnector());
            Node sourceNode = WiresUtils.getNode(ConnectionAcceptorControlImpl.this.canvasHandler, magnet);
            int mIndex = this.getMagnetIndex(magnet);
            String sourceUUID = sourceNode != null ? sourceNode.getUUID() : null;
            String message = "Executed SetConnectionSourceNodeCommand [source=" + sourceUUID + ", magnet=" + mIndex + "]";
            ConnectionAcceptorControlImpl.this.log(Level.FINE, message);
            return ConnectionAcceptorControlImpl.this.acceptSource(sourceNode, edge, mIndex);
        }

        public boolean acceptTail(WiresConnection tail, WiresMagnet magnet) {
            ConnectionAcceptorControlImpl.this.log(Level.FINE, "## Accept tail ##");
            WiresConnection head = tail.getConnector().getHeadConnection();
            Edge edge = WiresUtils.getEdge(ConnectionAcceptorControlImpl.this.canvasHandler, head.getConnector());
            Node targetNode = WiresUtils.getNode(ConnectionAcceptorControlImpl.this.canvasHandler, magnet);
            int mIndex = this.getMagnetIndex(magnet);
            String targetUUID = targetNode != null ? targetNode.getUUID() : null;
            String message = "Executed SetConnectionTargetNodeCommand [target=" + targetUUID + ", magnet=" + mIndex + "]";
            ConnectionAcceptorControlImpl.this.log(Level.FINE, message);
            return ConnectionAcceptorControlImpl.this.acceptTarget(targetNode, edge, mIndex);
        }

        public boolean headConnectionAllowed(WiresConnection head, WiresShape shape) {
            ConnectionAcceptorControlImpl.this.log(Level.FINE, "## Allow Head ##");
            Edge edge = WiresUtils.getEdge(ConnectionAcceptorControlImpl.this.canvasHandler, head.getConnector());
            Node sourceNode = WiresUtils.getNode(ConnectionAcceptorControlImpl.this.canvasHandler, (WiresContainer)shape);
            boolean b = ConnectionAcceptorControlImpl.this.allowSource(sourceNode, edge, 0);
            String nUUID = null != sourceNode ? sourceNode.getUUID() : "null";
            ConnectionAcceptorControlImpl.this.log(Level.FINE, "  Is head allowed [" + nUUID + "] = " + b);
            return b;
        }

        public boolean tailConnectionAllowed(WiresConnection tail, WiresShape shape) {
            ConnectionAcceptorControlImpl.this.log(Level.FINE, "## Allow tail ##");
            Edge edge = WiresUtils.getEdge(ConnectionAcceptorControlImpl.this.canvasHandler, tail.getConnector());
            Node targetNode = WiresUtils.getNode(ConnectionAcceptorControlImpl.this.canvasHandler, (WiresContainer)shape);
            boolean b = ConnectionAcceptorControlImpl.this.allowTarget(targetNode, edge, 0);
            String nUUID = null != targetNode ? targetNode.getUUID() : "null";
            ConnectionAcceptorControlImpl.this.log(Level.FINE, "  Is tail allowed [" + nUUID + "] = " + b);
            return b;
        }

        private int getMagnetIndex(WiresMagnet magnet) {
            if (null != magnet) {
                MagnetManager.Magnets magnets = magnet.getMagnets();
                for (int x = 0; x < magnets.size(); ++x) {
                    WiresMagnet _m = magnets.getMagnet(x);
                    if (!_m.equals(magnet)) continue;
                    return x;
                }
            }
            return -1;
        }
    };

    @Inject
    public ConnectionAcceptorControlImpl(CanvasCommandFactory<AbstractCanvasHandler> canvasCommandFactory) {
        this.canvasCommandFactory = canvasCommandFactory;
    }

    public void enable(AbstractCanvasHandler canvasHandler) {
        this.canvasHandler = canvasHandler;
        this.canvasHighlight = new CanvasHighlight(canvasHandler);
        WiresCanvas.View canvasView = (WiresCanvas.View)canvasHandler.getAbstractCanvas().getView();
        canvasView.setConnectionAcceptor(this.CONNECTION_ACCEPTOR);
    }

    public void disable() {
        if (null != this.canvasHandler && null != this.canvasHandler.getCanvas()) {
            WiresCanvas.View canvasView = (WiresCanvas.View)this.canvasHandler.getAbstractCanvas().getView();
            canvasView.setConnectionAcceptor(IConnectionAcceptor.NONE);
        }
        this.canvasHighlight.destroy();
        this.canvasHighlight = null;
        this.canvasHandler = null;
    }

    public boolean allowSource(Node source, Edge<View<?>, Node> connector, int magnet) {
        if (null == this.canvasHandler) {
            return false;
        }
        boolean eq = ConnectionAcceptorControlImpl.eq(source, connector.getSourceNode());
        if (!eq) {
            CommandResult violations = this.getCommandManager().allow((Object)this.canvasHandler, (Command)this.canvasCommandFactory.setSourceNode(source, connector, magnet));
            boolean accepts = this.isAccept((CommandResult<CanvasViolation>)violations);
            this.highlight(source, connector, accepts);
            return accepts;
        }
        return true;
    }

    public boolean allowTarget(Node target, Edge<View<?>, Node> connector, int magnet) {
        if (null == this.canvasHandler) {
            return false;
        }
        boolean eq = ConnectionAcceptorControlImpl.eq(target, connector.getTargetNode());
        if (!eq) {
            CommandResult violations = this.getCommandManager().allow((Object)this.canvasHandler, (Command)this.canvasCommandFactory.setTargetNode(target, connector, magnet));
            boolean accepts = this.isAccept((CommandResult<CanvasViolation>)violations);
            this.highlight(target, connector, accepts);
            return accepts;
        }
        return true;
    }

    public boolean acceptSource(Node source, Edge<View<?>, Node> connector, int magnet) {
        if (null == this.canvasHandler) {
            return false;
        }
        boolean eq = ConnectionAcceptorControlImpl.eq(source, connector.getSourceNode());
        if (!eq) {
            this.ensureUnHighLight();
            CommandResult violations = this.getCommandManager().execute((Object)this.canvasHandler, (Command)this.canvasCommandFactory.setSourceNode(source, connector, magnet));
            return this.isAccept((CommandResult<CanvasViolation>)violations);
        }
        return true;
    }

    public boolean acceptTarget(Node target, Edge<View<?>, Node> connector, int magnet) {
        if (null == this.canvasHandler) {
            return false;
        }
        boolean eq = ConnectionAcceptorControlImpl.eq(target, connector.getTargetNode());
        if (!eq) {
            this.ensureUnHighLight();
            CommandResult violations = this.getCommandManager().execute((Object)this.canvasHandler, (Command)this.canvasCommandFactory.setTargetNode(target, connector, magnet));
            return this.isAccept((CommandResult<CanvasViolation>)violations);
        }
        return true;
    }

    private static boolean eq(Node n1, Node n2) {
        if (n1 == null && n2 == null) {
            return true;
        }
        return null != n1 && n1.equals(n2);
    }

    private boolean isAccept(CommandResult<CanvasViolation> result) {
        return !CommandUtils.isError(result);
    }

    private void highlight(Node node, Edge<View<?>, Node> connector, boolean valid) {
        this.canvasHighlight.unhighLight();
        if (null != node && valid) {
            this.canvasHighlight.highLight(connector);
            this.canvasHighlight.highLight((Element)node);
        } else if (null != node) {
            this.canvasHighlight.invalid(connector);
            this.canvasHighlight.invalid((Element)node);
        }
    }

    private void ensureUnHighLight() {
        if (null != this.canvasHighlight) {
            this.canvasHighlight.unhighLight();
        }
    }

    private void log(Level level, String message) {
        if (LogConfiguration.loggingIsEnabled()) {
            LOGGER.log(level, message);
        }
    }

    public void setCommandManagerProvider(RequiresCommandManager.CommandManagerProvider<AbstractCanvasHandler> provider) {
        this.provider = provider;
    }

    private CanvasCommandManager<AbstractCanvasHandler> getCommandManager() {
        return this.provider.getCommandManager();
    }
}

