/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.components.glyph;

import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.shape.Layer;
import com.ait.lienzo.client.widget.LienzoPanel;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.MouseMoveEvent;
import com.google.gwt.event.dom.client.MouseMoveHandler;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.event.dom.client.MouseUpHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.context.Dependent;
import org.kie.workbench.common.stunner.core.client.components.glyph.ShapeGlyphDragHandler;
import org.kie.workbench.common.stunner.core.client.shape.view.glyph.Glyph;

@Dependent
public class ShapeGlyphDragHandlerImpl
implements ShapeGlyphDragHandler<Group> {
    private static final int ZINDEX = Integer.MAX_VALUE;

    public void show(Glyph<Group> shapeGlyph, double x, double y, ShapeGlyphDragHandler.Callback callback) {
        double proxyWidth = shapeGlyph.getWidth();
        double proxyHeight = shapeGlyph.getHeight();
        Group dragShape = (Group)shapeGlyph.getGroup();
        dragShape.setX(proxyWidth / 2.0);
        dragShape.setY(proxyHeight / 2.0);
        LienzoPanel dragProxyPanel = new LienzoPanel((int)proxyWidth * 2, (int)proxyHeight * 2);
        dragProxyPanel.getElement().getStyle().setCursor(Style.Cursor.MOVE);
        Layer dragProxyLayer = new Layer();
        dragProxyLayer.add((IPrimitive)dragShape);
        dragProxyPanel.add(dragProxyLayer);
        dragProxyLayer.batch();
        this.setDragProxyPosition(dragProxyPanel, proxyWidth, proxyHeight, x, y);
        this.attachDragProxyHandlers(dragProxyPanel, callback);
        RootPanel.get().add((Widget)dragProxyPanel);
    }

    private void setDragProxyPosition(LienzoPanel dragProxyPanel, double proxyWidth, double proxyHeight, double x, double y) {
        Style style = dragProxyPanel.getElement().getStyle();
        style.setPosition(Style.Position.ABSOLUTE);
        style.setLeft(x - proxyWidth / 2.0, Style.Unit.PX);
        style.setTop(y - proxyHeight / 2.0, Style.Unit.PX);
        style.setZIndex(Integer.MAX_VALUE);
    }

    private void attachDragProxyHandlers(final LienzoPanel floatingPanel, final ShapeGlyphDragHandler.Callback callback) {
        HandlerRegistration[] handlerRegs;
        final Style style = floatingPanel.getElement().getStyle();
        handlerRegs = new HandlerRegistration[]{RootPanel.get().addDomHandler((EventHandler)new MouseMoveHandler(){

            public void onMouseMove(MouseMoveEvent mouseMoveEvent) {
                style.setLeft((double)(mouseMoveEvent.getX() - floatingPanel.getWidth() / 2), Style.Unit.PX);
                style.setTop((double)(mouseMoveEvent.getY() - floatingPanel.getHeight() / 2), Style.Unit.PX);
                double x = mouseMoveEvent.getX();
                double y = mouseMoveEvent.getY();
                callback.onMove(x, y);
            }
        }, MouseMoveEvent.getType()), RootPanel.get().addDomHandler((EventHandler)new MouseUpHandler(){

            public void onMouseUp(MouseUpEvent mouseUpEvent) {
                handlerRegs[0].removeHandler();
                handlerRegs[1].removeHandler();
                RootPanel.get().remove((Widget)floatingPanel);
                double x = mouseUpEvent.getX();
                double y = mouseUpEvent.getY();
                callback.onComplete(x, y);
            }
        }, MouseUpEvent.getType())};
    }
}

