/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.components.palette.impl;

import java.util.LinkedList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.client.lienzo.components.palette.AbstractLienzoGlyphItemsPalette;
import org.kie.workbench.common.stunner.client.lienzo.components.palette.LienzoDefinitionSetFlatPalette;
import org.kie.workbench.common.stunner.client.lienzo.components.palette.view.LienzoPaletteViewImpl;
import org.kie.workbench.common.stunner.client.lienzo.components.palette.view.element.LienzoPaletteElementView;
import org.kie.workbench.common.stunner.client.lienzo.components.palette.view.element.LienzoSeparatorPaletteElementViewImpl;
import org.kie.workbench.common.stunner.client.lienzo.components.palette.view.element.LienzoTextPaletteElementViewImpl;
import org.kie.workbench.common.stunner.core.client.api.ShapeManager;
import org.kie.workbench.common.stunner.core.client.components.glyph.DefinitionGlyphTooltip;
import org.kie.workbench.common.stunner.core.client.components.palette.model.GlyphPaletteItem;
import org.kie.workbench.common.stunner.core.client.components.palette.model.HasPaletteItems;
import org.kie.workbench.common.stunner.core.client.components.palette.model.definition.DefinitionPaletteCategory;
import org.kie.workbench.common.stunner.core.client.components.palette.model.definition.DefinitionSetPalette;
import org.kie.workbench.common.stunner.core.client.components.palette.view.PaletteGrid;
import org.kie.workbench.common.stunner.core.client.shape.factory.ShapeFactory;

@Dependent
public class LienzoDefinitionSetFlatPaletteImpl
extends AbstractLienzoGlyphItemsPalette<HasPaletteItems<? extends GlyphPaletteItem>, LienzoPaletteViewImpl>
implements LienzoDefinitionSetFlatPalette {
    private String lastCategory = null;
    private final List<GlyphPaletteItem> items = new LinkedList<GlyphPaletteItem>();

    protected LienzoDefinitionSetFlatPaletteImpl() {
        this(null, null, null);
    }

    @Inject
    public LienzoDefinitionSetFlatPaletteImpl(ShapeManager shapeManager, LienzoPaletteViewImpl view, DefinitionGlyphTooltip definitionGlyphTooltip) {
        super(shapeManager, definitionGlyphTooltip, view);
    }

    @PostConstruct
    public void init() {
        super.doInit();
    }

    @Override
    protected void doBind() {
        this.items.clear();
        DefinitionSetPalette definitionSetPalette = (DefinitionSetPalette)this.paletteDefinition;
        List categories = definitionSetPalette.getItems();
        if (null != categories && !categories.isEmpty()) {
            PaletteGrid grid = this.getGrid();
            for (DefinitionPaletteCategory category : categories) {
                List categoryItems = category.getItems();
                if (null == categoryItems || categoryItems.isEmpty()) continue;
                for (GlyphPaletteItem item : categoryItems) {
                    this.addGlyphItemIntoView(item, grid);
                    this.items.add(item);
                }
            }
        }
    }

    @Override
    protected ShapeFactory getShapeFactory() {
        ShapeFactory f = super.getShapeFactory();
        if (null == f) {
            DefinitionSetPalette definitionSetPalette = (DefinitionSetPalette)this.paletteDefinition;
            return this.shapeManager.getDefaultShapeSet(definitionSetPalette.getDefinitionSetId()).getShapeFactory();
        }
        return f;
    }

    @Override
    public List<GlyphPaletteItem> getItems() {
        return this.items;
    }

    protected void addTextIntoView(String text, PaletteGrid grid) {
        LienzoTextPaletteElementViewImpl separatorPaletteTextView = new LienzoTextPaletteElementViewImpl(text, "Verdana", 10.0);
        this.addElementIntoView(separatorPaletteTextView);
    }

    protected void addSeparatorIntoView(PaletteGrid grid) {
        LienzoSeparatorPaletteElementViewImpl separatorPaletteElementView = new LienzoSeparatorPaletteElementViewImpl(grid.getIconSize(), grid.getIconSize());
        this.addElementIntoView(separatorPaletteElementView);
    }

    protected void addElementIntoView(LienzoPaletteElementView paletteElementView) {
        this.itemViews.add(paletteElementView);
        ((LienzoPaletteViewImpl)this.view).add(paletteElementView);
    }
}

