/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.shape.view.ext;

import com.ait.lienzo.client.core.shape.MultiPath;
import com.ait.lienzo.client.core.shape.Node;
import com.ait.lienzo.client.core.shape.Shape;
import com.ait.lienzo.client.core.shape.wires.IControlHandle;
import com.ait.lienzo.client.core.shape.wires.IControlHandleList;
import com.ait.lienzo.client.core.shape.wires.LayoutContainer;
import com.ait.lienzo.client.core.shape.wires.WiresLayoutContainer;
import com.ait.lienzo.client.core.shape.wires.WiresShapeControlHandleList;
import com.ait.lienzo.client.core.shape.wires.event.AbstractWiresDragEvent;
import com.ait.lienzo.client.core.shape.wires.event.AbstractWiresResizeEvent;
import com.ait.lienzo.client.core.shape.wires.event.WiresResizeEndEvent;
import com.ait.lienzo.client.core.shape.wires.event.WiresResizeEndHandler;
import com.ait.lienzo.client.core.shape.wires.event.WiresResizeStartEvent;
import com.ait.lienzo.client.core.shape.wires.event.WiresResizeStartHandler;
import com.ait.lienzo.client.core.shape.wires.event.WiresResizeStepEvent;
import com.ait.lienzo.client.core.shape.wires.event.WiresResizeStepHandler;
import com.ait.lienzo.client.core.types.BoundingBox;
import com.ait.lienzo.client.core.types.LinearGradient;
import com.google.gwt.event.shared.HandlerRegistration;
import org.kie.workbench.common.stunner.client.lienzo.shape.view.ViewEventHandlerManager;
import org.kie.workbench.common.stunner.client.lienzo.shape.view.WiresShapeView;
import org.kie.workbench.common.stunner.client.lienzo.shape.view.ext.WiresTextDecorator;
import org.kie.workbench.common.stunner.client.lienzo.util.LienzoShapeUtils;
import org.kie.workbench.common.stunner.client.lienzo.util.ShapeControlPointsHelper;
import org.kie.workbench.common.stunner.core.client.shape.view.HasControlPoints;
import org.kie.workbench.common.stunner.core.client.shape.view.HasEventHandlers;
import org.kie.workbench.common.stunner.core.client.shape.view.HasFillGradient;
import org.kie.workbench.common.stunner.core.client.shape.view.HasTitle;
import org.kie.workbench.common.stunner.core.client.shape.view.event.DragContext;
import org.kie.workbench.common.stunner.core.client.shape.view.event.DragEvent;
import org.kie.workbench.common.stunner.core.client.shape.view.event.DragHandler;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ResizeEvent;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ResizeHandler;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewEvent;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewEventType;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewHandler;

public class WiresShapeViewExt<T extends WiresShapeViewExt>
extends WiresShapeView<T>
implements HasTitle<T>,
HasControlPoints<T>,
HasEventHandlers<T, Shape<?>>,
HasFillGradient<T> {
    private ViewEventHandlerManager eventHandlerManager;
    private WiresTextDecorator textViewDecorator;
    private HasFillGradient.Type fillGradientType = null;
    private String fillGradientStartColor = null;
    private String fillGradientEndColor = null;

    public WiresShapeViewExt(ViewEventType[] supportedEventTypes, MultiPath path) {
        this(supportedEventTypes, path, (LayoutContainer)new WiresLayoutContainer());
    }

    public WiresShapeViewExt(ViewEventType[] supportedEventTypes, MultiPath path, LayoutContainer layoutContainer) {
        super(path, (LayoutContainer)(null != layoutContainer ? layoutContainer : new WiresLayoutContainer()));
        this.initialize(supportedEventTypes);
    }

    public boolean supports(ViewEventType type) {
        return this.eventHandlerManager.supports(type);
    }

    public Shape<?> getAttachableShape() {
        return this.getShape();
    }

    public T setTitle(String title) {
        this.textViewDecorator.setTitle(title);
        return (T)((Object)this);
    }

    public T setTitlePosition(HasTitle.Position position) {
        if (this.textViewDecorator.setTitlePosition(position)) {
            this.removeChild(this.textViewDecorator.getView());
            this.addTextAsChild();
        }
        return (T)((Object)this);
    }

    public T setTitleRotation(double degrees) {
        this.textViewDecorator.setTitleRotation(degrees);
        return (T)((Object)this);
    }

    public T setTitleStrokeColor(String color) {
        this.textViewDecorator.setTitleStrokeColor(color);
        return (T)((Object)this);
    }

    public T setTitleFontFamily(String fontFamily) {
        this.textViewDecorator.setTitleFontFamily(fontFamily);
        return (T)((Object)this);
    }

    public T setTitleFontSize(double fontSize) {
        this.textViewDecorator.setTitleFontSize(fontSize);
        return (T)((Object)this);
    }

    public T setTitleAlpha(double alpha) {
        this.textViewDecorator.setTitleAlpha(alpha);
        return (T)((Object)this);
    }

    public T setTitleStrokeWidth(double strokeWidth) {
        this.textViewDecorator.setTitleStrokeWidth(strokeWidth);
        return (T)((Object)this);
    }

    public T moveTitleToTop() {
        this.textViewDecorator.moveTitleToTop();
        return (T)((Object)this);
    }

    public T setFillGradient(HasFillGradient.Type type, String startColor, String endColor) {
        this.fillGradientType = type;
        this.fillGradientStartColor = startColor;
        this.fillGradientEndColor = endColor;
        if (null != this.getShape()) {
            BoundingBox bb = this.getShape().getBoundingBox();
            double width = bb.getWidth();
            double height = bb.getHeight();
            this.updateFillGradient(width, height);
        }
        return (T)((Object)this);
    }

    public T updateFillGradient(double width, double height) {
        if (this.fillGradientType != null && this.fillGradientStartColor != null && this.fillGradientEndColor != null) {
            LinearGradient gradient = LienzoShapeUtils.getLinearGradient(this.fillGradientStartColor, this.fillGradientEndColor, width, height);
            this.getShape().setFillGradient(gradient);
        }
        return (T)((Object)this);
    }

    public T showControlPoints(HasControlPoints.ControlPointType type) {
        IControlHandleList ctrls = this.loadControls(this.translate(type));
        if (null != ctrls && HasControlPoints.ControlPointType.RESIZE.equals((Object)type)) {
            ShapeControlPointsHelper.showOnlyLowerRightCP(ctrls);
        } else if (null != ctrls) {
            ctrls.show();
        }
        return (T)((Object)this);
    }

    private IControlHandle.ControlHandleType translate(HasControlPoints.ControlPointType type) {
        if (type.equals((Object)HasControlPoints.ControlPointType.RESIZE)) {
            return IControlHandle.ControlHandleStandardType.RESIZE;
        }
        return IControlHandle.ControlHandleStandardType.MAGNET;
    }

    public T hideControlPoints() {
        WiresShapeControlHandleList ctrls = this.getControls();
        if (null != ctrls) {
            ctrls.hide();
        }
        return (T)((Object)this);
    }

    public boolean areControlsVisible() {
        return null != this.getControls() && this.getControls().isVisible();
    }

    @Override
    public void destroy() {
        super.destroy();
        if (null != this.textViewDecorator) {
            this.textViewDecorator.destroy();
        }
        if (null != this.eventHandlerManager) {
            this.eventHandlerManager.destroy();
            this.eventHandlerManager = null;
        }
        this.fillGradientEndColor = null;
        this.fillGradientStartColor = null;
        this.fillGradientType = null;
    }

    public T addHandler(ViewEventType type, ViewHandler<? extends ViewEvent> eventHandler) {
        if (this.supports(type)) {
            boolean delegate = true;
            if (ViewEventType.DRAG.equals((Object)type)) {
                HandlerRegistration[] registrations = this.registerDragHandler((ViewHandler<DragEvent>)((DragHandler)eventHandler));
                if (null != registrations) {
                    this.eventHandlerManager.addHandlersRegistration(type, registrations);
                }
                delegate = false;
            } else if (ViewEventType.RESIZE.equals((Object)type)) {
                HandlerRegistration[] registrations = this.registerResizeHandler((ViewHandler<ResizeEvent>)((ResizeHandler)eventHandler));
                if (null != registrations) {
                    this.eventHandlerManager.addHandlersRegistration(type, registrations);
                }
                delegate = false;
            }
            if (ViewEventType.TEXT_ENTER.equals((Object)type)) {
                delegate = false;
                this.textViewDecorator.setTextEnterHandler(eventHandler);
            }
            if (ViewEventType.TEXT_EXIT.equals((Object)type)) {
                this.textViewDecorator.setTextExitHandler(eventHandler);
                delegate = false;
            }
            if (ViewEventType.TEXT_CLICK.equals((Object)type)) {
                this.textViewDecorator.setTextClickHandler(eventHandler);
                delegate = false;
            }
            if (ViewEventType.TEXT_DBL_CLICK.equals((Object)type)) {
                this.textViewDecorator.setTextDblClickHandler(eventHandler);
                delegate = false;
            }
            if (delegate) {
                this.eventHandlerManager.addHandler(type, eventHandler);
            }
        }
        return (T)((Object)this);
    }

    public T removeHandler(ViewHandler<? extends ViewEvent> eventHandler) {
        this.eventHandlerManager.removeHandler(eventHandler);
        return (T)((Object)this);
    }

    public T enableHandlers() {
        this.eventHandlerManager.enable();
        return (T)((Object)this);
    }

    public T disableHandlers() {
        this.eventHandlerManager.disable();
        return (T)((Object)this);
    }

    protected void initialize(ViewEventType[] supportedEventTypes) {
        this.initializeHandlerManager((Node<?>)this.getGroup(), (Node<?>)(null != this.getPath() ? this.getPath() : this.getGroup()), supportedEventTypes);
        this.initializeTextView();
    }

    protected void initializeHandlerManager(Node<?> node, Node<?> path, ViewEventType[] supportedEventTypes) {
        this.eventHandlerManager = this.createEventHandlerManager(node, path, supportedEventTypes);
    }

    protected void initializeTextView() {
        this.textViewDecorator = new WiresTextDecorator(this.eventHandlerManager);
        this.addTextAsChild();
    }

    private ViewEventHandlerManager createEventHandlerManager(Node<?> node, Node<?> path, ViewEventType[] supportedEventTypes) {
        if (null != this.getGroup()) {
            return new ViewEventHandlerManager(node, path, supportedEventTypes);
        }
        return null;
    }

    private void addTextAsChild() {
        this.addChild(this.textViewDecorator.getView(), this.textViewDecorator.getLayout());
    }

    private HandlerRegistration[] registerDragHandler(ViewHandler<DragEvent> eventHandler) {
        if (!this.getAttachableShape().isDraggable()) {
            DragHandler dragHandler = (DragHandler)eventHandler;
            this.setDraggable(true);
            HandlerRegistration dragStartReg = this.addWiresDragStartHandler(wiresDragStartEvent -> {
                DragEvent e = this.buildDragEvent((AbstractWiresDragEvent)wiresDragStartEvent);
                dragHandler.start(e);
            });
            HandlerRegistration dragMoveReg = this.addWiresDragMoveHandler(wiresDragMoveEvent -> {
                DragEvent e = this.buildDragEvent((AbstractWiresDragEvent)wiresDragMoveEvent);
                dragHandler.handle((ViewEvent)e);
            });
            HandlerRegistration dragEndReg = this.addWiresDragEndHandler(wiresDragEndEvent -> {
                DragEvent e = this.buildDragEvent((AbstractWiresDragEvent)wiresDragEndEvent);
                dragHandler.end(e);
            });
            return new HandlerRegistration[]{dragStartReg, dragMoveReg, dragEndReg};
        }
        return null;
    }

    private HandlerRegistration[] registerResizeHandler(ViewHandler<ResizeEvent> eventHandler) {
        final ResizeHandler resizeHandler = (ResizeHandler)eventHandler;
        this.setResizable(true);
        HandlerRegistration r0 = this.addWiresResizeStartHandler(new WiresResizeStartHandler(){

            public void onShapeResizeStart(WiresResizeStartEvent wiresResizeStartEvent) {
                ResizeEvent event = WiresShapeViewExt.this.buildResizeEvent((AbstractWiresResizeEvent)wiresResizeStartEvent);
                resizeHandler.start(event);
            }
        });
        HandlerRegistration r1 = this.addWiresResizeStepHandler(new WiresResizeStepHandler(){

            public void onShapeResizeStep(WiresResizeStepEvent wiresResizeStepEvent) {
                ResizeEvent event = WiresShapeViewExt.this.buildResizeEvent((AbstractWiresResizeEvent)wiresResizeStepEvent);
                resizeHandler.handle((ViewEvent)event);
            }
        });
        HandlerRegistration r2 = this.addWiresResizeEndHandler(new WiresResizeEndHandler(){

            public void onShapeResizeEnd(WiresResizeEndEvent wiresResizeEndEvent) {
                ResizeEvent event = WiresShapeViewExt.this.buildResizeEvent((AbstractWiresResizeEvent)wiresResizeEndEvent);
                resizeHandler.end(event);
            }
        });
        return new HandlerRegistration[]{r0, r1, r2};
    }

    private DragEvent buildDragEvent(AbstractWiresDragEvent sourceDragEvent) {
        double x = sourceDragEvent.getX();
        double y = sourceDragEvent.getY();
        double cx = sourceDragEvent.getNodeDragEvent().getX();
        double cy = sourceDragEvent.getNodeDragEvent().getY();
        int dx = sourceDragEvent.getNodeDragEvent().getDragContext().getDx();
        int dy = sourceDragEvent.getNodeDragEvent().getDragContext().getDy();
        DragContext dragContext = new DragContext(dx, dy, () -> sourceDragEvent.getNodeDragEvent().getDragContext().reset());
        return new DragEvent(x, y, cx, cy, dragContext);
    }

    private ResizeEvent buildResizeEvent(AbstractWiresResizeEvent sourceResizeEvent) {
        double x = sourceResizeEvent.getX();
        double y = sourceResizeEvent.getY();
        double cx = sourceResizeEvent.getNodeDragEvent().getX();
        double cy = sourceResizeEvent.getNodeDragEvent().getY();
        double w = sourceResizeEvent.getWidth();
        double h = sourceResizeEvent.getHeight();
        return new ResizeEvent(x, y, cx, cy, w, h);
    }
}

