/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.shape.view.ext;

import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.shape.Rectangle;
import com.ait.lienzo.client.core.shape.Text;
import com.ait.lienzo.client.core.shape.wires.LayoutContainer;
import com.ait.lienzo.client.core.types.BoundingBox;
import com.ait.lienzo.shared.core.types.ColorName;
import com.ait.lienzo.shared.core.types.IColor;
import com.google.gwt.event.shared.HandlerRegistration;
import org.kie.workbench.common.stunner.client.lienzo.shape.view.ViewEventHandlerManager;
import org.kie.workbench.common.stunner.core.client.shape.view.HasTitle;
import org.kie.workbench.common.stunner.core.client.shape.view.event.TextClickEvent;
import org.kie.workbench.common.stunner.core.client.shape.view.event.TextDoubleClickEvent;
import org.kie.workbench.common.stunner.core.client.shape.view.event.TextEnterEvent;
import org.kie.workbench.common.stunner.core.client.shape.view.event.TextExitEvent;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewEvent;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewEventType;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewHandler;

public class WiresTextDecorator {
    private final ViewEventHandlerManager eventHandlerManager;
    private final Group textContainer = new Group();
    private final Rectangle textDecorator = new Rectangle(1.0, 1.0);
    private ViewHandler<TextEnterEvent> textOverHandlerViewHandler;
    private ViewHandler<TextExitEvent> textOutEventViewHandler;
    private ViewHandler<TextClickEvent> textClickEventViewHandler;
    private ViewHandler<TextDoubleClickEvent> textDblClickEventViewHandler;
    private Text text;
    private LayoutContainer.Layout currentTextLayout;

    public WiresTextDecorator(ViewEventHandlerManager eventHandlerManager) {
        this.eventHandlerManager = eventHandlerManager;
        this.initialize();
    }

    public void setTextClickHandler(ViewHandler<TextClickEvent> textClickEventViewHandler) {
        this.textClickEventViewHandler = textClickEventViewHandler;
    }

    public void setTextDblClickHandler(ViewHandler<TextDoubleClickEvent> textDblClickEventViewHandler) {
        this.textDblClickEventViewHandler = textDblClickEventViewHandler;
    }

    public void setTextEnterHandler(ViewHandler<TextEnterEvent> textOverHandlerViewHandler) {
        this.textOverHandlerViewHandler = textOverHandlerViewHandler;
    }

    public void setTextExitHandler(ViewHandler<TextExitEvent> textOutEventViewHandler) {
        this.textOutEventViewHandler = textOutEventViewHandler;
    }

    private void initialize() {
        this.text = (Text)((Text)((Text)((Text)new Text("").setFontSize(14.0).setFillColor((IColor)ColorName.BLACK)).setStrokeWidth(1.0)).setDraggable(false)).setAlpha(0.0);
        this.currentTextLayout = LayoutContainer.Layout.CENTER;
        this.updateDecorator();
        this.textContainer.add((IPrimitive)this.text);
        this.textContainer.add((IPrimitive)this.textDecorator);
        this.initializeHandlers();
    }

    private void updateDecorator() {
        BoundingBox tbb = this.text.getBoundingBox();
        ((Rectangle)((Rectangle)((Rectangle)((Rectangle)((Rectangle)this.textDecorator.setWidth(tbb.getWidth()).setHeight(tbb.getHeight()).setX(tbb.getX())).setY(tbb.getY())).setStrokeAlpha(0.0)).setFillAlpha(1.0)).setRotationDegrees(this.text.getRotationDegrees())).moveToTop();
    }

    private void initializeHandlers() {
        this.registerTextEnterHandler();
        this.registerTextExitHandler();
        this.registerClickHandler();
        this.registerDoubleClickHandler();
    }

    private void registerClickHandler() {
        HandlerRegistration registration = this.textDecorator.addNodeMouseClickHandler(event -> {
            if (null != this.textClickEventViewHandler) {
                this.eventHandlerManager.skipClickHandler();
                TextClickEvent e = new TextClickEvent((double)event.getX(), (double)event.getY(), (double)event.getMouseEvent().getClientX(), (double)event.getMouseEvent().getClientY());
                this.textClickEventViewHandler.handle((ViewEvent)e);
                this.eventHandlerManager.restoreClickHandler();
            }
        });
        this.eventHandlerManager.addHandlersRegistration(ViewEventType.TEXT_CLICK, registration);
    }

    private void registerDoubleClickHandler() {
        HandlerRegistration registration = this.textDecorator.addNodeMouseDoubleClickHandler(event -> {
            if (null != this.textDblClickEventViewHandler) {
                this.eventHandlerManager.skipClickHandler();
                TextDoubleClickEvent e = new TextDoubleClickEvent((double)event.getX(), (double)event.getY(), (double)event.getMouseEvent().getClientX(), (double)event.getMouseEvent().getClientY());
                this.textDblClickEventViewHandler.handle((ViewEvent)e);
                this.eventHandlerManager.restoreClickHandler();
            }
        });
        this.eventHandlerManager.addHandlersRegistration(ViewEventType.TEXT_DBL_CLICK, registration);
    }

    private void registerTextEnterHandler() {
        HandlerRegistration registration = this.textDecorator.addNodeMouseEnterHandler(event -> {
            if (null != this.textOverHandlerViewHandler && this.hasText()) {
                TextEnterEvent textOverEvent = new TextEnterEvent((double)event.getX(), (double)event.getY(), (double)event.getMouseEvent().getClientX(), (double)event.getMouseEvent().getClientY());
                this.textOverHandlerViewHandler.handle((ViewEvent)textOverEvent);
            }
        });
        this.eventHandlerManager.addHandlersRegistration(ViewEventType.TEXT_ENTER, registration);
    }

    private void registerTextExitHandler() {
        HandlerRegistration registration = this.textDecorator.addNodeMouseExitHandler(event -> {
            if (null != this.textOutEventViewHandler && this.hasText()) {
                TextExitEvent textOutEvent = new TextExitEvent((double)event.getX(), (double)event.getY(), (double)event.getMouseEvent().getClientX(), (double)event.getMouseEvent().getClientY());
                this.textOutEventViewHandler.handle((ViewEvent)textOutEvent);
            }
        });
        this.eventHandlerManager.addHandlersRegistration(ViewEventType.TEXT_EXIT, registration);
    }

    public void setTitle(String title) {
        this.text.setText(title);
        this.updateDecorator();
    }

    public boolean setTitlePosition(HasTitle.Position position) {
        LayoutContainer.Layout layout = LayoutContainer.Layout.CENTER;
        switch (position) {
            case BOTTOM: {
                layout = LayoutContainer.Layout.BOTTOM;
                break;
            }
            case TOP: {
                layout = LayoutContainer.Layout.TOP;
                break;
            }
            case LEFT: {
                layout = LayoutContainer.Layout.LEFT;
                break;
            }
            case RIGHT: {
                layout = LayoutContainer.Layout.RIGHT;
            }
        }
        boolean changed = !this.currentTextLayout.equals((Object)layout);
        this.currentTextLayout = layout;
        return changed;
    }

    public void setTitleRotation(double degrees) {
        this.text.setRotationDegrees(degrees);
        this.updateDecorator();
    }

    public void setTitleStrokeColor(String color) {
        this.text.setStrokeColor(color);
    }

    public void setTitleFontFamily(String fontFamily) {
        this.text.setFontFamily(fontFamily);
        this.updateDecorator();
    }

    public void setTitleFontSize(double fontSize) {
        this.text.setFontSize(fontSize);
        this.updateDecorator();
    }

    public void setTitleAlpha(double alpha) {
        this.text.setAlpha(alpha);
        this.updateDecorator();
    }

    public void setTitleStrokeWidth(double strokeWidth) {
        this.text.setStrokeWidth(strokeWidth);
    }

    public void moveTitleToTop() {
        this.textContainer.moveToTop();
    }

    public IPrimitive<?> getView() {
        return this.textContainer;
    }

    public LayoutContainer.Layout getLayout() {
        return this.currentTextLayout;
    }

    public void destroy() {
        if (null != this.text) {
            this.text.removeFromParent();
            this.text = null;
        }
        this.textDecorator.removeFromParent();
        this.textContainer.removeFromParent();
        if (null != this.textOverHandlerViewHandler) {
            // empty if block
        }
        this.deregisterHandler(this.textOverHandlerViewHandler);
        this.deregisterHandler(this.textOutEventViewHandler);
        this.deregisterHandler(this.textClickEventViewHandler);
        this.deregisterHandler(this.textDblClickEventViewHandler);
    }

    private void deregisterHandler(ViewHandler<?> handler) {
        if (null != handler) {
            this.eventHandlerManager.removeHandler(handler);
        }
    }

    private boolean hasText() {
        String text = this.text.getText();
        return null != text && text.trim().length() > 0;
    }
}

