/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.canvas.controls;

import com.ait.lienzo.client.core.shape.wires.WiresContainer;
import com.ait.lienzo.client.core.shape.wires.WiresShape;
import com.google.gwt.logging.client.LogConfiguration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kie.workbench.common.stunner.client.lienzo.canvas.wires.WiresCanvas;
import org.kie.workbench.common.stunner.client.lienzo.canvas.wires.WiresUtils;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.CanvasControl;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandManager;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.client.command.RequiresCommandManager;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.CompositeCommand;
import org.kie.workbench.common.stunner.core.command.impl.CompositeCommandImpl;
import org.kie.workbench.common.stunner.core.command.util.CommandUtils;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Child;

public abstract class AbstractContainmentBasedControl
implements CanvasControl<AbstractCanvasHandler>,
RequiresCommandManager<AbstractCanvasHandler> {
    private static Logger LOGGER = Logger.getLogger(AbstractContainmentBasedControl.class.getName());
    private AbstractCanvasHandler canvasHandler;
    private RequiresCommandManager.CommandManagerProvider<AbstractCanvasHandler> commandManagerProvider;

    protected abstract void doEnable(WiresCanvas.View var1);

    protected abstract void doDisable(WiresCanvas.View var1);

    protected abstract boolean isEdgeAccepted(Edge var1);

    protected abstract Command<AbstractCanvasHandler, CanvasViolation> getAddEdgeCommand(Node var1, Node var2);

    protected abstract Command<AbstractCanvasHandler, CanvasViolation> getDeleteEdgeCommand(Node var1, Node var2);

    public void enable(AbstractCanvasHandler canvasHandler) {
        this.canvasHandler = canvasHandler;
        WiresCanvas.View canvasView = (WiresCanvas.View)canvasHandler.getAbstractCanvas().getView();
        this.doEnable(canvasView);
    }

    public void disable() {
        if (null != this.canvasHandler && null != this.canvasHandler.getCanvas()) {
            WiresCanvas.View canvasView = (WiresCanvas.View)this.canvasHandler.getAbstractCanvas().getView();
            this.doDisable(canvasView);
        }
        this.canvasHandler = null;
        this.commandManagerProvider = null;
    }

    public void setCommandManagerProvider(RequiresCommandManager.CommandManagerProvider<AbstractCanvasHandler> provider) {
        this.commandManagerProvider = provider;
    }

    public boolean allow(Node parent, Node child) {
        if (parent == null && child == null) {
            return false;
        }
        boolean isAllow = true;
        Edge<Object, Node> edge = this.getTheEdge(child);
        boolean isSameParent = this.isSameParent(parent, edge);
        if (!isSameParent) {
            CommandResult<CanvasViolation> violations = this.runAllow(parent, child, edge);
            isAllow = this.isAccept(child, violations);
        }
        return isAllow;
    }

    public boolean accept(Node parent, Node child) {
        if (parent == null && child == null) {
            return false;
        }
        Edge<Object, Node> edge = this.getTheEdge(child);
        boolean isSameParent = this.isSameParent(parent, edge);
        boolean isAccept = true;
        if (!isSameParent) {
            CommandResult<CanvasViolation> violations = this.runAccept(parent, child, edge);
            isAccept = this.isAccept(child, violations);
        }
        return isAccept;
    }

    protected boolean isAccept(WiresContainer wiresContainer, WiresShape wiresShape) {
        return this.isEnabled() && WiresUtils.isWiresShape(wiresContainer) && WiresUtils.isWiresShape((WiresContainer)wiresShape);
    }

    protected CommandResult<CanvasViolation> runAllow(Node parent, Node child, Edge edge) {
        CompositeCommand<AbstractCanvasHandler, CanvasViolation> command = this.buildCommands(parent, child, edge);
        return this.getCommandManager().allow((Object)this.canvasHandler, command);
    }

    protected CommandResult<CanvasViolation> runAccept(Node parent, Node child, Edge edge) {
        CompositeCommand<AbstractCanvasHandler, CanvasViolation> command = this.buildCommands(parent, child, edge);
        return this.getCommandManager().execute((Object)this.canvasHandler, command);
    }

    protected AbstractCanvasHandler getCanvasHandler() {
        return this.canvasHandler;
    }

    protected CanvasCommandManager<AbstractCanvasHandler> getCommandManager() {
        return this.commandManagerProvider.getCommandManager();
    }

    private CompositeCommand<AbstractCanvasHandler, CanvasViolation> buildCommands(Node parent, Node child, Edge edge) {
        boolean hasSourceNode = null != edge && null != edge.getSourceNode();
        Command<AbstractCanvasHandler, CanvasViolation> deleteEdgeCommand = hasSourceNode ? this.getDeleteEdgeCommand(edge.getSourceNode(), child) : null;
        boolean hasNewTarget = null != parent;
        Command<AbstractCanvasHandler, CanvasViolation> addEdgeCommand = hasNewTarget ? this.getAddEdgeCommand(parent, child) : null;
        CompositeCommandImpl.CompositeCommandBuilder commandBuilder = new CompositeCommandImpl.CompositeCommandBuilder().reverse();
        if (null != deleteEdgeCommand) {
            commandBuilder.addCommand(deleteEdgeCommand);
        }
        if (null != addEdgeCommand) {
            commandBuilder.addCommand(addEdgeCommand);
        }
        return commandBuilder.build();
    }

    private boolean isEnabled() {
        return this.canvasHandler != null;
    }

    private boolean isSameParent(Node parent, Edge<Child, Node> edge) {
        Node sourceNode;
        if (null != edge && null != (sourceNode = edge.getSourceNode())) {
            String parentUUID = null != parent ? parent.getUUID() : this.canvasHandler.getDiagram().getMetadata().getCanvasRootUUID();
            return null != parentUUID && sourceNode.getUUID().equals(parentUUID);
        }
        return parent == null;
    }

    private Edge<Object, Node> getTheEdge(Node child) {
        List outEdges;
        if (child != null && null != (outEdges = child.getInEdges()) && !outEdges.isEmpty()) {
            for (Edge edge : outEdges) {
                if (!this.isEdgeAccepted(edge)) continue;
                return edge;
            }
        }
        return null;
    }

    private boolean isAccept(Node candidate, CommandResult<CanvasViolation> result) {
        return !CommandUtils.isError(result);
    }

    private void log(Level level, String message) {
        if (LogConfiguration.loggingIsEnabled()) {
            LOGGER.log(level, message);
        }
    }
}

