/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.components.drag;

import com.ait.lienzo.client.core.shape.Layer;
import com.ait.lienzo.client.core.shape.MultiPath;
import com.ait.lienzo.client.core.shape.wires.WiresConnector;
import com.ait.lienzo.client.core.shape.wires.WiresManager;
import com.ait.lienzo.client.core.shape.wires.WiresShape;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.client.lienzo.LienzoLayer;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.Point2D;
import org.kie.workbench.common.stunner.core.client.components.drag.ConnectorDragProxy;
import org.kie.workbench.common.stunner.core.client.components.drag.DragProxy;
import org.kie.workbench.common.stunner.core.client.components.drag.DragProxyCallback;
import org.kie.workbench.common.stunner.core.client.components.drag.ShapeViewDragProxy;
import org.kie.workbench.common.stunner.core.client.shape.EdgeShape;
import org.kie.workbench.common.stunner.core.client.shape.MutationContext;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.factory.ShapeFactory;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeView;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.processing.index.bounds.GraphBoundsIndexer;

@Dependent
public class ConnectorDragProxyImpl
implements ConnectorDragProxy<AbstractCanvasHandler> {
    ShapeViewDragProxy<AbstractCanvas> shapeViewDragProxyFactory;
    GraphBoundsIndexer graphBoundsIndexer;
    private AbstractCanvasHandler canvasHandler;
    private WiresConnector wiresConnector;

    @Inject
    public ConnectorDragProxyImpl(ShapeViewDragProxy<AbstractCanvas> shapeViewDragProxyFactory, GraphBoundsIndexer graphBoundsIndexer) {
        this.shapeViewDragProxyFactory = shapeViewDragProxyFactory;
        this.graphBoundsIndexer = graphBoundsIndexer;
    }

    public DragProxy<AbstractCanvasHandler, ConnectorDragProxy.Item, DragProxyCallback> proxyFor(AbstractCanvasHandler context) {
        this.canvasHandler = context;
        this.shapeViewDragProxyFactory.proxyFor((Object)context.getAbstractCanvas());
        this.graphBoundsIndexer.setRootUUID(context.getDiagram().getMetadata().getCanvasRootUUID());
        return this;
    }

    public DragProxy<AbstractCanvasHandler, ConnectorDragProxy.Item, DragProxyCallback> show(ConnectorDragProxy.Item item, int x, int y, final DragProxyCallback callback) {
        final Edge edge = item.getEdge();
        Node sourceNode = item.getSourceNode();
        ShapeFactory factory = item.getShapeFactory();
        WiresManager wiresManager = this.getWiresManager();
        final Shape sourceNodeShape = this.getCanvas().getShape(sourceNode.getUUID());
        Shape shape = factory.build(((View)edge.getContent()).getDefinition(), (Object)this.canvasHandler);
        final EdgeShape connector = (EdgeShape)shape;
        this.wiresConnector = (WiresConnector)shape.getShapeView();
        wiresManager.register(this.wiresConnector);
        MultiPath dummyPath = (MultiPath)((MultiPath)new MultiPath().rect(0.0, 0.0, 1.0, 1.0).setFillAlpha(0.0)).setStrokeAlpha(0.0);
        final DummyShapeView dummyShapeView = new DummyShapeView(dummyPath);
        this.graphBoundsIndexer.build((Object)this.canvasHandler.getDiagram().getGraph());
        this.shapeViewDragProxyFactory.show((Object)dummyShapeView, x, y, (Object)new DragProxyCallback(){

            public void onStart(int x, int y) {
                callback.onStart(x, y);
                this.drawConnector();
            }

            public void onMove(int x, int y) {
                callback.onMove(x, y);
                this.drawConnector();
            }

            public void onComplete(int x, int y) {
                callback.onComplete(x, y);
                ConnectorDragProxyImpl.this.deregisterTransientConnector();
                ConnectorDragProxyImpl.this.getCanvas().draw();
            }

            private void drawConnector() {
                DummyShapeView targetShapeView = null;
                Object targetNode = null;
                if (null != targetNode) {
                    Shape targetNodeShape = ConnectorDragProxyImpl.this.getCanvas().getShape(targetNode.getUUID());
                    if (null != targetNodeShape) {
                        targetShapeView = targetNodeShape.getShapeView();
                    }
                } else {
                    targetShapeView = dummyShapeView;
                }
                connector.applyConnections(edge, sourceNodeShape.getShapeView(), (ShapeView)targetShapeView, MutationContext.STATIC);
                connector.applyProperties((Object)edge, MutationContext.STATIC);
                ConnectorDragProxyImpl.this.getCanvas().draw();
            }
        });
        return this;
    }

    public void clear() {
        if (null != this.shapeViewDragProxyFactory) {
            this.shapeViewDragProxyFactory.clear();
        }
        this.deregisterTransientConnector();
    }

    public void destroy() {
        this.clear();
        this.graphBoundsIndexer.destroy();
        this.graphBoundsIndexer = null;
        this.canvasHandler = null;
        this.shapeViewDragProxyFactory.destroy();
        this.shapeViewDragProxyFactory = null;
    }

    private WiresManager getWiresManager() {
        AbstractCanvas canvas = this.canvasHandler.getAbstractCanvas();
        LienzoLayer layer = (LienzoLayer)canvas.getLayer();
        return WiresManager.get((Layer)layer.getLienzoLayer());
    }

    private void deregisterTransientConnector() {
        if (null != this.wiresConnector) {
            this.getWiresManager().deregister(this.wiresConnector);
            this.getCanvas().draw();
            this.wiresConnector = null;
        }
    }

    private AbstractCanvas<?> getCanvas() {
        return this.canvasHandler.getAbstractCanvas();
    }

    private class DummyShapeView
    extends WiresShape
    implements ShapeView<DummyShapeView> {
        public DummyShapeView(MultiPath path) {
            super(path);
        }

        public DummyShapeView setUUID(String uuid) {
            return null;
        }

        public String getUUID() {
            return null;
        }

        public double getShapeX() {
            return 0.0;
        }

        public double getShapeY() {
            return 0.0;
        }

        public DummyShapeView setShapeX(double x) {
            return null;
        }

        public DummyShapeView setShapeY(double y) {
            return null;
        }

        public double getAlpha() {
            return 0.0;
        }

        public DummyShapeView setAlpha(double alpha) {
            return this;
        }

        public Point2D getShapeAbsoluteLocation() {
            return new Point2D(0.0, 0.0);
        }

        public String getFillColor() {
            return null;
        }

        public DummyShapeView setFillColor(String color) {
            return null;
        }

        public double getFillAlpha() {
            return 0.0;
        }

        public DummyShapeView setFillAlpha(double alpha) {
            return null;
        }

        public String getStrokeColor() {
            return null;
        }

        public DummyShapeView setStrokeColor(String color) {
            return null;
        }

        public double getStrokeAlpha() {
            return 0.0;
        }

        public DummyShapeView setStrokeAlpha(double alpha) {
            return null;
        }

        public double getStrokeWidth() {
            return 0.0;
        }

        public DummyShapeView setStrokeWidth(double width) {
            return null;
        }

        public DummyShapeView moveToTop() {
            return null;
        }

        public DummyShapeView moveToBottom() {
            return null;
        }

        public DummyShapeView moveUp() {
            return null;
        }

        public DummyShapeView moveDown() {
            return null;
        }

        public void destroy() {
        }
    }
}

