/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.components.toolbox.builder;

import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.shape.Shape;
import com.ait.lienzo.client.core.shape.wires.WiresShape;
import com.ait.lienzo.shared.core.types.Direction;
import org.kie.workbench.common.stunner.client.lienzo.LienzoLayer;
import org.kie.workbench.common.stunner.client.lienzo.components.toolbox.LienzoToolbox;
import org.kie.workbench.common.stunner.client.lienzo.components.toolbox.LienzoToolboxButtonGrid;
import org.kie.workbench.common.stunner.client.lienzo.components.toolbox.builder.LienzoToolboxBuilder;
import org.kie.workbench.common.stunner.core.client.canvas.Layer;
import org.kie.workbench.common.stunner.core.client.components.toolbox.ToolboxButton;
import org.kie.workbench.common.stunner.core.client.components.toolbox.builder.ToolboxBuilder;
import org.kie.workbench.common.stunner.core.client.components.toolbox.event.ToolboxButtonEvent;
import org.kie.workbench.common.stunner.core.client.components.toolbox.event.ToolboxButtonEventHandler;
import org.kie.workbench.common.stunner.core.client.shape.view.HasEventHandlers;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeView;
import org.kie.workbench.common.stunner.lienzo.toolbox.Toolboxes;
import org.kie.workbench.common.stunner.lienzo.toolbox.builder.Button;
import org.kie.workbench.common.stunner.lienzo.toolbox.builder.ButtonGrid;
import org.kie.workbench.common.stunner.lienzo.toolbox.builder.ButtonsOrRegister;
import org.kie.workbench.common.stunner.lienzo.toolbox.builder.On;

public class LienzoToolboxBuilderImpl
implements LienzoToolboxBuilder<LienzoToolboxBuilderImpl> {
    private Layer layer;
    private LienzoToolbox toolbox;
    private On on;
    private ButtonGrid buttonGrid;
    private ButtonsOrRegister buttonsOrRegister;
    private int padding = 5;
    private int iconSize = 12;

    public LienzoToolboxBuilderImpl forLayer(Layer layer) {
        this.layer = layer;
        return this;
    }

    public LienzoToolboxBuilderImpl forView(ShapeView<?> view) {
        if (view instanceof WiresShape) {
            HasEventHandlers hasEventHandlers;
            LienzoLayer lienzoLayerImpl = (LienzoLayer)this.layer;
            com.ait.lienzo.client.core.shape.Layer lienzoLayer = lienzoLayerImpl.getLienzoLayer();
            this.on = Toolboxes.staticToolBoxFor((com.ait.lienzo.client.core.shape.Layer)lienzoLayer, (WiresShape)((WiresShape)view));
            if (view instanceof HasEventHandlers && null != (hasEventHandlers = (HasEventHandlers)view).getAttachableShape()) {
                this.on.attachTo((Shape)hasEventHandlers.getAttachableShape());
            }
        }
        return this;
    }

    public LienzoToolboxBuilderImpl direction(ToolboxBuilder.Direction ond, ToolboxBuilder.Direction towards) {
        Direction dOn = this.getDirection(ond);
        Direction dT = this.getDirection(towards);
        this.buttonGrid = this.on.on(dOn).towards(dT);
        return this;
    }

    public LienzoToolboxBuilderImpl grid(LienzoToolboxButtonGrid grid) {
        this.padding = grid.getPadding();
        this.iconSize = grid.getButtonSize();
        this.buttonsOrRegister = this.buttonGrid.grid(grid.getPadding(), grid.getButtonSize(), grid.getRows(), grid.getColumns());
        return this;
    }

    public LienzoToolboxBuilderImpl add(ToolboxButton<Shape<?>> button) {
        Button b = this.buttonsOrRegister.add((IPrimitive)button.getIcon());
        b.setIconSize(this.iconSize).setPadding(this.padding);
        if (null != button.getClickHandler()) {
            b.setClickHandler(this.buildHandler(button.getClickHandler()));
        }
        if (null != button.getMouseDownHandler()) {
            b.setMouseDownHandler(this.buildHandler(button.getMouseDownHandler()));
        }
        if (null != button.getMouseEnterHandler()) {
            b.setMouseEnterHandler(this.buildHandler(button.getMouseEnterHandler()));
        }
        if (null != button.getMouseExitHandler()) {
            b.setMouseExitHandler(this.buildHandler(button.getMouseExitHandler()));
        }
        b.end();
        return this;
    }

    private org.kie.workbench.common.stunner.lienzo.toolbox.event.ToolboxButtonEventHandler buildHandler(ToolboxButtonEventHandler handler) {
        return event -> handler.fire(new ToolboxButtonEvent(){

            public int getX() {
                return event.getX();
            }

            public int getY() {
                return event.getY();
            }

            public int getAbsoluteX() {
                return event.getAbsoluteX();
            }

            public int getAbsoluteY() {
                return event.getAbsoluteY();
            }

            public int getClientX() {
                return event.getClientX();
            }

            public int getClientY() {
                return event.getClientY();
            }
        });
    }

    public LienzoToolbox build() {
        if (null == this.buttonsOrRegister) {
            throw new RuntimeException("No buttons added for toolbox.");
        }
        this.toolbox = new LienzoToolbox(this.buttonsOrRegister.register());
        return this.toolbox;
    }

    private Direction getDirection(ToolboxBuilder.Direction direction) {
        switch (direction) {
            case EAST: {
                return Direction.EAST;
            }
            case WEST: {
                return Direction.WEST;
            }
            case NORTH: {
                return Direction.NORTH;
            }
            case SOUTH: {
                return Direction.SOUTH;
            }
            case NORTH_EAST: {
                return Direction.NORTH_EAST;
            }
            case NORTH_WEST: {
                return Direction.NORTH_WEST;
            }
            case SOUTH_EAST: {
                return Direction.SOUTH_EAST;
            }
            case SOUTH_WEST: {
                return Direction.SOUTH_WEST;
            }
        }
        throw new UnsupportedOperationException("Toolbox direction [" + direction.name() + "] not supported.");
    }
}

