/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.canvas.controls.docking;

import com.ait.lienzo.client.core.shape.wires.IDockingAcceptor;
import com.ait.lienzo.client.core.shape.wires.WiresContainer;
import com.ait.lienzo.client.core.shape.wires.WiresShape;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.client.lienzo.canvas.controls.AbstractContainmentBasedControl;
import org.kie.workbench.common.stunner.client.lienzo.canvas.wires.WiresCanvas;
import org.kie.workbench.common.stunner.client.lienzo.canvas.wires.WiresUtils;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.docking.DockingAcceptorControl;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandFactory;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Dock;

@Dependent
public class DockingAcceptorControlImpl
extends AbstractContainmentBasedControl
implements DockingAcceptorControl<AbstractCanvasHandler> {
    private static final int HOTSPOT = 10;
    private CanvasCommandFactory<AbstractCanvasHandler> canvasCommandFactory;
    private final IDockingAcceptor DOCKING_ACCEPTOR = new IDockingAcceptor(){

        public boolean dockingAllowed(WiresContainer wiresContainer, WiresShape wiresShape) {
            if (!DockingAcceptorControlImpl.this.isAccept(wiresContainer, wiresShape)) {
                return false;
            }
            Node childNode = WiresUtils.getNode(DockingAcceptorControlImpl.this.getCanvasHandler(), (WiresContainer)wiresShape);
            Node parentNode = WiresUtils.getNode(DockingAcceptorControlImpl.this.getCanvasHandler(), wiresContainer);
            return DockingAcceptorControlImpl.this.allow(parentNode, childNode);
        }

        public boolean acceptDocking(WiresContainer wiresContainer, WiresShape wiresShape) {
            if (!DockingAcceptorControlImpl.this.isAccept(wiresContainer, wiresShape)) {
                return false;
            }
            Node childNode = WiresUtils.getNode(DockingAcceptorControlImpl.this.getCanvasHandler(), (WiresContainer)wiresShape);
            Node parentNode = WiresUtils.getNode(DockingAcceptorControlImpl.this.getCanvasHandler(), wiresContainer);
            return DockingAcceptorControlImpl.this.accept(parentNode, childNode);
        }

        public int getHotspotSize() {
            return 10;
        }
    };

    @Inject
    public DockingAcceptorControlImpl(CanvasCommandFactory<AbstractCanvasHandler> canvasCommandFactory) {
        this.canvasCommandFactory = canvasCommandFactory;
    }

    @Override
    protected void doEnable(WiresCanvas.View view) {
        view.setDockingAcceptor(this.DOCKING_ACCEPTOR);
    }

    @Override
    protected void doDisable(WiresCanvas.View view) {
        view.setDockingAcceptor(IDockingAcceptor.NONE);
    }

    @Override
    protected boolean isEdgeAccepted(Edge edge) {
        return edge.getContent() instanceof Dock;
    }

    @Override
    protected Command<AbstractCanvasHandler, CanvasViolation> getAddEdgeCommand(Node parent, Node child) {
        return this.canvasCommandFactory.dockNode(parent, child);
    }

    @Override
    protected Command<AbstractCanvasHandler, CanvasViolation> getDeleteEdgeCommand(Node parent, Node child) {
        return this.canvasCommandFactory.unDockNode(parent, child);
    }
}

