/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.canvas.controls.resize;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.AbstractCanvasHandlerRegistrationControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.resize.ResizeControl;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandFactory;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandManager;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolationImpl;
import org.kie.workbench.common.stunner.core.client.command.RequiresCommandManager;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.view.HasControlPoints;
import org.kie.workbench.common.stunner.core.client.shape.view.HasEventHandlers;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeView;
import org.kie.workbench.common.stunner.core.client.shape.view.event.MouseClickEvent;
import org.kie.workbench.common.stunner.core.client.shape.view.event.MouseClickHandler;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ResizeEvent;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ResizeHandler;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewEventType;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewHandler;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.impl.CommandResultImpl;
import org.kie.workbench.common.stunner.core.command.impl.CompositeCommandImpl;
import org.kie.workbench.common.stunner.core.command.util.CommandUtils;
import org.kie.workbench.common.stunner.core.definition.adapter.DefinitionAdapter;
import org.kie.workbench.common.stunner.core.definition.property.PropertyMetaTypes;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.content.view.BoundImpl;
import org.kie.workbench.common.stunner.core.graph.content.view.BoundsImpl;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.util.GraphUtils;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;
import org.kie.workbench.common.stunner.core.rule.violations.BoundsExceededViolation;

@Dependent
public class ResizeControlImpl
extends AbstractCanvasHandlerRegistrationControl<AbstractCanvasHandler>
implements ResizeControl<AbstractCanvasHandler, Element> {
    private static Logger LOGGER = Logger.getLogger(ResizeControlImpl.class.getName());
    private final CanvasCommandFactory<AbstractCanvasHandler> canvasCommandFactory;
    private RequiresCommandManager.CommandManagerProvider<AbstractCanvasHandler> commandManagerProvider;

    protected ResizeControlImpl() {
        this(null);
    }

    @Inject
    public ResizeControlImpl(CanvasCommandFactory<AbstractCanvasHandler> canvasCommandFactory) {
        this.canvasCommandFactory = canvasCommandFactory;
    }

    public void register(Element element) {
        AbstractCanvas canvas;
        Shape shape;
        if (this.checkNotRegistered(element) && this.supportsResize(shape = (canvas = this.canvasHandler.getAbstractCanvas()).getShape(element.getUUID()))) {
            this.registerCPHandlers(element, shape.getShapeView());
            this.registerResizeHandlers(element, shape);
        }
    }

    public CommandResult<CanvasViolation> resize(Element element, double width, double height) {
        return this.doResize(element, null, null, width, height);
    }

    public CommandResult<CanvasViolation> resize(Element element, double x, double y, double width, double height) {
        return this.doResize(element, x, y, width, height);
    }

    public void setCommandManagerProvider(RequiresCommandManager.CommandManagerProvider<AbstractCanvasHandler> provider) {
        this.commandManagerProvider = provider;
    }

    protected void doDisable() {
        super.doDisable();
        this.commandManagerProvider = null;
    }

    private boolean supportsResize(Shape<?> shape) {
        ShapeView view = shape.getShapeView();
        boolean supportsResize = view instanceof HasEventHandlers && ((HasEventHandlers)view).supports(ViewEventType.RESIZE) && ((HasEventHandlers)view).supports(ViewEventType.MOUSE_CLICK);
        boolean supportsCtrlPoints = view instanceof HasControlPoints;
        return supportsResize && supportsCtrlPoints;
    }

    private void registerCPHandlers(Element element, ShapeView<?> shapeView) {
        HasEventHandlers hasEventHandlers = (HasEventHandlers)shapeView;
        final HasControlPoints hasControlPoints = (HasControlPoints)shapeView;
        if (hasEventHandlers.supports(ViewEventType.MOUSE_CLICK)) {
            MouseClickHandler clickHandler = new MouseClickHandler(){

                public void handle(MouseClickEvent event) {
                    if (event.isButtonLeft() && event.isShiftKeyDown() && !hasControlPoints.areControlsVisible()) {
                        hasControlPoints.showControlPoints(HasControlPoints.ControlPointType.RESIZE);
                    } else {
                        hasControlPoints.hideControlPoints();
                    }
                    ResizeControlImpl.this.canvasHandler.getCanvas().getLayer().draw();
                }
            };
            hasEventHandlers.addHandler(ViewEventType.MOUSE_CLICK, (ViewHandler)clickHandler);
            this.registerHandler(element.getUUID(), (ViewHandler)clickHandler);
        }
    }

    private void registerResizeHandlers(final Element element, Shape<?> shape) {
        if (shape.getShapeView() instanceof HasEventHandlers) {
            HasEventHandlers hasEventHandlers = (HasEventHandlers)shape.getShapeView();
            ResizeHandler resizeHandler = new ResizeHandler(){

                public void start(ResizeEvent event) {
                }

                public void handle(ResizeEvent event) {
                }

                public void end(ResizeEvent event) {
                    LOGGER.log(Level.FINE, "Shape [" + element.getUUID() + "] resized to size {" + event.getWidth() + ", " + event.getHeight() + "] & Coordinates [" + event.getX() + ", " + event.getY() + "]");
                    Shape shape = ResizeControlImpl.this.canvasHandler.getCanvas().getShape(element.getUUID());
                    double x = shape.getShapeView().getShapeX();
                    double y = shape.getShapeView().getShapeY();
                    CommandResult result = ResizeControlImpl.this.doResize(element, shape, x + event.getX(), y + event.getY(), event.getWidth(), event.getHeight());
                    if (CommandUtils.isError((CommandResult)result)) {
                        LOGGER.log(Level.WARNING, "Command failed at resize end [result=" + result + "]");
                    }
                }
            };
            hasEventHandlers.addHandler(ViewEventType.RESIZE, (ViewHandler)resizeHandler);
            this.registerHandler(element.getUUID(), (ViewHandler)resizeHandler);
        }
    }

    private CommandResult<CanvasViolation> doResize(Element<? extends View<?>> element, Double x, Double y, double w, double h) {
        Shape shape = this.canvasHandler.getCanvas().getShape(element.getUUID());
        return this.doResize(element, shape, x, y, w, h);
    }

    private CommandResult<CanvasViolation> doResize(Element<? extends View<?>> element, Shape shape, Double x, Double y, double w, double h) {
        CommandResult resizeResults;
        Point2D current = null != x && null != y ? new Point2D(x.doubleValue(), y.doubleValue()) : GraphUtils.getPosition((View)((View)element.getContent()));
        BoundsImpl newBounds = new BoundsImpl(new BoundImpl(Double.valueOf(current.getX()), Double.valueOf(current.getY())), new BoundImpl(Double.valueOf(current.getX() + w), Double.valueOf(current.getY() + h)));
        if (!GraphUtils.checkBoundsExceeded((Graph)this.canvasHandler.getDiagram().getGraph(), (Bounds)newBounds)) {
            CanvasViolation cv = CanvasViolationImpl.Builder.build((RuleViolation)new BoundsExceededViolation((Bounds)newBounds).setUUID(this.canvasHandler.getUuid()));
            return new CommandResultImpl(CommandResult.Type.ERROR, Collections.singleton(cv));
        }
        List<Command<AbstractCanvasHandler, CanvasViolation>> commands = this.getResizeCommands(element, shape, w, h);
        CompositeCommandImpl.CompositeCommandBuilder commandBuilder = new CompositeCommandImpl.CompositeCommandBuilder();
        if (null != commands) {
            if (null != x && null != y) {
                commandBuilder.addCommand((Command)this.canvasCommandFactory.updatePosition((Node)element, x, y));
            }
            commands.stream().forEach(arg_0 -> ((CompositeCommandImpl.CompositeCommandBuilder)commandBuilder).addCommand(arg_0));
        }
        if (!CommandUtils.isError((CommandResult)(resizeResults = this.getCommandManager().execute((Object)this.canvasHandler, (Command)commandBuilder.build())))) {
            ((View)element.getContent()).setBounds((Bounds)newBounds);
        }
        return resizeResults;
    }

    private List<Command<AbstractCanvasHandler, CanvasViolation>> getResizeCommands(Element<? extends Definition<?>> element, Shape shape, double w, double h) {
        Object radius;
        Object height;
        Definition content = (Definition)element.getContent();
        Object def = content.getDefinition();
        DefinitionAdapter adapter = this.canvasHandler.getDefinitionManager().adapters().registry().getDefinitionAdapter(def.getClass());
        LinkedList<Command<AbstractCanvasHandler, CanvasViolation>> result = new LinkedList<Command<AbstractCanvasHandler, CanvasViolation>>();
        Object width = adapter.getMetaProperty(PropertyMetaTypes.WIDTH, def);
        if (null != width) {
            this.appendCommandForModelProperty(element, width, w, result);
        }
        if (null != (height = adapter.getMetaProperty(PropertyMetaTypes.HEIGHT, def))) {
            this.appendCommandForModelProperty(element, height, h, result);
        }
        if (null != (radius = adapter.getMetaProperty(PropertyMetaTypes.RADIUS, def))) {
            double r = w > h ? h / 2.0 : w / 2.0;
            this.appendCommandForModelProperty(element, radius, r, result);
        }
        return result;
    }

    private void appendCommandForModelProperty(Element<? extends Definition<?>> element, Object property, Object value, List<Command<AbstractCanvasHandler, CanvasViolation>> result) {
        String id = this.canvasHandler.getDefinitionManager().adapters().forProperty().getId(property);
        result.add((Command<AbstractCanvasHandler, CanvasViolation>)this.canvasCommandFactory.updatePropertyValue(element, id, value));
    }

    private CanvasCommandManager<AbstractCanvasHandler> getCommandManager() {
        return this.commandManagerProvider.getCommandManager();
    }
}

