/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.canvas.wires;

import com.ait.lienzo.client.core.shape.IDrawable;
import com.ait.lienzo.client.core.shape.wires.WiresConnector;
import com.ait.lienzo.client.core.shape.wires.WiresContainer;
import com.ait.lienzo.client.core.shape.wires.WiresLayer;
import com.ait.lienzo.client.core.shape.wires.WiresMagnet;
import com.ait.lienzo.client.core.shape.wires.WiresShape;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeView;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;

public final class WiresUtils {
    public static Point2D getAbsolute(IDrawable<?> shape) {
        com.ait.lienzo.client.core.types.Point2D p = com.ait.lienzo.client.core.shape.wires.WiresUtils.getLocation(shape);
        return new Point2D(p.getX(), p.getY());
    }

    public static Node getNode(AbstractCanvasHandler canvasHandler, WiresContainer shape) {
        String canvasRoot;
        if (null == shape) {
            return null;
        }
        if (shape instanceof ShapeView) {
            ShapeView view = (ShapeView)shape;
            return canvasHandler.getGraphIndex().getNode(view.getUUID());
        }
        if (shape instanceof WiresLayer && null != (canvasRoot = canvasHandler.getDiagram().getMetadata().getCanvasRootUUID())) {
            return canvasHandler.getGraphIndex().getNode(canvasRoot);
        }
        return null;
    }

    public static Node getNode(AbstractCanvasHandler canvasHandler, WiresMagnet magnet) {
        if (null == magnet) {
            return null;
        }
        WiresShape shape = magnet.getMagnets().getWiresShape();
        return WiresUtils.getNode(canvasHandler, (WiresContainer)shape);
    }

    public static Edge getEdge(AbstractCanvasHandler canvasHandler, WiresConnector connector) {
        if (connector instanceof ShapeView) {
            ShapeView view = (ShapeView)connector;
            return canvasHandler.getGraphIndex().getEdge(view.getUUID());
        }
        return null;
    }

    public static boolean isWiresShape(ShapeView<?> shapeView) {
        return shapeView instanceof WiresShape;
    }

    public static boolean isWiresContainer(ShapeView<?> shapeView) {
        return shapeView instanceof WiresContainer;
    }

    public static boolean isWiresConnector(ShapeView<?> shapeView) {
        return shapeView instanceof WiresConnector;
    }

    public static boolean isWiresShape(WiresContainer wiresShape) {
        return WiresUtils.isWiresLayer(wiresShape) || null != wiresShape && null != wiresShape.getContainer().getUserData() && "stnner.wiresCanvas".equals(WiresUtils.getShapeGroup(wiresShape.getContainer()));
    }

    public static boolean isWiresLayer(WiresContainer wiresShape) {
        return null != wiresShape && wiresShape instanceof WiresLayer;
    }

    public static void assertShapeUUID(IDrawable<?> shape, String uuid) {
        UserData ud = WiresUtils.assertUserData(shape);
        ud.setUuid(uuid);
    }

    private static UserData assertUserData(IDrawable<?> shape) {
        Object o = shape.getUserData();
        if (o == null) {
            o = new UserData();
            shape.setUserData(o);
        } else if (!(o instanceof UserData)) {
            throw new IllegalStateException("WiresShape expected to have 'UserData' user data.");
        }
        return (UserData)o;
    }

    public static String getShapeUUID(IDrawable<?> shape) {
        Object o = shape.getUserData();
        if (o == null) {
            return null;
        }
        if (!(o instanceof UserData)) {
            throw new IllegalStateException("WiresShape expected to have 'UserData' user data.");
        }
        UserData ud = (UserData)o;
        return ud.getUuid();
    }

    public static void assertShapeGroup(IDrawable<?> shape, String group) {
        UserData ud = WiresUtils.assertUserData(shape);
        ud.setGroup(group);
    }

    public static String getShapeGroup(IDrawable<?> shape) {
        Object o = shape.getUserData();
        if (o == null) {
            return null;
        }
        if (!(o instanceof UserData)) {
            throw new IllegalStateException("WiresShape expected to have 'UserData' user data.");
        }
        UserData ud = (UserData)o;
        return ud.getGroup();
    }

    public static class UserData {
        private String uuid;
        private String group;

        public String getUuid() {
            return this.uuid;
        }

        public void setUuid(String uuid) {
            this.uuid = uuid;
        }

        public String getGroup() {
            return this.group;
        }

        public void setGroup(String group) {
            this.group = group;
        }
    }
}

