/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.components.palette;

import org.kie.workbench.common.stunner.client.lienzo.components.palette.LienzoPalette;
import org.kie.workbench.common.stunner.client.lienzo.components.palette.view.LienzoPaletteView;
import org.kie.workbench.common.stunner.core.client.api.ShapeManager;
import org.kie.workbench.common.stunner.core.client.components.palette.AbstractPalette;
import org.kie.workbench.common.stunner.core.client.components.palette.model.HasPaletteItems;
import org.kie.workbench.common.stunner.core.client.components.palette.view.PaletteGrid;
import org.kie.workbench.common.stunner.core.client.components.palette.view.PaletteGridLayoutBuilder;

public abstract class AbstractLienzoPalette<D extends HasPaletteItems, V extends LienzoPaletteView>
extends AbstractPalette<D>
implements LienzoPalette<D, V> {
    protected boolean expanded;
    protected int iconSize;
    protected int padding;
    protected LienzoPalette.Layout layout;
    protected V view;
    protected boolean isExpandable;

    protected AbstractLienzoPalette() {
        this(null, null);
    }

    public AbstractLienzoPalette(ShapeManager shapeManager, V view) {
        super(shapeManager);
        this.view = view;
        this.expanded = false;
        this.iconSize = 50;
        this.padding = 10;
        this.isExpandable = true;
        this.layout = LienzoPalette.Layout.VERTICAL;
    }

    protected abstract void doBind();

    protected abstract void doExpandCollapse();

    public abstract double[] computePaletteSize();

    protected void doInit() {
        this.view.setPresenter(this);
    }

    public AbstractLienzoPalette bind() {
        this.view.clear();
        this.beforeBind();
        this.doBind();
        this.afterBind();
        this.view.draw();
        return this;
    }

    protected void beforeBind() {
    }

    protected void afterBind() {
    }

    @Override
    public LienzoPalette<D, V> setExpandable(boolean canExpand) {
        this.isExpandable = canExpand;
        return this;
    }

    public boolean isExpandable() {
        return this.isExpandable;
    }

    @Override
    public void setLayout(LienzoPalette.Layout layout) {
        this.layout = layout;
    }

    @Override
    public LienzoPalette<D, V> setIconSize(int iconSize) {
        this.iconSize = iconSize;
        return this;
    }

    @Override
    public LienzoPalette<D, V> setPadding(int padding) {
        this.padding = padding;
        return this;
    }

    @Override
    public LienzoPalette<D, V> expand() {
        if (!this.isExpandable) {
            throw new IllegalStateException("Palette is not expandable");
        }
        this.expanded = true;
        this.doExpandCollapse();
        return this;
    }

    @Override
    public LienzoPalette<D, V> collapse() {
        if (!this.isExpandable) {
            throw new IllegalStateException("Palette is not expandable");
        }
        this.expanded = false;
        this.doExpandCollapse();
        return this;
    }

    protected void doDestroy() {
        this.getView().destroy();
    }

    public PaletteGrid getGrid() {
        PaletteGridLayoutBuilder gridLayoutBuilder = this.isHorizontalLayout() ? PaletteGridLayoutBuilder.HORIZONTAL : PaletteGridLayoutBuilder.VERTICAL;
        gridLayoutBuilder.setIconSize(this.iconSize);
        gridLayoutBuilder.setPadding(this.padding);
        return gridLayoutBuilder.build();
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    protected boolean isHorizontalLayout() {
        return this.layout.equals((Object)LienzoPalette.Layout.HORIZONTAL);
    }

    @Override
    public V getView() {
        return this.view;
    }
}

