/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.shape.view;

import com.ait.lienzo.client.core.shape.AbstractDirectionalMultiPointShape;
import com.ait.lienzo.client.core.shape.MultiPathDecorator;
import com.ait.lienzo.client.core.shape.Shape;
import com.ait.lienzo.client.core.shape.wires.IControlHandle;
import com.ait.lienzo.client.core.shape.wires.MagnetManager;
import com.ait.lienzo.client.core.shape.wires.WiresConnector;
import com.ait.lienzo.client.core.shape.wires.WiresContainer;
import com.ait.lienzo.client.core.shape.wires.WiresMagnet;
import com.ait.lienzo.client.core.shape.wires.WiresShape;
import com.ait.lienzo.client.core.shape.wires.handlers.WiresConnectorControl;
import com.ait.lienzo.shared.core.types.ColorName;
import com.ait.lienzo.shared.core.types.IColor;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.StreamSupport;
import org.kie.workbench.common.stunner.client.lienzo.canvas.wires.WiresUtils;
import org.kie.workbench.common.stunner.core.client.shape.view.HasControlPoints;
import org.kie.workbench.common.stunner.core.client.shape.view.HasDecorators;
import org.kie.workbench.common.stunner.core.client.shape.view.IsConnector;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeView;
import org.kie.workbench.common.stunner.core.client.util.ShapeUtils;
import org.kie.workbench.common.stunner.core.graph.content.view.Magnet;
import org.kie.workbench.common.stunner.core.graph.content.view.MagnetImpl;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;

public class WiresConnectorView<T>
extends WiresConnector
implements ShapeView<T>,
IsConnector<T>,
HasControlPoints<T>,
HasDecorators<Shape<?>> {
    protected String uuid;
    private WiresConnectorControl connectorControl;

    public WiresConnectorView(AbstractDirectionalMultiPointShape<?> line, MultiPathDecorator headDecorator, MultiPathDecorator tailDecorator) {
        super(line, headDecorator, tailDecorator);
        this.init();
    }

    public WiresConnectorView(WiresMagnet headMagnet, WiresMagnet tailMagnet, AbstractDirectionalMultiPointShape<?> line, MultiPathDecorator headDecorator, MultiPathDecorator tailDecorator) {
        super(headMagnet, tailMagnet, line, headDecorator, tailDecorator);
        this.init();
    }

    private void init() {
        ((AbstractDirectionalMultiPointShape)this.getLine().setFillColor((IColor)ColorName.WHITE)).setStrokeWidth(0.0);
    }

    public T setUUID(String uuid) {
        this.uuid = uuid;
        WiresUtils.assertShapeUUID(this.getGroup(), uuid);
        return (T)((Object)this);
    }

    public String getUUID() {
        return this.uuid;
    }

    public T setControl(WiresConnectorControl connectorControl) {
        this.connectorControl = connectorControl;
        return (T)((Object)this);
    }

    public WiresConnectorControl getControl() {
        return this.connectorControl;
    }

    public T connect(ShapeView headShapeView, Magnet headMagnetDef, ShapeView tailShapeView, Magnet tailMagnetDef, boolean tailArrow, boolean headArrow) {
        WiresShape headWiresShape = (WiresShape)headShapeView;
        WiresShape tailWiresShape = (WiresShape)tailShapeView;
        MagnetManager.Magnets headMagnets = headWiresShape.getMagnets();
        MagnetManager.Magnets tailMagnets = tailWiresShape.getMagnets();
        Point2D headCoords = this.getAbsoluteCoordinates(headWiresShape);
        WiresMagnet headMagnet = this.getWiresMagnet(headMagnets, headMagnetDef, headCoords.getX(), headCoords.getY(), 3);
        Point2D tailCoords = this.getAbsoluteCoordinates(tailWiresShape);
        WiresMagnet tailMagnet = this.getWiresMagnet(tailMagnets, tailMagnetDef, tailCoords.getX(), tailCoords.getY(), 7);
        this.setHeadMagnet(headMagnet);
        this.setTailMagnet(tailMagnet);
        return (T)((Object)this);
    }

    private Point2D getAbsoluteCoordinates(WiresShape wiresShape) {
        double x = wiresShape.getX();
        double y = wiresShape.getY();
        WiresContainer parent = wiresShape.getParent();
        while (parent instanceof WiresShape) {
            WiresShape parentShape = (WiresShape)parent;
            x += parentShape.getX();
            y += parentShape.getY();
            parent = parentShape.getParent();
        }
        return new Point2D(x, y);
    }

    private WiresMagnet getWiresMagnet(MagnetManager.Magnets wiresMagnets, Magnet magnetDef, double shapeX, double shapeY, int defaultMagnetIndex) {
        if (magnetDef == null) {
            return wiresMagnets.getMagnet(0);
        }
        if (magnetDef.getLocation() != null) {
            MagnetImpl absMagnetDef = MagnetImpl.Builder.build((double)(magnetDef.getLocation().getX() + shapeX), (double)(magnetDef.getLocation().getY() + shapeY));
            return (WiresMagnet)StreamSupport.stream(wiresMagnets.getMagnets().spliterator(), false).sorted((arg_0, arg_1) -> this.lambda$getWiresMagnet$0((Magnet)absMagnetDef, arg_0, arg_1)).findFirst().get();
        }
        if (magnetDef.getMagnetType() != null) {
            if (magnetDef.getMagnetType() == Magnet.MagnetType.OUTGOING) {
                return wiresMagnets.getMagnet(3);
            }
            return wiresMagnets.getMagnet(7);
        }
        return wiresMagnets.getMagnet(defaultMagnetIndex);
    }

    private int compare(IControlHandle m1, IControlHandle m2, Magnet magnet) {
        double mx = magnet.getLocation().getX();
        double my = magnet.getLocation().getY();
        com.ait.lienzo.client.core.types.Point2D m1p = m1.getControl().getLocation();
        com.ait.lienzo.client.core.types.Point2D m2p = m2.getControl().getLocation();
        double d1 = ShapeUtils.dist((double)mx, (double)my, (double)m1p.getX(), (double)m1p.getY());
        double d2 = ShapeUtils.dist((double)mx, (double)my, (double)m2p.getX(), (double)m2p.getY());
        return Double.compare(d1, d2);
    }

    public void removeFromParent() {
        super.removeFromLayer();
    }

    public double getShapeX() {
        return this.getGroup().getX();
    }

    public double getShapeY() {
        return this.getGroup().getY();
    }

    public T setShapeX(double x) {
        this.getGroup().setX(x);
        return (T)((Object)this);
    }

    public T setShapeY(double y) {
        this.getGroup().setY(y);
        return (T)((Object)this);
    }

    public double getAlpha() {
        return this.getGroup().getAlpha();
    }

    public T setAlpha(double alpha) {
        this.getGroup().setAlpha(alpha);
        return (T)((Object)this);
    }

    public Point2D getShapeAbsoluteLocation() {
        return WiresUtils.getAbsolute(this.getGroup());
    }

    public String getFillColor() {
        return this.getLine().getFillColor();
    }

    public T setFillColor(String color) {
        this.getLine().setFillColor(color);
        if (null != this.getHead()) {
            this.getHead().setFillColor(color);
        }
        if (null != this.getTail()) {
            this.getTail().setFillColor(color);
        }
        return (T)((Object)this);
    }

    public double getFillAlpha() {
        return this.getLine().getFillAlpha();
    }

    public T setFillAlpha(double alpha) {
        this.getLine().setFillAlpha(alpha);
        if (null != this.getHead()) {
            this.getHead().setFillAlpha(alpha);
        }
        if (null != this.getTail()) {
            this.getTail().setFillAlpha(alpha);
        }
        return (T)((Object)this);
    }

    public String getStrokeColor() {
        return this.getLine().getStrokeColor();
    }

    public T setStrokeColor(String color) {
        this.getLine().setStrokeColor(color);
        if (null != this.getHead()) {
            this.getHead().setStrokeColor(color);
        }
        if (null != this.getTail()) {
            this.getTail().setStrokeColor(color);
        }
        return (T)((Object)this);
    }

    public double getStrokeAlpha() {
        return this.getLine().getStrokeAlpha();
    }

    public T setStrokeAlpha(double alpha) {
        this.getLine().setStrokeAlpha(alpha);
        if (null != this.getHead()) {
            this.getHead().setStrokeAlpha(alpha);
        }
        if (null != this.getTail()) {
            this.getTail().setStrokeAlpha(alpha);
        }
        return (T)((Object)this);
    }

    public double getStrokeWidth() {
        return this.getLine().getStrokeWidth();
    }

    public T setStrokeWidth(double width) {
        this.getLine().setStrokeWidth(width);
        if (null != this.getHead()) {
            this.getHead().setStrokeWidth(width);
        }
        if (null != this.getTail()) {
            this.getTail().setStrokeWidth(width);
        }
        return (T)((Object)this);
    }

    public T moveToTop() {
        this.getGroup().moveToTop();
        return (T)((Object)this);
    }

    public T moveToBottom() {
        this.getGroup().moveToBottom();
        return (T)((Object)this);
    }

    public T moveUp() {
        this.getGroup().moveUp();
        return (T)((Object)this);
    }

    public T moveDown() {
        this.getGroup().moveDown();
        return (T)((Object)this);
    }

    public T showControlPoints(HasControlPoints.ControlPointType type) {
        if (null != this.getControl()) {
            if (HasControlPoints.ControlPointType.POINTS.equals((Object)type)) {
                this.getControl().showControlPoints();
            } else {
                throw new UnsupportedOperationException("Control point type [" + type + "] not supported yet");
            }
        }
        return (T)((Object)this);
    }

    public T hideControlPoints() {
        if (null != this.getControl()) {
            this.getControl().hideControlPoints();
        }
        return (T)((Object)this);
    }

    public boolean areControlsVisible() {
        return this.getPointHandles().isVisible();
    }

    public void destroy() {
        super.destroy();
        this.connectorControl = null;
    }

    public List<Shape<?>> getDecorators() {
        ArrayList decorators = new ArrayList(3);
        decorators.add((Shape<?>)this.getLine());
        if (null != this.getHead()) {
            decorators.add((Shape<?>)this.getHead());
        }
        if (null != this.getTail()) {
            decorators.add((Shape<?>)this.getTail());
        }
        return decorators;
    }

    private /* synthetic */ int lambda$getWiresMagnet$0(Magnet absMagnetDef, IControlHandle m1, IControlHandle m2) {
        return this.compare(m1, m2, absMagnetDef);
    }
}

