/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.shape.view.ext;

import com.ait.lienzo.client.core.shape.AbstractDirectionalMultiPointShape;
import com.ait.lienzo.client.core.shape.MultiPathDecorator;
import com.ait.lienzo.client.core.shape.Node;
import com.ait.lienzo.client.core.shape.Shape;
import com.ait.lienzo.client.core.shape.Text;
import com.ait.lienzo.client.core.shape.wires.LayoutContainer;
import com.ait.lienzo.client.core.shape.wires.WiresMagnet;
import org.kie.workbench.common.stunner.client.lienzo.shape.view.ViewEventHandlerManager;
import org.kie.workbench.common.stunner.client.lienzo.shape.view.WiresConnectorView;
import org.kie.workbench.common.stunner.core.client.shape.view.HasEventHandlers;
import org.kie.workbench.common.stunner.core.client.shape.view.HasTitle;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewEvent;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewEventType;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewHandler;
import org.uberfire.mvp.Command;

public class WiresConnectorViewExt<T>
extends WiresConnectorView<T>
implements HasTitle<T>,
HasEventHandlers<T, Shape<?>> {
    protected ViewEventHandlerManager eventHandlerManager;
    protected Text text;
    protected LayoutContainer.Layout textPosition;
    protected double textRotationDegrees;

    public WiresConnectorViewExt(ViewEventType[] supportedEventTypes, AbstractDirectionalMultiPointShape<?> line, MultiPathDecorator headDecorator, MultiPathDecorator tailDecorator) {
        super(line, headDecorator, tailDecorator);
        this.init(supportedEventTypes);
    }

    public WiresConnectorViewExt(ViewEventType[] supportedEventTypes, WiresMagnet headMagnet, WiresMagnet tailMagnet, AbstractDirectionalMultiPointShape<?> line, MultiPathDecorator headDecorator, MultiPathDecorator tailDecorator) {
        super(headMagnet, tailMagnet, line, headDecorator, tailDecorator);
        this.init(supportedEventTypes);
    }

    protected void init(ViewEventType[] supportedEventTypes) {
        this.textPosition = LayoutContainer.Layout.CENTER;
        this.textRotationDegrees = 0.0;
        this.eventHandlerManager = new ViewEventHandlerManager((Node<?>)this.getLine(), (Node<?>)this.getLine(), supportedEventTypes);
    }

    public boolean supports(ViewEventType type) {
        return this.eventHandlerManager.supports(type);
    }

    public Shape<?> getAttachableShape() {
        return this.getLine();
    }

    public T addHandler(ViewEventType type, ViewHandler<? extends ViewEvent> eventHandler) {
        this.eventHandlerManager.addHandler(type, eventHandler);
        return (T)((Object)this);
    }

    public T removeHandler(ViewHandler<? extends ViewEvent> eventHandler) {
        this.eventHandlerManager.removeHandler(eventHandler);
        return (T)((Object)this);
    }

    public T disableHandlers() {
        this.eventHandlerManager.disable();
        return (T)((Object)this);
    }

    public T enableHandlers() {
        this.eventHandlerManager.enable();
        return (T)((Object)this);
    }

    public T setTitle(String title) {
        if (null != this.text) {
            this.text.removeFromParent();
        }
        if (null != title) {
            // empty if block
        }
        return (T)((Object)this);
    }

    public T setTitlePosition(HasTitle.Position position) {
        if (HasTitle.Position.BOTTOM.equals((Object)position)) {
            this.textPosition = LayoutContainer.Layout.BOTTOM;
        } else if (HasTitle.Position.TOP.equals((Object)position)) {
            this.textPosition = LayoutContainer.Layout.TOP;
        } else if (HasTitle.Position.LEFT.equals((Object)position)) {
            this.textPosition = LayoutContainer.Layout.LEFT;
        } else if (HasTitle.Position.RIGHT.equals((Object)position)) {
            this.textPosition = LayoutContainer.Layout.RIGHT;
        } else if (HasTitle.Position.CENTER.equals((Object)position)) {
            this.textPosition = LayoutContainer.Layout.CENTER;
        }
        return (T)((Object)this);
    }

    public T setTitleRotation(double degrees) {
        this.textRotationDegrees = degrees;
        return (T)((Object)this);
    }

    public T setTitleStrokeColor(String color) {
        return this.updateTextIfAny(() -> {
            Text cfr_ignored_0 = (Text)this.text.setStrokeColor(color);
        });
    }

    public T setTitleFontFamily(String fontFamily) {
        return this.updateTextIfAny(() -> this.text.setFontFamily(fontFamily));
    }

    public T setTitleFontSize(double fontSize) {
        return this.updateTextIfAny(() -> this.text.setFontSize(fontSize));
    }

    public T setTitleStrokeWidth(double strokeWidth) {
        return this.updateTextIfAny(() -> {
            Text cfr_ignored_0 = (Text)this.text.setStrokeWidth(strokeWidth);
        });
    }

    public T moveTitleToTop() {
        return this.updateTextIfAny(() -> {
            Text cfr_ignored_0 = (Text)this.text.moveToTop();
        });
    }

    public T setTitleAlpha(double alpha) {
        return this.updateTextIfAny(() -> {
            Text cfr_ignored_0 = (Text)this.text.setAlpha(alpha);
        });
    }

    @Override
    public void destroy() {
        super.destroy();
        if (null != this.eventHandlerManager) {
            this.eventHandlerManager.destroy();
            this.eventHandlerManager = null;
        }
        this.text = null;
        this.textPosition = null;
    }

    private T updateTextIfAny(Command callback) {
        if (null != this.text) {
            callback.execute();
        }
        return (T)((Object)this);
    }
}

