/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.components.palette.view;

import com.ait.lienzo.client.core.animation.AnimationProperties;
import com.ait.lienzo.client.core.animation.AnimationProperty;
import com.ait.lienzo.client.core.animation.AnimationTweener;
import com.ait.lienzo.client.core.shape.Arrow;
import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.shape.Layer;
import com.ait.lienzo.client.core.shape.Rectangle;
import com.ait.lienzo.client.core.types.Point2D;
import com.ait.lienzo.shared.core.types.ArrowType;
import com.ait.lienzo.shared.core.types.ColorName;
import org.kie.workbench.common.stunner.client.lienzo.components.palette.AbstractLienzoPalette;
import org.kie.workbench.common.stunner.client.lienzo.components.palette.view.LienzoPaletteView;
import org.kie.workbench.common.stunner.client.lienzo.components.palette.view.element.LienzoGlyphPaletteItemView;
import org.kie.workbench.common.stunner.client.lienzo.components.palette.view.element.LienzoPaletteElementView;
import org.kie.workbench.common.stunner.core.client.components.palette.view.AbstractPaletteView;
import org.kie.workbench.common.stunner.core.client.components.palette.view.PaletteGrid;
import org.kie.workbench.common.stunner.core.client.shape.view.event.HandlerRegistrationImpl;
import org.kie.workbench.common.stunner.lienzo.palette.AbstractPalette;
import org.kie.workbench.common.stunner.lienzo.palette.HoverPalette;

public abstract class AbstractLienzoPaletteView<V extends LienzoPaletteView>
extends AbstractPaletteView<V, Layer, LienzoPaletteElementView>
implements LienzoPaletteView<V, LienzoPaletteElementView> {
    protected double animationDuration = 500.0;
    protected AbstractLienzoPalette presenter;
    protected AbstractPalette<? extends AbstractPalette> palette;
    protected IPrimitive<?> colExpButton;
    protected final HandlerRegistrationImpl handlerRegistrationManager = new HandlerRegistrationImpl();

    protected abstract AbstractPalette<? extends AbstractPalette> buildPalette();

    protected AbstractPalette<? extends AbstractPalette> getPalette() {
        if (null == this.palette) {
            this.palette = this.buildPalette();
            this.initPaletteCallbacks();
        }
        return this.palette;
    }

    @Override
    public void setPresenter(AbstractLienzoPalette presenter) {
        this.presenter = presenter;
    }

    protected void doClear() {
        if (this.getPalette().isVisible() && this.getPalette().getAlpha() > 0.0) {
            this.getPalette().setAlpha(0.0);
            this.draw();
        }
    }

    protected boolean isExpandable() {
        return this.presenter.isExpandable();
    }

    public V attach(Layer layer) {
        if (null == this.colExpButton && this.isExpandable()) {
            this.colExpButton = this.createExpandCollapseButton();
            layer.add(this.colExpButton);
        }
        layer.add(this.getPalette());
        return (V)this;
    }

    public Layer getLayer() {
        return this.getPalette().getLayer();
    }

    @Override
    public void draw() {
        this.getPalette().redraw();
    }

    public V show() {
        if (null == this.getPalette().getParent()) {
            throw new IllegalStateException("Palette must be attached to a layer before calling #show.");
        }
        if (!this.items.isEmpty()) {
            AbstractPalette.Item[] primitives = new AbstractPalette.Item[this.items.size()];
            int _x = 0;
            for (LienzoPaletteElementView paletteItemView : this.items) {
                AbstractPalette.Item i;
                primitives[_x] = i = this.buildLienzoPaletteItem(paletteItemView);
                ++_x;
            }
            double paletteStartY = 0.0;
            if (null != this.colExpButton && this.isExpandable()) {
                this.colExpButton.setX(this.x + (double)this.getGrid().getPadding());
                this.colExpButton.setY(this.y);
                paletteStartY = this.colExpButton.getBoundingBox().getHeight() + (double)this.getGrid().getPadding();
            }
            this.getPalette().setX(this.x);
            this.getPalette().setY(paletteStartY + this.y);
            this.getPalette().setRows(this.getGrid().getRows());
            this.getPalette().setColumns(this.getGrid().getColumns());
            this.getPalette().setIconSize(this.getGrid().getIconSize());
            this.getPalette().setPadding(this.getGrid().getPadding());
            this.getPalette().build(primitives);
            this.getPalette().setAlpha(0.0);
            this.getPalette().animate(AnimationTweener.LINEAR, AnimationProperties.toPropertyList((AnimationProperty)AnimationProperty.Properties.ALPHA((double)1.0), (AnimationProperty[])new AnimationProperty[0]), this.animationDuration);
            this.draw();
        } else {
            this.clear();
        }
        return (V)this;
    }

    public V hide() {
        this.getPalette().clearItems();
        this.getLayer().batch();
        return (V)this;
    }

    protected AbstractPalette.Item buildLienzoPaletteItem(LienzoPaletteElementView paletteItemView) {
        LienzoGlyphPaletteItemView.Decorator d;
        AbstractPalette.ItemDecorator decorator = null;
        if (paletteItemView instanceof LienzoGlyphPaletteItemView && null != (d = ((LienzoGlyphPaletteItemView)paletteItemView).getDecorator())) {
            decorator = AbstractPalette.ItemDecorator.DEFAULT;
        }
        return new AbstractPalette.Item((IPrimitive)paletteItemView.getView(), decorator);
    }

    public double getWidth() {
        return this.presenter.computePaletteSize()[0];
    }

    public double getHeight() {
        return this.presenter.computePaletteSize()[1];
    }

    public V clear() {
        this.removeExpandCollapseButton();
        return (V)((LienzoPaletteView)super.clear());
    }

    public void destroy() {
        this.removeExpandCollapseButton();
        if (null != this.palette) {
            this.palette.setItemCallback(null);
            this.palette.clear();
            this.palette.removeFromParent();
            this.palette = null;
        }
    }

    protected IPrimitive<?> createExpandCollapseButton() {
        boolean isExpanded = this.presenter.isExpanded();
        double w = this.getGrid().getIconSize();
        double h = (double)this.getGrid().getIconSize() / 1.5;
        Rectangle rectangle = (Rectangle)((Rectangle)((Rectangle)new Rectangle(w, h).setFillAlpha(0.01)).setStrokeWidth(0.0)).setStrokeAlpha(0.0);
        Arrow expandArrow = (Arrow)((Arrow)((Arrow)new Arrow(new Point2D(0.0, h / 2.0), new Point2D(w, h / 2.0), h / 2.0, h, 45.0, 90.0, ArrowType.AT_END_TAPERED).setFillColor(this.getArrowOutColor())).setFillAlpha(0.5)).setVisible(!isExpanded);
        Arrow collapseArrow = (Arrow)((Arrow)((Arrow)new Arrow(new Point2D(w, h / 2.0), new Point2D(0.0, h / 2.0), h / 2.0, h, 45.0, 90.0, ArrowType.AT_END_TAPERED).setFillColor(this.getArrowOutColor())).setFillAlpha(0.5)).setVisible(isExpanded);
        this.handlerRegistrationManager.register(rectangle.addNodeMouseClickHandler(nodeMouseClickEvent -> {
            if (this.presenter.isExpanded()) {
                expandArrow.setVisible(true);
                collapseArrow.setVisible(false);
                this.presenter.collapse();
            } else {
                expandArrow.setVisible(false);
                collapseArrow.setVisible(true);
                this.presenter.expand();
            }
        }));
        this.handlerRegistrationManager.register(rectangle.addNodeMouseEnterHandler(nodeMouseEnterEvent -> {
            this.stopHoverTimeoutPalette();
            if (this.presenter.isExpanded()) {
                this.animate((IPrimitive<?>)collapseArrow, this.getArrowHoverColor(), 1.0, 1.0);
            } else {
                this.animate((IPrimitive<?>)expandArrow, this.getArrowHoverColor(), 1.0, 1.0);
            }
        }));
        this.handlerRegistrationManager.register(rectangle.addNodeMouseExitHandler(nodeMouseExitEvent -> {
            this.startHoverTimeoutPalette();
            if (this.presenter.isExpanded()) {
                this.animate((IPrimitive<?>)collapseArrow, this.getArrowOutColor(), 0.5, 0.5);
            } else {
                this.animate((IPrimitive<?>)expandArrow, this.getArrowOutColor(), 0.5, 0.5);
            }
        }));
        return ((Group)((Group)new Group().add((IPrimitive)expandArrow)).add((IPrimitive)collapseArrow)).add((IPrimitive)rectangle.moveToTop());
    }

    private void animate(IPrimitive<?> primitive, String fillColor, double fillAlpha, double strokeAlpha) {
        primitive.animate(AnimationTweener.LINEAR, AnimationProperties.toPropertyList((AnimationProperty)AnimationProperty.Properties.FILL_COLOR((String)fillColor), (AnimationProperty[])new AnimationProperty[]{AnimationProperty.Properties.FILL_ALPHA((double)fillAlpha), AnimationProperty.Properties.STROKE_ALPHA((double)strokeAlpha)}), 200.0);
    }

    protected void removeExpandCollapseButton() {
        this.handlerRegistrationManager.removeHandler();
        if (null != this.colExpButton) {
            this.colExpButton.removeFromParent();
            this.colExpButton = null;
        }
    }

    protected void initPaletteCallbacks() {
        this.getPalette().setItemCallback(new AbstractPalette.Callback(){

            public void onItemHover(int index, double mouseX, double mouseY, double itemX, double itemY) {
                if (null != AbstractLienzoPaletteView.this.presenter) {
                    AbstractLienzoPaletteView.this.presenter.onItemHover(index, mouseX, mouseY, itemX, itemY);
                }
            }

            public void onItemOut(int index) {
                if (null != AbstractLienzoPaletteView.this.presenter) {
                    AbstractLienzoPaletteView.this.presenter.onItemOut(index);
                }
            }

            public void onItemMouseDown(int index, double mouseX, double mouseY, double itemX, double itemY) {
                if (null != AbstractLienzoPaletteView.this.presenter) {
                    AbstractLienzoPaletteView.this.presenter.onItemMouseDown(index, mouseX, mouseY, itemX, itemY);
                }
            }

            public void onItemClick(int index, double mouseX, double mouseY, double itemX, double itemY) {
                if (null != AbstractLienzoPaletteView.this.presenter) {
                    AbstractLienzoPaletteView.this.presenter.onItemClick(index, mouseX, mouseY, itemX, itemY);
                }
            }
        });
    }

    protected void stopHoverTimeoutPalette() {
        if (this.palette instanceof HoverPalette) {
            HoverPalette hoverPalette = (HoverPalette)this.palette;
            hoverPalette.stopTimeout();
        }
    }

    protected void startHoverTimeoutPalette() {
        if (this.palette instanceof HoverPalette) {
            HoverPalette hoverPalette = (HoverPalette)this.palette;
            hoverPalette.startTimeout();
        }
    }

    protected String getArrowHoverColor() {
        return ColorName.DARKBLUE.getColorString();
    }

    protected String getArrowOutColor() {
        return ColorName.LIGHTBLUE.getColorString();
    }

    protected PaletteGrid getGrid() {
        return this.presenter.getGrid();
    }
}

