/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.shape.view.ext;

import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.shape.MultiPath;
import com.ait.lienzo.client.core.shape.Node;
import com.ait.lienzo.client.core.shape.Shape;
import com.ait.lienzo.client.core.shape.wires.ControlHandleList;
import com.ait.lienzo.client.core.shape.wires.IControlHandle;
import com.ait.lienzo.client.core.shape.wires.LayoutContainer;
import com.ait.lienzo.client.core.shape.wires.WiresShape;
import com.ait.lienzo.client.core.shape.wires.WiresShapeControlHandleList;
import com.ait.lienzo.client.core.types.BoundingBox;
import com.ait.lienzo.shared.core.types.ColorName;
import com.ait.lienzo.shared.core.types.IColor;
import org.kie.workbench.common.stunner.client.lienzo.shape.view.ext.WiresShapeViewExt;
import org.kie.workbench.common.stunner.core.client.shape.view.HasSize;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewEventType;

public class DecoratedShapeView<T extends WiresShapeViewExt>
extends WiresShapeViewExt<T>
implements HasSize<T> {
    private final Shape<?> theShape;
    protected final Group transformableContainer = new Group();
    protected double width = 0.0;
    protected double height = 0.0;

    public DecoratedShapeView(ViewEventType[] supportedEventTypes, LayoutContainer layoutContainer, Shape<?> theShape, double width, double height) {
        super(supportedEventTypes, DecoratedShapeView.setupDecorator(new MultiPath(), 0.0, 0.0, width, height), layoutContainer);
        this.theShape = theShape;
        this.theShape.setFillBoundsForSelection(true);
        this.initializeHandlerManager((Node<?>)this.getGroup(), (Node<?>)theShape, supportedEventTypes);
        this.initializeTextView();
        this.getGroup().add((IPrimitive)this.transformableContainer);
        this.transformableContainer.add(theShape);
        this.resize(0.0, 0.0, width, height, false);
    }

    @Override
    public Shape<?> getShape() {
        return this.theShape;
    }

    @Override
    public Shape<?> getAttachableShape() {
        return this.theShape;
    }

    public DecoratedShapeView addScalableChild(IPrimitive<?> child) {
        this.transformableContainer.add(child);
        return this;
    }

    public T setSize(double width, double height) {
        this.resize(0.0, 0.0, width, height, true);
        return (T)((Object)this);
    }

    protected WiresShapeControlHandleList createControlHandles(IControlHandle.ControlHandleType type, ControlHandleList controls) {
        return new DecoratedWiresShapeControlHandleList(type, controls);
    }

    @Override
    protected void initialize(ViewEventType[] supportedEventTypes) {
    }

    void resize(double x, double y, double width, double height, boolean refresh) {
        if (this.width != width || this.height != height) {
            this.width = width;
            this.height = height;
            BoundingBox bb = this.transformableContainer.getBoundingBox();
            double sx = width / bb.getWidth();
            double sy = height / bb.getHeight();
            DecoratedShapeView.setupDecorator(this.getPath(), x, y, width, height);
            ((Group)((Group)this.transformableContainer.setX(x)).setY(y)).setScale(sx, sy);
        }
        if (refresh) {
            this.refresh();
        }
    }

    private static MultiPath setupDecorator(MultiPath path, double x, double y, double width, double height) {
        return (MultiPath)((MultiPath)((MultiPath)((MultiPath)path.clear()).rect(x, y, width, height).setStrokeColor((IColor)ColorName.BLACK)).setStrokeAlpha(0.0)).setFillAlpha(0.001);
    }

    private final class DecoratedWiresShapeControlHandleList
    extends WiresShapeControlHandleList {
        public DecoratedWiresShapeControlHandleList(IControlHandle.ControlHandleType controlsType, ControlHandleList controls) {
            super((WiresShape)DecoratedShapeView.this, controlsType, controls);
        }

        protected void resize(Double x, Double y, double width, double height, boolean refresh) {
            super.resize(x, y, width, height, refresh);
            DecoratedShapeView.this.resize(null != x ? x : 0.0, null != y ? y : 0.0, width, height, false);
        }
    }
}

