/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.shape.view.glyph;

import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.client.core.shape.wires.WiresConnector;
import com.ait.lienzo.client.core.shape.wires.WiresShape;
import com.ait.lienzo.client.core.types.BoundingBox;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.client.lienzo.shape.view.glyph.LienzoShapeGlyph;
import org.kie.workbench.common.stunner.client.lienzo.util.LienzoUtils;
import org.kie.workbench.common.stunner.core.api.FactoryManager;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.view.HasTitle;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeView;
import org.kie.workbench.common.stunner.core.client.shape.view.glyph.AbstractGlyphShapeBuilder;
import org.kie.workbench.common.stunner.core.client.shape.view.glyph.Glyph;
import org.kie.workbench.common.stunner.core.definition.shape.GlyphShapeDef;

@ApplicationScoped
public class LienzoShapesGlyphBuilder
extends AbstractGlyphShapeBuilder<Group> {
    private final FactoryManager factoryManager;

    protected LienzoShapesGlyphBuilder() {
        this(null);
    }

    @Inject
    public LienzoShapesGlyphBuilder(FactoryManager factoryManager) {
        this.factoryManager = factoryManager;
    }

    protected FactoryManager getFactoryManager() {
        return this.factoryManager;
    }

    protected Glyph<Group> doBuild(Shape<?> shape) {
        ShapeView view = shape.getShapeView();
        Group group = null;
        BoundingBox bb = null;
        if (view instanceof WiresShape) {
            group = ((WiresShape)view).getGroup();
            bb = ((WiresShape)view).getPath().getBoundingBox();
        } else if (view instanceof WiresConnector) {
            WiresConnector wiresConnector = (WiresConnector)view;
            group = wiresConnector.getGroup();
            bb = wiresConnector.getGroup().getBoundingBox();
        }
        if (null == group) {
            throw new RuntimeException("Shape view [" + view.toString() + "] not supported for this shape glyph builder [" + ((Object)((Object)this)).getClass().getName());
        }
        if (view instanceof HasTitle) {
            HasTitle hasTitle = (HasTitle)view;
            hasTitle.setTitle(null);
        }
        group = (Group)group.copy();
        double[] scale = LienzoUtils.getScaleFactor(bb.getWidth(), bb.getHeight(), this.width, this.height);
        group.setScale(scale[0], scale[1]);
        return new LienzoShapeGlyph(group, this.width, this.height);
    }

    public Class<?> getType() {
        return GlyphShapeDef.class;
    }
}

