/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.canvas.controls;

import com.ait.lienzo.client.core.shape.wires.IContainmentAcceptor;
import com.ait.lienzo.client.core.shape.wires.WiresContainer;
import com.ait.lienzo.client.core.shape.wires.WiresShape;
import java.util.ArrayList;
import java.util.function.Function;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Default;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.client.lienzo.canvas.controls.AbstractAcceptorControl;
import org.kie.workbench.common.stunner.client.lienzo.canvas.wires.WiresCanvas;
import org.kie.workbench.common.stunner.client.lienzo.canvas.wires.WiresUtils;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.containment.ContainmentAcceptorControl;
import org.kie.workbench.common.stunner.core.client.canvas.util.CanvasHighlight;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandFactory;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.impl.CompositeCommand;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;

@Dependent
@Default
public class ContainmentAcceptorControlImpl
extends AbstractAcceptorControl
implements ContainmentAcceptorControl<AbstractCanvasHandler> {
    private final CanvasCommandFactory<AbstractCanvasHandler> canvasCommandFactory;
    private CanvasHighlight canvasHighlight;
    private final IContainmentAcceptor CONTAINMENT_ACCEPTOR = new IContainmentAcceptor(){

        public boolean containmentAllowed(WiresContainer wiresContainer, WiresShape[] shapes) {
            if (!ContainmentAcceptorControlImpl.this.isWiresParentAccept(wiresContainer)) {
                return false;
            }
            Node parentNode = this.toNode(wiresContainer);
            return ContainmentAcceptorControlImpl.this.allow((Element)parentNode, this.toNodeArray(shapes));
        }

        public boolean acceptContainment(WiresContainer wiresContainer, WiresShape[] shapes) {
            if (!ContainmentAcceptorControlImpl.this.isWiresParentAccept(wiresContainer)) {
                return false;
            }
            Node parentNode = this.toNode(wiresContainer);
            return ContainmentAcceptorControlImpl.this.accept((Element)parentNode, this.toNodeArray(shapes));
        }

        private Node[] toNodeArray(WiresShape[] shapes) {
            ArrayList<Node> nodes = new ArrayList<Node>(shapes.length);
            for (WiresShape shape : shapes) {
                Node node = this.toNode((WiresContainer)shape);
                if (null == node) continue;
                nodes.add(node);
            }
            return nodes.toArray(new Node[nodes.size()]);
        }

        private Node toNode(WiresContainer shape) {
            return WiresUtils.getNode(ContainmentAcceptorControlImpl.this.getCanvasHandler(), shape);
        }
    };

    @Inject
    public ContainmentAcceptorControlImpl(CanvasCommandFactory<AbstractCanvasHandler> canvasCommandFactory) {
        this.canvasCommandFactory = canvasCommandFactory;
    }

    @Override
    protected void onInit(WiresCanvas.View view) {
        view.setContainmentAcceptor(this.CONTAINMENT_ACCEPTOR);
        this.canvasHighlight = new CanvasHighlight(this.getCanvasHandler());
    }

    @Override
    protected void onDestroy(WiresCanvas.View view) {
        view.setContainmentAcceptor(IContainmentAcceptor.NONE);
        this.canvasHighlight.destroy();
        this.canvasHighlight = null;
    }

    public boolean allow(Element parent, Node[] children) {
        return this.evaluate(parent, children, command -> this.getCommandManager().allow((Object)this.getCanvasHandler(), command), true);
    }

    public boolean accept(Element parent, Node[] children) {
        return this.evaluate(parent, children, command -> this.getCommandManager().execute((Object)this.getCanvasHandler(), command), false);
    }

    private boolean evaluate(Element parent, Node[] children, Function<Command<AbstractCanvasHandler, CanvasViolation>, CommandResult<CanvasViolation>> executor, boolean highlights) {
        if (children == null || children.length == 0) {
            return false;
        }
        if (parent == null && children.length >= 2) {
            return false;
        }
        CompositeCommand.Builder builder = new CompositeCommand.Builder().forward();
        for (Node node : children) {
            builder.addCommand((Command)this.canvasCommandFactory.updateChildNode((Node)parent, node));
        }
        if (builder.size() > 0) {
            CompositeCommand command = builder.size() == 1 ? builder.get(0) : builder.build();
            CommandResult<CanvasViolation> result = executor.apply((Command<AbstractCanvasHandler, CanvasViolation>)command);
            boolean success = this.isCommandSuccess(result);
            if (highlights && !success) {
                this.canvasHighlight.invalid(result.getViolations());
            } else if (highlights) {
                this.canvasHighlight.highLight(parent);
            } else {
                this.canvasHighlight.unhighLight();
            }
            return success;
        }
        return true;
    }
}

