/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.canvas.export;

import com.ait.lienzo.client.core.INativeContext2D;
import com.ait.lienzo.client.core.Path2D;
import com.ait.lienzo.client.core.types.ImageData;
import com.ait.lienzo.client.core.types.LinearGradient;
import com.ait.lienzo.client.core.types.PathPartEntryJSO;
import com.ait.lienzo.client.core.types.PathPartList;
import com.ait.lienzo.client.core.types.PatternGradient;
import com.ait.lienzo.client.core.types.RadialGradient;
import com.ait.lienzo.client.core.types.Shadow;
import com.ait.lienzo.client.core.types.TextMetrics;
import com.ait.lienzo.client.core.types.Transform;
import com.ait.tooling.nativetools.client.collection.NFastDoubleArrayJSO;
import com.google.gwt.dom.client.Element;
import elemental2.dom.HTMLCanvasElement;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.kie.workbench.common.stunner.client.lienzo.util.NativeClassConverter;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.uberfire.ext.editor.commons.client.file.exports.svg.IContext2D;

public class DelegateNativeContext2D
implements INativeContext2D {
    protected static final String DEFAULT_NODE_ID = "id";
    private final IContext2D context;
    private final Converter nativeClassConverter;
    private String svgNodeId;
    private AbstractCanvasHandler canvasHandler;

    public DelegateNativeContext2D(IContext2D context, AbstractCanvasHandler canvasHandler) {
        this(context, canvasHandler, NativeClassConverter::convert);
    }

    DelegateNativeContext2D(IContext2D context, AbstractCanvasHandler canvasHandler, Converter converter) {
        this.context = context;
        this.nativeClassConverter = converter;
        this.canvasHandler = canvasHandler;
        this.svgNodeId = this.getSvgNodeId(canvasHandler).orElse(DEFAULT_NODE_ID);
    }

    private Optional<String> getSvgNodeId(AbstractCanvasHandler canvasHandler) {
        String diagramDefinitionSetId = canvasHandler.getDiagram().getMetadata().getDefinitionSetId();
        Object diagramDefinitionSet = canvasHandler.getDefinitionManager().definitionSets().getDefinitionSetById(diagramDefinitionSetId);
        return canvasHandler.getDefinitionManager().adapters().forDefinitionSet().getSvgNodeId(diagramDefinitionSet);
    }

    public void initDeviceRatio() {
    }

    public void saveContainer(final String id) {
        this.context.saveGroup((Map)new HashMap<String, String>(){
            {
                Optional.ofNullable(DelegateNativeContext2D.this.canvasHandler.getGraphIndex().get(id)).ifPresent(node -> {
                    this.put(DelegateNativeContext2D.DEFAULT_NODE_ID, id);
                    this.put(DelegateNativeContext2D.this.svgNodeId, id);
                });
            }
        });
    }

    public void restoreContainer() {
        this.context.restoreGroup();
    }

    public void save() {
        this.context.saveStyle();
    }

    public void save(final String id) {
        this.context.saveStyle();
        this.context.addAttributes((Map)new HashMap<String, String>(){
            {
                Optional.ofNullable(id).ifPresent(node -> this.put(DelegateNativeContext2D.DEFAULT_NODE_ID, id));
            }
        });
    }

    public void restore() {
        this.context.restoreStyle();
    }

    public void beginPath() {
        this.context.beginPath();
    }

    public void closePath() {
        this.context.closePath();
    }

    public void moveTo(double x, double y) {
        this.context.moveTo(x, y);
    }

    public void lineTo(double x, double y) {
        this.context.lineTo(x, y);
    }

    public void setGlobalCompositeOperation(String operation) {
        this.context.setGlobalCompositeOperation(operation);
    }

    public void setLineCap(String lineCap) {
        this.context.setLineCap(lineCap);
    }

    public void setLineJoin(String lineJoin) {
        this.context.setLineJoin(lineJoin);
    }

    public void quadraticCurveTo(double cpx, double cpy, double x, double y) {
        this.context.quadraticCurveTo(cpx, cpy, x, y);
    }

    public void arc(double x, double y, double radius, double startAngle, double endAngle) {
        this.context.arc(x, y, radius, startAngle, endAngle);
    }

    public void arc(double x, double y, double radius, double startAngle, double endAngle, boolean antiClockwise) {
        this.context.arc(x, y, radius, startAngle, endAngle, antiClockwise);
    }

    public void ellipse(double x, double y, double rx, double ry, double ro, double sa, double ea, boolean ac) {
        this.context.ellipse(x, y, rx, ry, ro, sa, ea, ac);
    }

    public void ellipse(double x, double y, double rx, double ry, double ro, double sa, double ea) {
        this.context.ellipse(x, y, rx, ry, ro, sa, ea);
    }

    public void arcTo(double x1, double y1, double x2, double y2, double radius) {
        this.context.arcTo(x1, y1, x2, y2, radius);
    }

    public void bezierCurveTo(double cp1x, double cp1y, double cp2x, double cp2y, double x, double y) {
        this.context.bezierCurveTo(cp1x, cp1y, cp2x, cp2y, x, y);
    }

    public void clearRect(double x, double y, double w, double h) {
        this.context.clearRect(x, y, w, h);
    }

    public void clip() {
        this.context.clip();
    }

    public void fill() {
        this.context.fill();
    }

    public void stroke() {
        this.context.stroke();
    }

    public void fillRect(double x, double y, double w, double h) {
        this.context.fillRect(x, y, w, h);
    }

    public void fillText(String text, double x, double y) {
        this.context.fillText(text, x, y);
    }

    public void fillTextWithGradient(String text, double x, double y, double sx, double sy, double ex, double ey, String color) {
        this.throwException();
    }

    public void fillText(String text, double x, double y, double maxWidth) {
        this.context.fillText(text, x, y);
    }

    public void setFillColor(String fill) {
        this.context.setFillStyle(fill);
    }

    public void rect(double x, double y, double w, double h) {
        this.context.rect(x, y, w, h);
    }

    public void rotate(double angle) {
        this.context.rotate(angle);
    }

    public void scale(double sx, double sy) {
        this.context.scale(sx, sy);
    }

    public void setStrokeColor(String color) {
        this.context.setStrokeStyle(color);
    }

    public void setStrokeWidth(double width) {
        this.context.setLineWidth(width);
    }

    public void setImageSmoothingEnabled(boolean enabled) {
        this.context.setImageSmoothingEnabled(enabled);
    }

    public void setFillGradient(LinearGradient.LinearGradientJSO grad) {
        this.setFillColor(null);
    }

    public void setFillGradient(PatternGradient.PatternGradientJSO grad) {
        this.setFillColor(null);
    }

    public void setFillGradient(RadialGradient.RadialGradientJSO grad) {
        this.setFillColor(null);
    }

    public void transform(Transform.TransformJSO jso) {
        this.transform(jso.get(0), jso.get(1), jso.get(2), jso.get(3), jso.get(4), jso.get(5));
    }

    public void transform(double d0, double d1, double d2, double d3, double d4, double d5) {
        this.context.transform(d0, d1, d2, d3, d4, d5);
    }

    public void setTransform(Transform.TransformJSO jso) {
        this.setTransform(jso.get(0), jso.get(1), jso.get(2), jso.get(3), jso.get(4), jso.get(5));
    }

    public void setTransform(double d0, double d1, double d2, double d3, double d4, double d5) {
        this.context.setTransform(d0, d1, d2, d3, d4, d5);
    }

    public void setToIdentityTransform() {
        this.setTransform(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);
    }

    public void setTextFont(String font) {
        this.context.setFont(font);
    }

    public void setTextBaseline(String baseline) {
        this.context.setTextBaseline(baseline);
    }

    public void setTextAlign(String align) {
        this.context.setTextAlign(align);
    }

    public void strokeText(String text, double x, double y) {
        this.context.strokeText(text, x, y);
    }

    public void setGlobalAlpha(double alpha) {
        this.context.setGlobalAlpha(alpha);
    }

    public void translate(double x, double y) {
        this.context.translate(x, y);
    }

    public void setShadow(Shadow.ShadowJSO shadow) {
        if (Objects.nonNull(shadow)) {
            this.context.setShadowColor(shadow.getColor());
            this.context.setShadowOffsetX(shadow.getOffset().getX());
            this.context.setShadowOffsetY(shadow.getOffset().getY());
            this.context.setShadowBlur(shadow.getBlur());
        } else {
            this.context.setShadowColor("transparent");
            this.context.setShadowOffsetX(0.0);
            this.context.setShadowOffsetY(0.0);
            this.context.setShadowBlur(0);
        }
    }

    public boolean isSupported(String feature) {
        this.throwException();
        return false;
    }

    public boolean isPointInPath(double x, double y) {
        return this.context.isPointInPath(x, y);
    }

    public ImageData getImageData(double x, double y, double width, double height) {
        elemental2.dom.ImageData nativeImageData = this.context.getImageData(x, y, width, height);
        return this.nativeClassConverter.convert(nativeImageData, ImageData.class);
    }

    public ImageData createImageData(double width, double height) {
        return this.nativeClassConverter.convert(this.context.createImageData(width, height), ImageData.class);
    }

    public ImageData createImageData(ImageData data) {
        return this.nativeClassConverter.convert(this.context.createImageData(this.nativeClassConverter.convert(data, elemental2.dom.ImageData.class)), ImageData.class);
    }

    public void putImageData(ImageData image, double x, double y) {
        this.context.putImageData(this.nativeClassConverter.convert(image, elemental2.dom.ImageData.class), x, y);
    }

    public void putImageData(ImageData image, double x, double y, double dx, double dy, double dw, double dh) {
        this.context.putImageData(this.nativeClassConverter.convert(image, elemental2.dom.ImageData.class), x, y, dx, dy, dw, dh);
    }

    public TextMetrics measureText(String text) {
        return this.nativeClassConverter.convert(this.context.measureText(text), TextMetrics.class);
    }

    public void drawImage(Element image, double x, double y) {
        this.context.drawImage((elemental2.dom.Element)this.nativeClassConverter.convert(image, HTMLCanvasElement.class), x, y);
    }

    public void drawImage(Element image, double x, double y, double w, double h) {
        this.context.drawImage((elemental2.dom.Element)this.nativeClassConverter.convert(image, HTMLCanvasElement.class), x, y, w, h);
    }

    public void drawImage(Element image, double sx, double sy, double sw, double sh, double x, double y, double w, double h) {
        this.context.drawImage((elemental2.dom.Element)this.nativeClassConverter.convert(image, HTMLCanvasElement.class), sx, sy, sw, sh, x, y, w, h);
    }

    public void resetClip() {
        this.context.resetClip();
    }

    public void setMiterLimit(double limit) {
        this.context.setMiterLimit(limit);
    }

    public void setLineDash(NFastDoubleArrayJSO dashes) {
        this.context.setLineDash(dashes.toArray());
    }

    public void setLineDashOffset(double offset) {
        this.context.setLineDashOffset(offset);
    }

    public double getBackingStorePixelRatio() {
        return 1.0;
    }

    public boolean path(PathPartList.PathPartListJSO list) {
        if (list == null) {
            return false;
        }
        int leng = list.length();
        if (leng < 1) {
            return false;
        }
        int indx = 0;
        boolean fill = true;
        this.beginPath();
        while (indx < leng) {
            PathPartEntryJSO e = (PathPartEntryJSO)list.get(indx);
            ++indx;
            NFastDoubleArrayJSO p = e.getPoints();
            switch (e.getCommand()) {
                case 1: {
                    this.lineTo(p.get(0), p.get(1));
                    break;
                }
                case 2: {
                    this.moveTo(p.get(0), p.get(1));
                    break;
                }
                case 3: {
                    this.bezierCurveTo(p.get(0), p.get(1), p.get(2), p.get(3), p.get(4), p.get(5));
                    break;
                }
                case 4: {
                    this.quadraticCurveTo(p.get(0), p.get(1), p.get(2), p.get(3));
                    break;
                }
                case 5: {
                    this.ellipse(p.get(0), p.get(1), p.get(2), p.get(3), p.get(6), p.get(4), p.get(4) + p.get(5), 1.0 - p.get(7) > 0.0);
                    break;
                }
                case 6: {
                    fill = true;
                    this.closePath();
                    break;
                }
                case 7: {
                    this.arcTo(p.get(0), p.get(1), p.get(2), p.get(3), p.get(4));
                }
            }
        }
        return fill;
    }

    public boolean clip(PathPartList.PathPartListJSO list) {
        if (list == null) {
            return false;
        }
        int leng = list.length();
        if (leng < 1) {
            return false;
        }
        int indx = 0;
        boolean fill = false;
        while (indx < leng) {
            PathPartEntryJSO e = (PathPartEntryJSO)list.get(indx++);
            NFastDoubleArrayJSO p = e.getPoints();
            switch (e.getCommand()) {
                case 1: {
                    this.lineTo(p.get(0), p.get(1));
                    break;
                }
                case 2: {
                    this.moveTo(p.get(0), p.get(1));
                    break;
                }
                case 3: {
                    this.bezierCurveTo(p.get(0), p.get(1), p.get(2), p.get(3), p.get(4), p.get(5));
                    break;
                }
                case 4: {
                    this.quadraticCurveTo(p.get(0), p.get(1), p.get(2), p.get(3));
                    break;
                }
                case 5: {
                    this.ellipse(p.get(0), p.get(1), p.get(2), p.get(3), p.get(6), p.get(4), p.get(4) + p.get(5), 1.0 - p.get(7) > 0.0);
                    break;
                }
                case 6: {
                    return true;
                }
                case 7: {
                    this.arcTo(p.get(0), p.get(1), p.get(2), p.get(3), p.get(4));
                }
            }
        }
        return fill;
    }

    public void fill(Path2D.NativePath2D path) {
        this.throwException();
    }

    public void stroke(Path2D.NativePath2D path) {
        this.throwException();
    }

    public void clip(Path2D.NativePath2D path) {
        this.throwException();
    }

    public Path2D.NativePath2D getCurrentPath() {
        return this.throwException();
    }

    public void setCurrentPath(Path2D.NativePath2D path) {
        this.throwException();
    }

    private Path2D.NativePath2D throwException() {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public IContext2D getDelegate() {
        return this.context;
    }

    static interface Converter {
        public <I, O> O convert(I var1, Class<O> var2);
    }
}

