/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.components.glyph;

import com.ait.lienzo.client.core.image.ImageStrip;
import com.ait.lienzo.client.core.image.ImageStrips;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Default;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.client.session.impl.SessionInitializer;
import org.kie.workbench.common.stunner.core.client.shape.ImageStrip;
import org.kie.workbench.common.stunner.core.client.shape.ImageStripRegistry;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;
import org.uberfire.mvp.Command;

@Default
@Dependent
public class LienzoImageStripLoader
implements SessionInitializer {
    private final DefinitionUtils definitionUtils;
    private final ImageStripRegistry stripRegistry;
    private final BiConsumer<com.ait.lienzo.client.core.image.ImageStrip[], Runnable> lienzoStripRegistration;
    private final Consumer<String> lienzoStripRemoval;
    private final Set<String> registered;
    private static ImageStrips imageStrips = ImageStrips.get();

    @Inject
    public LienzoImageStripLoader(DefinitionUtils definitionUtils, ImageStripRegistry stripRegistry) {
        this(definitionUtils, stripRegistry, LienzoImageStripLoader::registerIntoLienzo, LienzoImageStripLoader::removeFromLienzo);
    }

    LienzoImageStripLoader(DefinitionUtils definitionUtils, ImageStripRegistry stripRegistry, BiConsumer<com.ait.lienzo.client.core.image.ImageStrip[], Runnable> lienzoStripRegistration, Consumer<String> lienzoStripRemoval) {
        this.definitionUtils = definitionUtils;
        this.stripRegistry = stripRegistry;
        this.lienzoStripRegistration = lienzoStripRegistration;
        this.lienzoStripRemoval = lienzoStripRemoval;
        this.registered = new HashSet<String>();
    }

    public void init(Metadata metadata, Command completeCallback) {
        Annotation qualifier = this.definitionUtils.getQualifier(metadata.getDefinitionSetId());
        ImageStrip[] strips = this.stripRegistry.get(new Annotation[]{DefinitionManager.DEFAULT_QUALIFIER, qualifier});
        this.registerStrips(strips, completeCallback);
    }

    public void destroy() {
        this.registered.forEach(this.lienzoStripRemoval::accept);
        this.registered.clear();
    }

    private void registerStrips(ImageStrip[] strips, Command callback) {
        com.ait.lienzo.client.core.image.ImageStrip[] instances = (com.ait.lienzo.client.core.image.ImageStrip[])Arrays.stream(strips).filter(strip -> !this.isRegistered((ImageStrip)strip)).map(LienzoImageStripLoader::convert).toArray(com.ait.lienzo.client.core.image.ImageStrip[]::new);
        this.lienzoStripRegistration.accept(instances, () -> {
            for (com.ait.lienzo.client.core.image.ImageStrip strip : instances) {
                this.registered.add(strip.getName());
            }
            callback.execute();
        });
    }

    private boolean isRegistered(ImageStrip strip) {
        return this.registered.contains(ImageStripRegistry.getName((ImageStrip)strip));
    }

    private static void registerIntoLienzo(com.ait.lienzo.client.core.image.ImageStrip[] instances, Runnable callback) {
        imageStrips.register(instances, callback);
    }

    protected static void removeFromLienzo(String name) {
        Optional.ofNullable(imageStrips.get(name)).ifPresent(imageStrip -> imageStrips.remove(name));
    }

    private static com.ait.lienzo.client.core.image.ImageStrip convert(ImageStrip strip) {
        return new com.ait.lienzo.client.core.image.ImageStrip(ImageStripRegistry.getName((ImageStrip)strip), strip.getImage().getSafeUri().asString(), strip.getWide(), strip.getHigh(), strip.getPadding(), LienzoImageStripLoader.convert(strip.getOrientation()));
    }

    private static ImageStrip.Orientation convert(ImageStrip.Orientation orientation) {
        return ImageStrip.Orientation.HORIZONTAL.equals((Object)orientation) ? ImageStrip.Orientation.HORIZONTAL : ImageStrip.Orientation.VERTICAL;
    }

    protected static void setImageStrips(ImageStrips imageStrips) {
        LienzoImageStripLoader.imageStrips = imageStrips;
    }

    Set<String> getRegistered() {
        return this.registered;
    }
}

