/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.components.glyph;

import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.shape.Layer;
import com.ait.lienzo.client.widget.LienzoPanel;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.dom.client.MouseMoveEvent;
import com.google.gwt.event.dom.client.MouseMoveHandler;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.event.dom.client.MouseUpHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.client.lienzo.components.glyph.LienzoGlyphRenderer;
import org.kie.workbench.common.stunner.client.lienzo.components.glyph.LienzoGlyphRenderers;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.components.drag.DragProxy;
import org.kie.workbench.common.stunner.core.client.components.drag.DragProxyCallback;
import org.kie.workbench.common.stunner.core.client.components.glyph.ShapeGlyphDragHandler;
import org.kie.workbench.common.stunner.core.definition.shape.Glyph;

@Dependent
public class ShapeGlyphDragHandlerImpl
implements ShapeGlyphDragHandler<AbstractCanvas> {
    private static final int ZINDEX = Integer.MAX_VALUE;
    private final LienzoGlyphRenderer<Glyph> glyphLienzoGlyphRenderer;
    final List<HandlerRegistration> handlerRegistrations = new ArrayList<HandlerRegistration>();
    LienzoPanel dragProxyPanel;

    @Inject
    public ShapeGlyphDragHandlerImpl(LienzoGlyphRenderers glyphLienzoGlyphRenderer) {
        this.glyphLienzoGlyphRenderer = glyphLienzoGlyphRenderer;
    }

    public DragProxy<AbstractCanvas, ShapeGlyphDragHandler.Item, DragProxyCallback> proxyFor(AbstractCanvas context) {
        return this;
    }

    public DragProxy<AbstractCanvas, ShapeGlyphDragHandler.Item, DragProxyCallback> show(ShapeGlyphDragHandler.Item item, int x, int y, DragProxyCallback dragProxyCallback) {
        int width = item.getWidth();
        int height = item.getHeight();
        Group dragShape = (Group)this.glyphLienzoGlyphRenderer.render(item.getShape(), width, height);
        dragShape.setX(0.0);
        dragShape.setY(0.0);
        this.dragProxyPanel = new LienzoPanel(width * 2, height * 2);
        this.dragProxyPanel.getElement().getStyle().setCursor(Style.Cursor.AUTO);
        Layer dragProxyLayer = new Layer();
        dragProxyLayer.add((IPrimitive)dragShape);
        this.dragProxyPanel.add(dragProxyLayer);
        this.setDragProxyPosition(this.dragProxyPanel, width, height, x, y);
        this.attachDragProxyHandlers(this.dragProxyPanel, dragProxyCallback);
        this.addKeyboardEscHandler();
        RootPanel.get().add((Widget)this.dragProxyPanel);
        return this;
    }

    public void clear() {
        if (Objects.nonNull(this.dragProxyPanel)) {
            this.clearHandlers();
            this.dragProxyPanel.clear();
            RootPanel.get().remove((Widget)this.dragProxyPanel);
            this.dragProxyPanel = null;
        }
    }

    public void destroy() {
        this.clearHandlers();
        if (Objects.nonNull(this.dragProxyPanel)) {
            RootPanel.get().remove((Widget)this.dragProxyPanel);
            this.dragProxyPanel.destroy();
            this.dragProxyPanel = null;
        }
    }

    private void setDragProxyPosition(LienzoPanel dragProxyPanel, double proxyWidth, double proxyHeight, double x, double y) {
        Style style = dragProxyPanel.getElement().getStyle();
        style.setPosition(Style.Position.ABSOLUTE);
        style.setLeft(x, Style.Unit.PX);
        style.setTop(y, Style.Unit.PX);
        style.setZIndex(Integer.MAX_VALUE);
    }

    private void attachDragProxyHandlers(final LienzoPanel floatingPanel, final DragProxyCallback callback) {
        Style style = floatingPanel.getElement().getStyle();
        this.addMouseMoveEvents(floatingPanel, callback, style);
        new Timer(){

            public void run() {
                ShapeGlyphDragHandlerImpl.this.addMouseUpEvent(floatingPanel, callback);
                this.cancel();
            }
        }.schedule(200);
    }

    private void addMouseMoveEvents(LienzoPanel floatingPanel, DragProxyCallback callback, Style style) {
        this.handlerRegistrations.add(RootPanel.get().addDomHandler((EventHandler)((MouseMoveHandler)mouseMoveEvent -> {
            style.setLeft((double)mouseMoveEvent.getX(), Style.Unit.PX);
            style.setTop((double)mouseMoveEvent.getY(), Style.Unit.PX);
            int x = mouseMoveEvent.getX();
            int y = mouseMoveEvent.getY();
            callback.onMove(x, y);
        }), MouseMoveEvent.getType()));
    }

    private void addMouseUpEvent(LienzoPanel floatingPanel, DragProxyCallback callback) {
        this.handlerRegistrations.add(RootPanel.get().addDomHandler((EventHandler)((MouseUpHandler)mouseUpEvent -> {
            this.clearHandlers();
            RootPanel.get().remove((Widget)floatingPanel);
            int x = mouseUpEvent.getX();
            int y = mouseUpEvent.getY();
            callback.onComplete(x, y);
        }), MouseUpEvent.getType()));
    }

    private void addKeyboardEscHandler() {
        this.handlerRegistrations.add(RootPanel.get().addDomHandler((EventHandler)((KeyDownHandler)k -> this.clear()), KeyDownEvent.getType()));
    }

    private void clearHandlers() {
        this.handlerRegistrations.stream().forEach(com.google.web.bindery.event.shared.HandlerRegistration::removeHandler);
        this.handlerRegistrations.clear();
    }
}

