/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.components.toolbox.actions;

import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.client.core.shape.Layer;
import com.ait.lienzo.client.core.shape.Text;
import com.ait.lienzo.client.core.shape.wires.WiresShape;
import java.util.function.Consumer;
import org.kie.workbench.common.stunner.client.lienzo.canvas.wires.WiresCanvas;
import org.kie.workbench.common.stunner.client.lienzo.components.glyph.LienzoGlyphRenderers;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.ActionsToolbox;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.ActionsToolboxView;
import org.kie.workbench.common.stunner.core.client.shape.view.event.MouseClickEvent;
import org.kie.workbench.common.stunner.core.definition.shape.Glyph;
import org.kie.workbench.common.stunner.lienzo.toolbox.items.ButtonItem;
import org.kie.workbench.common.stunner.lienzo.toolbox.items.DecoratedItem;
import org.kie.workbench.common.stunner.lienzo.toolbox.items.DecoratorItem;
import org.kie.workbench.common.stunner.lienzo.toolbox.items.TooltipItem;
import org.kie.workbench.common.stunner.lienzo.toolbox.items.impl.ToolboxFactory;
import org.kie.workbench.common.stunner.lienzo.toolbox.items.impl.WiresShapeToolbox;
import org.kie.workbench.common.stunner.lienzo.toolbox.items.tooltip.ToolboxTextTooltip;

public abstract class AbstractActionsToolboxView<V extends AbstractActionsToolboxView>
implements ActionsToolboxView<V> {
    public static final double BUTTON_SIZE = 15.0;
    public static final double BUTTON_PADDING = 5.0;
    private final LienzoGlyphRenderers glyphRenderers;
    private final ToolboxFactory toolboxFactory;
    private WiresShapeToolbox toolboxView;
    private ToolboxTextTooltip tooltip;
    private WiresCanvas canvas;

    public AbstractActionsToolboxView(LienzoGlyphRenderers glyphRenderers, ToolboxFactory toolboxFactory) {
        this.glyphRenderers = glyphRenderers;
        this.toolboxFactory = toolboxFactory;
    }

    protected abstract void configure(ActionsToolbox var1);

    protected abstract ToolboxTextTooltip createTooltip(ActionsToolbox var1);

    protected abstract double getGlyphSize();

    public V init(ActionsToolbox toolbox) {
        return this.init(toolbox, (WiresCanvas)toolbox.getCanvas(), (WiresShape)toolbox.getShape().getShapeView());
    }

    public V addButton(Glyph glyph, String title, Consumer<MouseClickEvent> clickEventConsumer) {
        ButtonItem button = (ButtonItem)((ButtonItem)((ButtonItem)((ButtonItem)((ButtonItem)this.toolboxFactory.buttons().button(this.renderGlyph(glyph, this.getGlyphSize())).decorate(this.createDecorator())).tooltip((TooltipItem)this.tooltip.createItem(title))).onMouseEnter(event -> this.onMouseEnter())).onMouseExit(event -> this.onMouseExit())).onClick(event -> clickEventConsumer.accept(new MouseClickEvent((double)event.getX(), (double)event.getY(), (double)event.getMouseEvent().getClientX(), (double)event.getMouseEvent().getClientY())));
        this.addButton(button);
        return this.cast();
    }

    public V show() {
        this.toolboxView.show();
        return this.cast();
    }

    public V hide() {
        this.toolboxView.hide();
        return this.cast();
    }

    public void destroy() {
        this.toolboxView.destroy();
        if (null != this.tooltip) {
            this.tooltip.destroy();
            this.tooltip = null;
        }
        this.toolboxView = null;
        this.canvas = null;
    }

    protected V init(ActionsToolbox toolbox, WiresCanvas canvas, WiresShape shape) {
        this.canvas = canvas;
        Layer topLayer = ((WiresCanvas.View)canvas.getView()).getTopLayer();
        this.toolboxView = this.toolboxFactory.forWiresShape(shape).attachTo(topLayer);
        this.configure(toolbox);
        this.tooltip = this.createTooltip(toolbox);
        return this.cast();
    }

    protected void addButton(ButtonItem buttonItem) {
        this.toolboxView.add(new DecoratedItem[]{buttonItem});
    }

    protected Group renderGlyph(Glyph glyph, double size) {
        return this.glyphRenderers.render(glyph, size, size);
    }

    protected DecoratorItem<?> createDecorator() {
        return this.getToolboxFactory().decorators().box();
    }

    protected Consumer<Text> defaultTextConsumer() {
        return text -> text.setFontSize(10.0).setFontFamily("Verdana");
    }

    protected WiresShapeToolbox getToolboxView() {
        return this.toolboxView;
    }

    protected void onMouseEnter() {
        if (null != this.canvas) {
            ((WiresCanvas.View)this.canvas.getView()).setCursor(AbstractCanvas.Cursors.POINTER);
        }
    }

    protected void onMouseExit() {
        if (null != this.canvas) {
            ((WiresCanvas.View)this.canvas.getView()).setCursor(AbstractCanvas.Cursors.AUTO);
        }
    }

    protected ToolboxFactory getToolboxFactory() {
        return this.toolboxFactory;
    }

    private V cast() {
        return (V)this;
    }
}

