/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.canvas;

import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.shape.Layer;
import com.ait.lienzo.client.core.shape.Node;
import com.ait.lienzo.client.core.shape.Shape;
import com.ait.lienzo.client.core.shape.Viewport;
import com.ait.lienzo.client.core.shape.wires.WiresConnector;
import com.ait.lienzo.client.core.shape.wires.WiresContainer;
import com.ait.lienzo.client.core.types.Transform;
import com.ait.lienzo.shared.core.types.DataURLType;
import javax.enterprise.context.Dependent;
import org.kie.workbench.common.stunner.client.lienzo.Lienzo;
import org.kie.workbench.common.stunner.client.lienzo.canvas.wires.WiresUtils;
import org.kie.workbench.common.stunner.client.lienzo.shape.view.ViewEventHandlerManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractLayer;
import org.kie.workbench.common.stunner.core.client.canvas.Layer;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeView;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewEvent;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewEventType;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewHandler;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;
import org.uberfire.mvp.Command;

@Dependent
@Lienzo
public class LienzoLayer
extends AbstractLayer<LienzoLayer, ShapeView<?>, Shape<?>> {
    private static final ViewEventType[] SUPPORTED_EVENT_TYPES = new ViewEventType[]{ViewEventType.MOUSE_CLICK, ViewEventType.MOUSE_DBL_CLICK, ViewEventType.MOUSE_MOVE};
    protected ViewEventHandlerManager eventHandlerManager;
    protected Layer layer;

    public LienzoLayer initialize(Object view) {
        this.layer = (Layer)view;
        this.eventHandlerManager = new ViewEventHandlerManager((Node<?>)this.layer, SUPPORTED_EVENT_TYPES);
        return this;
    }

    public LienzoLayer addShape(ShapeView<?> shape) {
        if (WiresUtils.isWiresContainer(shape)) {
            this.layer.add((IPrimitive)((WiresContainer)shape).getGroup());
        } else if (WiresUtils.isWiresConnector(shape)) {
            this.layer.add((IPrimitive)((WiresConnector)shape).getLine());
        } else {
            this.layer.add((IPrimitive)shape);
        }
        return this;
    }

    public LienzoLayer removeShape(ShapeView<?> shape) {
        if (WiresUtils.isWiresContainer(shape)) {
            this.layer.remove((IPrimitive)((WiresContainer)shape).getGroup());
        } else if (WiresUtils.isWiresConnector(shape)) {
            this.layer.remove((IPrimitive)((WiresConnector)shape).getLine());
        } else {
            this.layer.remove((IPrimitive)shape);
        }
        return this;
    }

    public void clear() {
        this.layer.clear();
    }

    public String toDataURL() {
        return this.layer.toDataURL(DataURLType.PNG);
    }

    public String toDataURL(Layer.URLDataType type) {
        switch (type) {
            case JPG: {
                return this.layer.toDataURL(DataURLType.JPG);
            }
        }
        return this.layer.toDataURL(DataURLType.PNG);
    }

    public void onAfterDraw(Command callback) {
        this.layer.setOnLayerAfterDraw(layer1 -> callback.execute());
    }

    public void destroy() {
        if (null != this.eventHandlerManager) {
            this.eventHandlerManager.destroy();
            this.eventHandlerManager = null;
        }
        if (null != this.layer) {
            this.layer.removeAll();
            this.layer.removeFromParent();
            this.layer = null;
        }
    }

    public boolean supports(ViewEventType type) {
        return this.eventHandlerManager.supports(type);
    }

    public LienzoLayer addHandler(ViewEventType type, ViewHandler<? extends ViewEvent> eventHandler) {
        this.eventHandlerManager.addHandler(type, eventHandler);
        return this;
    }

    public LienzoLayer removeHandler(ViewHandler<? extends ViewEvent> eventHandler) {
        this.eventHandlerManager.removeHandler(eventHandler);
        return this;
    }

    public LienzoLayer enableHandlers() {
        this.eventHandlerManager.enable();
        return this;
    }

    public LienzoLayer disableHandlers() {
        this.eventHandlerManager.disable();
        return this;
    }

    public Shape<?> getAttachableShape() {
        return null;
    }

    public Layer getLienzoLayer() {
        return this.layer;
    }

    protected Point2D getTranslate() {
        return new Point2D(this.layer.getAbsoluteTransform().getTranslateX(), this.layer.getAbsoluteTransform().getTranslateY());
    }

    protected Point2D getScale() {
        return new Point2D(this.layer.getAbsoluteTransform().getScaleX(), this.layer.getAbsoluteTransform().getScaleY());
    }

    public void translate(double tx, double ty) {
        this.setTransform(t -> this.translate(t, tx, ty));
    }

    public void scale(double sx, double sy) {
        this.setTransform(t -> this.scale(t, sx, sy));
    }

    public void scale(double delta) {
        this.setTransform(t -> this.scale(t, delta));
    }

    private void setTransform(TransformCallback callback) {
        Transform transform = this.getViewPort().getTransform();
        if (transform == null) {
            transform = new Transform();
            this.getViewPort().setTransform(transform);
        }
        callback.apply(transform);
        this.getViewPort().setTransform(transform);
    }

    private void scale(Transform transform, double sx, double sy) {
        transform.scale(sx, sy);
        this.getViewPort().batch();
    }

    private void scale(Transform transform, double delta) {
        transform.scale(delta);
    }

    private void translate(Transform transform, double tx, double ty) {
        transform.translate(tx, ty);
    }

    private Viewport getViewPort() {
        return this.layer.getViewport();
    }

    private static interface TransformCallback {
        public void apply(Transform var1);
    }
}

