/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.canvas.controls;

import com.ait.lienzo.client.core.shape.wires.WiresContainer;
import com.ait.lienzo.client.core.shape.wires.WiresShape;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.kie.workbench.common.stunner.client.lienzo.canvas.wires.WiresCanvas;
import org.kie.workbench.common.stunner.client.lienzo.canvas.wires.WiresUtils;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.CanvasControl;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandManager;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.client.command.RequiresCommandManager;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.util.CommandUtils;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;

public abstract class AbstractAcceptorControl
implements CanvasControl<AbstractCanvasHandler>,
RequiresCommandManager<AbstractCanvasHandler> {
    private AbstractCanvasHandler canvasHandler;
    private RequiresCommandManager.CommandManagerProvider<AbstractCanvasHandler> commandManagerProvider;

    protected abstract void onInit(WiresCanvas.View var1);

    protected abstract void onDestroy(WiresCanvas.View var1);

    public void init(AbstractCanvasHandler canvasHandler) {
        this.canvasHandler = canvasHandler;
        WiresCanvas.View canvasView = (WiresCanvas.View)canvasHandler.getAbstractCanvas().getView();
        this.onInit(canvasView);
    }

    public void destroy() {
        if (null != this.canvasHandler && null != this.canvasHandler.getCanvas()) {
            WiresCanvas.View canvasView = (WiresCanvas.View)this.canvasHandler.getAbstractCanvas().getView();
            this.onDestroy(canvasView);
        }
        this.canvasHandler = null;
        this.commandManagerProvider = null;
    }

    public void setCommandManagerProvider(RequiresCommandManager.CommandManagerProvider<AbstractCanvasHandler> provider) {
        this.commandManagerProvider = provider;
    }

    protected AbstractCanvasHandler getCanvasHandler() {
        return this.canvasHandler;
    }

    protected CanvasCommandManager<AbstractCanvasHandler> getCommandManager() {
        return this.commandManagerProvider.getCommandManager();
    }

    protected Optional<Edge<?, Node>> getFirstIncomingEdge(Node child, Predicate<Edge> predicate) {
        return this.getAnyEdge(child.getInEdges(), predicate);
    }

    protected Optional<Edge<?, Node>> getFirstOutgoingEdge(Node child, Predicate<Edge> predicate) {
        return this.getAnyEdge(child.getOutEdges(), predicate);
    }

    protected boolean isCommandSuccess(CommandResult<CanvasViolation> result) {
        return !CommandUtils.isError(result);
    }

    protected boolean isWiresParentAccept(WiresContainer wiresContainer) {
        return WiresUtils.isWiresShape(wiresContainer);
    }

    protected boolean isWiresViewAccept(WiresContainer wiresContainer, WiresShape wiresShape) {
        return WiresUtils.isWiresShape(wiresContainer) || WiresUtils.isWiresShape((WiresContainer)wiresShape);
    }

    protected Optional<Edge<?, Node>> getAnyEdge(List<Edge<?, Node>> edges, Predicate<Edge> predicate) {
        if (null != edges) {
            return edges.stream().filter(predicate).findAny();
        }
        return Optional.empty();
    }
}

