/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.canvas.controls;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Logger;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Default;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.select.AbstractSelectionControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.select.MapSelectionControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.select.SingleSelection;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasClearSelectionEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasSelectionEvent;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.view.HasEventHandlers;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeView;
import org.kie.workbench.common.stunner.core.client.shape.view.event.MouseClickEvent;
import org.kie.workbench.common.stunner.core.client.shape.view.event.MouseClickHandler;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewEventType;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewHandler;
import org.kie.workbench.common.stunner.core.graph.Element;

@Dependent
@SingleSelection
@Default
public final class LienzoSelectionControl<H extends AbstractCanvasHandler>
extends AbstractSelectionControl<H> {
    private static Logger LOGGER = Logger.getLogger(LienzoSelectionControl.class.getName());
    private final Map<String, ViewHandler<?>> handlers = new HashMap();

    @Inject
    public LienzoSelectionControl(Event<CanvasSelectionEvent> canvasSelectionEvent, Event<CanvasClearSelectionEvent> clearSelectionEvent) {
        super(canvasSelectionEvent, clearSelectionEvent);
    }

    LienzoSelectionControl(MapSelectionControl<H> selectionControl, Event<CanvasSelectionEvent> canvasSelectionEvent, Event<CanvasClearSelectionEvent> clearSelectionEvent) {
        super(selectionControl, canvasSelectionEvent, clearSelectionEvent);
    }

    protected void onRegister(final Element element) {
        HasEventHandlers hasEventHandlers;
        ShapeView shapeView;
        super.onRegister(element);
        Shape shape = this.getSelectionControl().getCanvas().getShape(element.getUUID());
        if (null != shape && (shapeView = shape.getShapeView()) instanceof HasEventHandlers && (hasEventHandlers = (HasEventHandlers)shapeView).supports(ViewEventType.MOUSE_CLICK)) {
            MouseClickHandler clickHandler = new MouseClickHandler(){

                public void handle(MouseClickEvent event) {
                    if (event.isButtonLeft() || event.isButtonRight()) {
                        LienzoSelectionControl.this.singleSelect(element);
                    }
                }
            };
            hasEventHandlers.addHandler(ViewEventType.MOUSE_CLICK, (ViewHandler)clickHandler);
            this.registerHandler(shape.getUUID(), (ViewHandler<?>)clickHandler);
        }
    }

    void singleSelect(Element element) {
        if (!this.getSelectedItems().isEmpty()) {
            this.clearSelection();
        }
        this.select(element.getUUID());
    }

    protected void onDeregister(Element element) {
        super.onDeregister(element);
        this.deregister(element.getUUID());
    }

    protected void onDestroy() {
        super.onDestroy();
        new HashSet<String>(this.handlers.keySet()).forEach(this::deregister);
        this.handlers.clear();
    }

    private void registerHandler(String uuid, ViewHandler<?> handler) {
        this.handlers.put(uuid, handler);
    }

    protected void deregister(String uuid) {
        Shape shape = this.getSelectionControl().getCanvas().getShape(uuid);
        ViewHandler<?> handler = this.handlers.get(uuid);
        this.doDeregisterHandler(shape, handler);
    }

    private void doDeregisterHandler(Shape shape, ViewHandler<?> handler) {
        if (null != shape && null != handler) {
            HasEventHandlers hasEventHandlers = (HasEventHandlers)shape.getShapeView();
            hasEventHandlers.removeHandler(handler);
            this.handlers.remove(shape.getUUID());
        }
    }

    Map<String, ViewHandler<?>> getHandlers() {
        return this.handlers;
    }
}

