/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.canvas.export;

import com.ait.lienzo.client.core.Context2D;
import com.ait.lienzo.client.core.INativeContext2D;
import com.ait.lienzo.client.core.shape.Layer;
import com.ait.lienzo.client.core.types.BoundingBox;
import com.ait.lienzo.client.core.util.ScratchPad;
import com.ait.lienzo.shared.core.types.DataURLType;
import javax.enterprise.context.ApplicationScoped;
import org.kie.workbench.common.stunner.client.lienzo.canvas.LienzoLayer;
import org.kie.workbench.common.stunner.client.lienzo.canvas.export.DelegateNativeContext2D;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasExport;
import org.kie.workbench.common.stunner.core.client.canvas.Layer;
import org.uberfire.ext.editor.commons.client.file.exports.svg.Context2DFactory;
import org.uberfire.ext.editor.commons.client.file.exports.svg.IContext2D;
import org.uberfire.ext.editor.commons.client.file.exports.svg.SvgExportSettings;

@ApplicationScoped
public class LienzoCanvasExport
implements CanvasExport<AbstractCanvasHandler> {
    public static final String BG_COLOR = "#FFFFFF";

    public String toImageData(AbstractCanvasHandler canvasHandler, Layer.URLDataType urlDataType) {
        LienzoLayer layer = LienzoCanvasExport.getLayer(canvasHandler);
        Layer lienzoLayer = layer.getLienzoLayer();
        return LienzoCanvasExport.layerToDataURL(lienzoLayer, LienzoCanvasExport.getDataType(urlDataType), 0, 0, lienzoLayer.getWidth(), lienzoLayer.getHeight(), BG_COLOR);
    }

    public String toImageData(AbstractCanvasHandler canvasHandler, Layer.URLDataType urlDataType, int x, int y, int width, int height) {
        LienzoLayer layer = LienzoCanvasExport.getLayer(canvasHandler);
        Layer lienzoLayer = layer.getLienzoLayer();
        return LienzoCanvasExport.layerToDataURL(lienzoLayer, LienzoCanvasExport.getDataType(urlDataType), x, y, width, height, BG_COLOR);
    }

    public IContext2D toContext2D(AbstractCanvasHandler canvasHandler) {
        Layer layer = LienzoCanvasExport.getLayer(canvasHandler).getLienzoLayer();
        IContext2D svgContext2D = Context2DFactory.create((SvgExportSettings)new SvgExportSettings((double)layer.getWidth(), (double)layer.getHeight(), (Object)layer.getContext()));
        layer.draw();
        layer.draw(new Context2D((INativeContext2D)new DelegateNativeContext2D(svgContext2D, canvasHandler)));
        layer.draw();
        return svgContext2D;
    }

    private static String layerToDataURL(Layer layer, DataURLType dataURLType, int x, int y, int width, int height, String bgColor) {
        ScratchPad scratchPad = layer.getScratchPad();
        if (null != bgColor) {
            scratchPad.getContext().setFillColor(bgColor);
            scratchPad.getContext().fillRect((double)x, (double)y, (double)width, (double)height);
        }
        layer.drawWithTransforms(scratchPad.getContext(), 1.0, new BoundingBox((double)x, (double)y, (double)width, (double)height));
        String data = scratchPad.toDataURL(dataURLType, 1.0);
        scratchPad.clear();
        return data;
    }

    private static DataURLType getDataType(Layer.URLDataType type) {
        switch (type) {
            case JPG: {
                return DataURLType.JPG;
            }
            case PNG: {
                return DataURLType.PNG;
            }
        }
        throw new UnsupportedOperationException("Export data type [" + type.name() + "] not supported ");
    }

    private static LienzoLayer getLayer(AbstractCanvasHandler canvasHandler) {
        return (LienzoLayer)canvasHandler.getCanvas().getLayer();
    }
}

