/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.components.drag;

import com.ait.lienzo.client.core.shape.wires.SelectionManager;
import com.ait.lienzo.client.core.types.BoundingBox;
import java.util.Optional;
import org.kie.workbench.common.stunner.core.client.shape.view.HasDragBounds;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeView;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.definition.DefinitionSet;

public class DragBoundsEnforcer {
    private final Optional<ShapeView> shape;
    private final Optional<SelectionManager> selectionManager;
    private double[] bounds;
    private int margin = 0;

    private DragBoundsEnforcer(ShapeView shape, SelectionManager selectionManager) {
        this.selectionManager = Optional.ofNullable(selectionManager);
        this.shape = Optional.ofNullable(shape);
    }

    public static DragBoundsEnforcer forShape(ShapeView shape) {
        return new DragBoundsEnforcer(shape, null);
    }

    public static DragBoundsEnforcer forSelectionManager(SelectionManager selectionManager) {
        return new DragBoundsEnforcer(null, selectionManager);
    }

    public DragBoundsEnforcer withMargin(int margin) {
        this.margin = margin;
        return this;
    }

    public void enforce(Bounds bounds) {
        this.bounds = this.parseBounds(bounds);
        this.enforce();
    }

    public void enforce(Graph<DefinitionSet, ? extends Node> graph) {
        this.bounds = this.parseBounds(((DefinitionSet)graph.getContent()).getBounds());
        this.enforce();
    }

    private void enforce() {
        this.selectionManager.map(SelectionManager::getControl).ifPresent(control -> control.setBoundsConstraint(new BoundingBox(this.bounds[0], this.bounds[1], this.bounds[2], this.bounds[3])));
        this.shape.filter(s -> s instanceof HasDragBounds).map(s -> (HasDragBounds)s).ifPresent(s -> s.setDragBounds(this.bounds[0], this.bounds[1], this.bounds[2], this.bounds[3]));
    }

    private double[] parseBounds(Bounds bounds) {
        return new double[]{bounds.getUpperLeft().getX() + (double)this.margin, bounds.getUpperLeft().getY() + (double)this.margin, bounds.getLowerRight().getX() + (double)this.margin, bounds.getLowerRight().getY() + (double)this.margin};
    }
}

