/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.components.toolbox.actions;

import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.client.core.shape.MultiPath;
import com.ait.lienzo.shared.core.types.ColorName;
import com.ait.lienzo.shared.core.types.Direction;
import com.ait.lienzo.shared.core.types.IColor;
import java.util.function.BiConsumer;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.client.lienzo.components.glyph.LienzoGlyphRenderers;
import org.kie.workbench.common.stunner.client.lienzo.components.toolbox.actions.AbstractActionsToolboxView;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.ActionsToolbox;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.MorphActionsToolbox;
import org.kie.workbench.common.stunner.core.client.resources.StunnerCommonIconsGlyphFactory;
import org.kie.workbench.common.stunner.core.definition.shape.Glyph;
import org.kie.workbench.common.stunner.lienzo.toolbox.Grid;
import org.kie.workbench.common.stunner.lienzo.toolbox.Item;
import org.kie.workbench.common.stunner.lienzo.toolbox.ToolboxVisibilityExecutors;
import org.kie.workbench.common.stunner.lienzo.toolbox.grid.FixedLayoutGrid;
import org.kie.workbench.common.stunner.lienzo.toolbox.grid.Point2DGrid;
import org.kie.workbench.common.stunner.lienzo.toolbox.items.ButtonGridItem;
import org.kie.workbench.common.stunner.lienzo.toolbox.items.ButtonItem;
import org.kie.workbench.common.stunner.lienzo.toolbox.items.DecoratedItem;
import org.kie.workbench.common.stunner.lienzo.toolbox.items.DecoratorItem;
import org.kie.workbench.common.stunner.lienzo.toolbox.items.LayerToolbox;
import org.kie.workbench.common.stunner.lienzo.toolbox.items.impl.ToolboxFactory;
import org.kie.workbench.common.stunner.lienzo.toolbox.items.tooltip.ToolboxTextTooltip;

@Dependent
@MorphActionsToolbox
public class MorphActionsToolboxView
extends AbstractActionsToolboxView<MorphActionsToolboxView> {
    static final double GRID_BUTTON_SIZE = 15.0;
    static final double GRID_BUTTON_PADDING = 5.0;
    static final double GRID_DECORATOR_PADDING = 10.0;
    static final Direction TOOLBOX_AT = Direction.SOUTH_WEST;
    static final Direction ITEMS_GRID_TOWARDS = Direction.SOUTH_EAST;
    static final Direction TOOLTIP_AT = Direction.SOUTH;
    static final Direction TOOLTIP_TOWARDS = Direction.SOUTH;
    private ButtonGridItem gridItem;

    @Inject
    public MorphActionsToolboxView(LienzoGlyphRenderers glyphRenderers) {
        this(glyphRenderers, ToolboxFactory.INSTANCE);
    }

    MorphActionsToolboxView(LienzoGlyphRenderers glyphRenderers, ToolboxFactory toolboxFactory) {
        super(glyphRenderers, toolboxFactory);
    }

    @Override
    protected void configure(ActionsToolbox toolbox) {
        this.configureToolbox(toolbox);
        this.configureDropDown(toolbox);
    }

    @Override
    protected void addButton(ButtonItem buttonItem) {
        this.gridItem.add((Item[])new DecoratedItem[]{buttonItem});
    }

    @Override
    protected ToolboxTextTooltip createTooltip(ActionsToolbox toolbox) {
        return this.getToolboxFactory().tooltips().forToolbox((LayerToolbox)this.getToolboxView()).at(TOOLTIP_AT).towards(TOOLTIP_TOWARDS).withText(this.defaultTextConsumer());
    }

    @Override
    protected double getGlyphSize() {
        return 15.0;
    }

    private void configureToolbox(ActionsToolbox toolbox) {
        this.getToolboxView().at(TOOLBOX_AT).grid(this.createFixedGrid(15.0, 5.0, 1)).useShowExecutor((BiConsumer)ToolboxVisibilityExecutors.upScaleY()).useHideExecutor((BiConsumer)ToolboxVisibilityExecutors.downScaleY());
    }

    private void configureDropDown(ActionsToolbox toolbox) {
        Point2DGrid grid = this.createFixedGrid(15.0, 5.0, toolbox.size());
        Group glyphView = this.renderGlyph((Glyph)StunnerCommonIconsGlyphFactory.GEARS, 15.0);
        this.gridItem = ((ButtonGridItem)((ButtonGridItem)this.getToolboxFactory().buttons().dropRight(glyphView).grid((Grid)grid)).decorate((DecoratorItem)this.getToolboxFactory().decorators().button().setPadding(5.0).configure(path -> {
            MultiPath cfr_ignored_0 = (MultiPath)path.setFillColor((IColor)ColorName.LIGHTGREY);
        }))).decorateGrid((DecoratorItem)this.getToolboxFactory().decorators().button().setPadding(10.0).configure(path -> {
            MultiPath cfr_ignored_0 = (MultiPath)path.setFillColor("#e6e6e6");
        }));
        this.getToolboxView().add(new DecoratedItem[]{this.gridItem});
    }

    private Point2DGrid createFixedGrid(double buttonSize, double padding, int cols) {
        return new FixedLayoutGrid(padding, buttonSize, ITEMS_GRID_TOWARDS, 1, cols);
    }
}

