/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.shape.view.wires;

import com.ait.lienzo.client.core.shape.AbstractDirectionalMultiPointShape;
import com.ait.lienzo.client.core.shape.MultiPathDecorator;
import com.ait.lienzo.client.core.shape.Shape;
import com.ait.lienzo.client.core.shape.wires.IControlHandle;
import com.ait.lienzo.client.core.shape.wires.MagnetManager;
import com.ait.lienzo.client.core.shape.wires.WiresConnection;
import com.ait.lienzo.client.core.shape.wires.WiresConnector;
import com.ait.lienzo.client.core.shape.wires.WiresMagnet;
import com.ait.lienzo.client.core.shape.wires.WiresShape;
import com.ait.lienzo.client.core.types.DragBounds;
import com.ait.lienzo.client.core.types.Shadow;
import com.ait.lienzo.shared.core.types.ColorName;
import com.ait.lienzo.shared.core.types.IColor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.kie.workbench.common.stunner.client.lienzo.canvas.wires.WiresUtils;
import org.kie.workbench.common.stunner.client.lienzo.shape.view.LienzoShapeView;
import org.kie.workbench.common.stunner.core.client.shape.view.BoundingBox;
import org.kie.workbench.common.stunner.core.client.shape.view.HasControlPoints;
import org.kie.workbench.common.stunner.core.client.shape.view.HasDragBounds;
import org.kie.workbench.common.stunner.core.client.shape.view.HasManageableControlPoints;
import org.kie.workbench.common.stunner.core.client.shape.view.IsConnector;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeView;
import org.kie.workbench.common.stunner.core.client.util.ShapeUtils;
import org.kie.workbench.common.stunner.core.graph.content.view.Connection;
import org.kie.workbench.common.stunner.core.graph.content.view.ControlPoint;
import org.kie.workbench.common.stunner.core.graph.content.view.DiscreteConnection;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;
import org.kie.workbench.common.stunner.core.util.Counter;

public class WiresConnectorView<T>
extends WiresConnector
implements LienzoShapeView<T>,
IsConnector<T>,
HasManageableControlPoints<T>,
HasDragBounds<T> {
    protected String uuid;

    public WiresConnectorView(AbstractDirectionalMultiPointShape<?> line, MultiPathDecorator headDecorator, MultiPathDecorator tailDecorator) {
        super(line, headDecorator, tailDecorator);
        this.init();
    }

    public WiresConnectorView(WiresMagnet headMagnet, WiresMagnet tailMagnet, AbstractDirectionalMultiPointShape<?> line, MultiPathDecorator headDecorator, MultiPathDecorator tailDecorator) {
        super(headMagnet, tailMagnet, line, headDecorator, tailDecorator);
        this.init();
    }

    private void init() {
        this.getLine().asShape().setFillColor((IColor)ColorName.WHITE).setStrokeWidth(0.0);
    }

    public T setUUID(String uuid) {
        this.uuid = uuid;
        WiresUtils.assertShapeUUID(this.getGroup(), uuid);
        return this.cast();
    }

    public String getUUID() {
        return this.uuid;
    }

    public List<ControlPoint> addControlPoints(ControlPoint ... controlPoint) {
        if (this.validateControlPointShape()) {
            List<ControlPoint> result = Stream.of(controlPoint).map(cp -> {
                double x = cp.getLocation().getX();
                double y = cp.getLocation().getY();
                this.addControlPoint(x, y, cp.getIndex() + 1);
                return cp;
            }).collect(Collectors.toList());
            this.refrehControlPoints();
            return result;
        }
        return Collections.emptyList();
    }

    public T updateControlPoint(ControlPoint controlPoint) {
        if (this.validateControlPointShape()) {
            Point2D location = controlPoint.getLocation();
            this.moveControlPoint(controlPoint.getIndex() + 1, new com.ait.lienzo.client.core.types.Point2D(location.getX(), location.getY()));
            this.refrehControlPoints();
        }
        return this.cast();
    }

    private void refrehControlPoints() {
        this.getLine().refresh();
        if (null != this.getGroup().getLayer()) {
            this.getGroup().getLayer().batch();
        }
    }

    public T removeControlPoints(ControlPoint ... cps) {
        if (this.validateControlPointShape()) {
            int[] indexes = Arrays.stream(cps).filter(Objects::nonNull).mapToInt(cp -> cp.getIndex() + 1).toArray();
            this.destroyControlPoints(indexes);
        }
        return this.cast();
    }

    private boolean validateControlPointShape() {
        return this.getLine().isControlPointShape();
    }

    public List<ControlPoint> getShapeControlPoints() {
        Counter counter = new Counter(-1);
        return ((Stream)StreamSupport.stream(this.getControlPoints().spliterator(), false).map(point -> ControlPoint.build((Point2D)new Point2D(point.getX(), point.getY()), (int)counter.increment())).sequential()).collect(Collectors.toList());
    }

    public T connect(ShapeView headShapeView, Connection headConnection, ShapeView tailShapeView, Connection tailConnection) {
        Optional<WiresShape> headWiresShape = Optional.ofNullable((WiresShape)headShapeView);
        Optional<WiresShape> tailWiresShape = Optional.ofNullable((WiresShape)tailShapeView);
        return this.connect(headWiresShape.map(WiresShape::getMagnets).orElse(null), headWiresShape.map(s -> s.getGroup().getComputedLocation()).orElse(null), headConnection, tailWiresShape.map(WiresShape::getMagnets).orElse(null), tailWiresShape.map(s -> s.getGroup().getComputedLocation()).orElse(null), tailConnection);
    }

    T connect(MagnetManager.Magnets headMagnets, com.ait.lienzo.client.core.types.Point2D headAbsoluteLoc, Connection headConnection, MagnetManager.Magnets tailMagnets, com.ait.lienzo.client.core.types.Point2D tailAbsoluteLoc, Connection tailConnection) {
        WiresConnectorView.updateConnection(headConnection, headMagnets, headAbsoluteLoc, isAuto -> this.getHeadConnection().setAutoConnection(isAuto.booleanValue()), this::applyHeadLocation, this::applyHeadMagnet);
        WiresConnectorView.updateConnection(tailConnection, tailMagnets, tailAbsoluteLoc, isAuto -> this.getTailConnection().setAutoConnection(isAuto.booleanValue()), this::applyTailLocation, this::applyTailMagnet);
        return this.cast();
    }

    public double getShapeX() {
        return this.getGroup().getX();
    }

    public double getShapeY() {
        return this.getGroup().getY();
    }

    public T setShapeLocation(Point2D location) {
        this.getGroup().setLocation(new com.ait.lienzo.client.core.types.Point2D(location.getX(), location.getY()));
        return this.cast();
    }

    public double getAlpha() {
        return this.getGroup().getAlpha();
    }

    public T setAlpha(double alpha) {
        this.getGroup().setAlpha(alpha);
        return this.cast();
    }

    public Point2D getShapeAbsoluteLocation() {
        return WiresUtils.getAbsolute(this.getGroup());
    }

    public String getFillColor() {
        return this.getLine().asShape().getFillColor();
    }

    public T setFillColor(String color) {
        this.getLine().asShape().setFillColor(color);
        if (null != this.getHead()) {
            this.getHead().setFillColor(color);
        }
        if (null != this.getTail()) {
            this.getTail().setFillColor(color);
        }
        return this.cast();
    }

    public double getFillAlpha() {
        return this.getLine().getFillAlpha();
    }

    public T setFillAlpha(double alpha) {
        this.getLine().setFillAlpha(alpha);
        if (null != this.getHead()) {
            this.getHead().setFillAlpha(alpha);
        }
        if (null != this.getTail()) {
            this.getTail().setFillAlpha(alpha);
        }
        return this.cast();
    }

    public String getStrokeColor() {
        return this.getLine().asShape().getStrokeColor();
    }

    public T setStrokeColor(String color) {
        this.getLine().asShape().setStrokeColor(color);
        if (null != this.getHead()) {
            this.getHead().setStrokeColor(color);
        }
        if (null != this.getTail()) {
            this.getTail().setStrokeColor(color);
        }
        return this.cast();
    }

    public double getStrokeAlpha() {
        return this.getLine().getStrokeAlpha();
    }

    public T setStrokeAlpha(double alpha) {
        this.getLine().setStrokeAlpha(alpha);
        if (null != this.getHead()) {
            this.getHead().setStrokeAlpha(alpha);
        }
        if (null != this.getTail()) {
            this.getTail().setStrokeAlpha(alpha);
        }
        return this.cast();
    }

    public double getStrokeWidth() {
        return this.getLine().asShape().getStrokeWidth();
    }

    public T setStrokeWidth(double width) {
        this.getLine().asShape().setStrokeWidth(width);
        if (null != this.getHead()) {
            this.getHead().setStrokeWidth(width);
        }
        if (null != this.getTail()) {
            this.getTail().setStrokeWidth(width);
        }
        return this.cast();
    }

    public T setDragEnabled(boolean draggable) {
        this.setDraggable();
        return this.cast();
    }

    public T moveToTop() {
        this.getGroup().moveToTop();
        return this.cast();
    }

    public T moveToBottom() {
        this.getGroup().moveToBottom();
        return this.cast();
    }

    public T moveUp() {
        this.getGroup().moveUp();
        return this.cast();
    }

    public T moveDown() {
        this.getGroup().moveDown();
        return this.cast();
    }

    public T showControlPoints(HasControlPoints.ControlPointType type) {
        if (null != this.getControl()) {
            if (HasControlPoints.ControlPointType.POINTS.equals((Object)type)) {
                this.getControl().showControlPoints();
            } else {
                throw new UnsupportedOperationException("Control point type [" + type + "] not supported yet");
            }
        }
        return this.cast();
    }

    public T hideControlPoints() {
        if (null != this.getControl()) {
            this.getControl().hideControlPoints();
        }
        return this.cast();
    }

    public boolean areControlsVisible() {
        return this.getPointHandles().isVisible();
    }

    public List<Shape<?>> getDecorators() {
        ArrayList decorators = new ArrayList(3);
        decorators.add(this.getLine().asShape());
        if (null != this.getHead()) {
            decorators.add((Shape<?>)this.getHead());
        }
        if (null != this.getTail()) {
            decorators.add((Shape<?>)this.getTail());
        }
        return decorators;
    }

    public BoundingBox getBoundingBox() {
        com.ait.lienzo.client.core.types.BoundingBox bb = this.getGroup().getBoundingBox();
        return new BoundingBox(bb.getMinX(), bb.getMinY(), bb.getMaxX(), bb.getMaxY());
    }

    public void removeFromParent() {
        super.removeFromLayer();
    }

    private WiresConnector applyHeadLocation(Point2D location) {
        this.getHeadConnection().move(location.getX(), location.getY());
        return this;
    }

    private WiresConnector applyTailLocation(Point2D location) {
        this.getTailConnection().move(location.getX(), location.getY());
        return this;
    }

    private WiresConnector applyHeadMagnet(WiresMagnet headMagnet) {
        WiresConnectorView.ifNotSpecialConnection(this.getHeadConnection(), headMagnet, WiresConnectorView::clearConnectionOffset);
        return super.setHeadMagnet(headMagnet);
    }

    private WiresConnector applyTailMagnet(WiresMagnet tailMagnet) {
        WiresConnectorView.ifNotSpecialConnection(this.getTailConnection(), tailMagnet, WiresConnectorView::clearConnectionOffset);
        return super.setTailMagnet(tailMagnet);
    }

    private static void updateConnection(Connection connection, MagnetManager.Magnets magnets, com.ait.lienzo.client.core.types.Point2D absLocation, Consumer<Boolean> isAutoConnectionConsumer, Consumer<Point2D> locationConsumer, Consumer<WiresMagnet> magnetConsumer) {
        WiresMagnet[] magnet = new WiresMagnet[]{null};
        boolean[] auto = new boolean[]{false};
        Optional<Point2D> connectionLoc = Optional.empty();
        if (null != connection) {
            DiscreteConnection dc;
            DiscreteConnection discreteConnection = dc = connection instanceof DiscreteConnection ? (DiscreteConnection)connection : null;
            if (null != dc && null != magnets) {
                dc.getMagnetIndex().ifPresent(index -> {
                    magnet[0] = magnets.getMagnet(index);
                });
                auto[0] = dc.isAuto();
            }
            if (null == magnet[0] && null != absLocation) {
                magnet[0] = WiresConnectorView.getMagnetForConnection(connection, magnets, absLocation);
                if (null != dc) {
                    dc.setIndex(magnet[0].getIndex());
                }
            }
            if (null != connection.getLocation()) {
                connectionLoc = Optional.of(Point2D.create((double)connection.getLocation().getX(), (double)connection.getLocation().getY()));
            }
        }
        isAutoConnectionConsumer.accept(auto[0]);
        magnetConsumer.accept(magnet[0]);
        if (null == magnet[0]) {
            connectionLoc.ifPresent(locationConsumer::accept);
        }
    }

    private static WiresMagnet getMagnetForConnection(Connection connection, MagnetManager.Magnets magnets, com.ait.lienzo.client.core.types.Point2D absLocation) {
        if (null != connection && null != connection.getLocation()) {
            Point2D magnetAbs = new Point2D(absLocation.getX() + connection.getLocation().getX(), absLocation.getY() + connection.getLocation().getY());
            return WiresConnectorView.getMagnetNearTo(magnets, magnetAbs);
        }
        return magnets.getMagnet(0);
    }

    private static WiresMagnet getMagnetNearTo(MagnetManager.Magnets magnets, Point2D location) {
        return (WiresMagnet)StreamSupport.stream(magnets.getMagnets().spliterator(), false).sorted((m1, m2) -> WiresConnectorView.compare(m1, m2, location)).findFirst().get();
    }

    private static int compare(IControlHandle m1, IControlHandle m2, Point2D location) {
        double mx = location.getX();
        double my = location.getY();
        com.ait.lienzo.client.core.types.Point2D m1p = m1.getControl().getLocation();
        com.ait.lienzo.client.core.types.Point2D m2p = m2.getControl().getLocation();
        double d1 = ShapeUtils.dist((double)mx, (double)my, (double)m1p.getX(), (double)m1p.getY());
        double d2 = ShapeUtils.dist((double)mx, (double)my, (double)m2p.getX(), (double)m2p.getY());
        return Double.compare(d1, d2);
    }

    private static void ifNotSpecialConnection(WiresConnection connection, WiresMagnet magnet, Consumer<WiresConnection> regularConnectionConsumer) {
        if (!WiresConnection.isSpecialConnection((boolean)connection.isAutoConnection(), null != magnet ? Integer.valueOf(magnet.getIndex()) : null)) {
            regularConnectionConsumer.accept(connection);
        }
    }

    private static void clearConnectionOffset(WiresConnection connection) {
        connection.setXOffset(0.0);
        connection.setYOffset(0.0);
    }

    private T cast() {
        return (T)this;
    }

    public T setShadow(String color, int blur, double offx, double offy) {
        this.getDirectionalLine().setShadow(new Shadow(color, blur, offx, offy));
        return this.cast();
    }

    public T removeShadow() {
        this.getDirectionalLine().setShadow(null);
        return this.cast();
    }

    private AbstractDirectionalMultiPointShape<?> getDirectionalLine() {
        return (AbstractDirectionalMultiPointShape)this.getLine();
    }

    public Object getUserData() {
        return this.getDirectionalLine().getUserData();
    }

    public void setUserData(Object userData) {
        this.getDirectionalLine().setUserData(userData);
    }

    public T setDragBounds(double x0, double y0, double x1, double y1) {
        this.getGroup().setDragBounds(new DragBounds(x0, y0, x1, y1));
        return this.cast();
    }

    public T unsetDragBounds() {
        this.getGroup().setDragBounds(null);
        return this.cast();
    }
}

