/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.canvas;

import com.ait.lienzo.client.core.shape.GridLayer;
import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.shape.Layer;
import java.util.Optional;
import java.util.function.BiFunction;
import org.kie.workbench.common.stunner.client.lienzo.canvas.LienzoCanvasDecoratorFactory;
import org.kie.workbench.common.stunner.client.lienzo.canvas.LienzoGridLayerBuilder;
import org.kie.workbench.common.stunner.client.lienzo.canvas.LienzoLayer;
import org.kie.workbench.common.stunner.client.lienzo.canvas.LienzoPanel;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasView;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasGrid;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasSettings;
import org.kie.workbench.common.stunner.core.client.canvas.Transform;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeView;

public abstract class LienzoCanvasView<L extends LienzoLayer>
extends AbstractCanvasView<LienzoCanvasView> {
    static final String BG_COLOR = "#FFFFFF";
    private BiFunction<Integer, Integer, IPrimitive<?>> decoratorFactory;

    public LienzoCanvasView() {
        this(LienzoCanvasDecoratorFactory.AUTHORING);
    }

    public LienzoCanvasView(BiFunction<Integer, Integer, IPrimitive<?>> decoratorFactory) {
        this.decoratorFactory = decoratorFactory;
    }

    public abstract L getLayer();

    protected LienzoCanvasView<L> doInitialize(CanvasSettings canvasSettings) {
        Optional canvasSize = canvasSettings.getCanvasSize();
        if (canvasSize.isPresent()) {
            this.getLienzoPanel().show((LienzoLayer)this.getLayer(), ((CanvasSettings.CanvasSize)canvasSize.get()).getWidth(), ((CanvasSettings.CanvasSize)canvasSize.get()).getHeight());
        } else {
            this.getLienzoPanel().show((LienzoLayer)this.getLayer());
        }
        this.getLienzoPanel().asWidget().getElement().getStyle().setBackgroundColor(BG_COLOR);
        ((LienzoLayer)this.getLayer()).getTopLayer().add(this.decoratorFactory.apply(1200, 800));
        return this;
    }

    public LienzoCanvasView<L> add(ShapeView<?> shape) {
        ((LienzoLayer)this.getLayer()).add((IPrimitive)shape);
        return this;
    }

    public LienzoCanvasView<L> delete(ShapeView<?> shape) {
        ((LienzoLayer)this.getLayer()).delete((IPrimitive)shape);
        return this;
    }

    public LienzoCanvasView<L> setGrid(CanvasGrid grid) {
        if (null != grid) {
            GridLayer gridLayer = LienzoGridLayerBuilder.getLienzoGridFor(grid);
            this.getLienzoPanel().setBackgroundLayer((Layer)gridLayer);
        } else {
            this.getLienzoPanel().setBackgroundLayer(null);
        }
        return this;
    }

    public LienzoCanvasView<L> setDecoratorFactory(BiFunction<Integer, Integer, IPrimitive<?>> decoratorFatory) {
        this.decoratorFactory = decoratorFatory;
        return this;
    }

    public LienzoCanvasView<L> clear() {
        ((LienzoLayer)this.getLayer()).clear();
        return this;
    }

    public Transform getTransform() {
        return ((LienzoLayer)this.getLayer()).getTransform();
    }

    public LienzoPanel getLienzoPanel() {
        return (LienzoPanel)this.getPanel();
    }

    protected void doDestroy() {
        ((LienzoLayer)this.getLayer()).destroy();
        this.decoratorFactory = null;
    }
}

