/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.canvas.controls;

import com.ait.lienzo.client.core.shape.wires.IControlPointsAcceptor;
import com.ait.lienzo.client.core.shape.wires.WiresConnector;
import com.ait.lienzo.client.core.shape.wires.WiresManager;
import com.ait.lienzo.client.core.types.Point2DArray;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Default;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.client.lienzo.canvas.wires.WiresCanvas;
import org.kie.workbench.common.stunner.client.lienzo.shape.view.wires.WiresConnectorView;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.AbstractCanvasHandlerRegistrationControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.CanvasControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.connection.ControlPointControl;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasSelectionEvent;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandFactory;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandManager;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.client.command.RequiresCommandManager;
import org.kie.workbench.common.stunner.core.client.session.impl.EditorSession;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.view.HasControlPoints;
import org.kie.workbench.common.stunner.core.client.shape.view.IsConnector;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.impl.CompositeCommand;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.content.view.ControlPoint;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewConnector;

@Dependent
@Default
public class ControlPointControlImpl
extends AbstractCanvasHandlerRegistrationControl<AbstractCanvasHandler>
implements ControlPointControl<AbstractCanvasHandler>,
CanvasControl.SessionAware<EditorSession> {
    public static final int DRAG_BOUNDS_MARGIN = 10;
    private final CanvasCommandFactory<AbstractCanvasHandler> canvasCommandFactory;
    private final IControlPointsAcceptor cpAcceptor;
    private RequiresCommandManager.CommandManagerProvider<AbstractCanvasHandler> commandManagerProvider;
    private final Event<CanvasSelectionEvent> selectionEvent;

    @Inject
    public ControlPointControlImpl(CanvasCommandFactory<AbstractCanvasHandler> canvasCommandFactory, Event<CanvasSelectionEvent> selectionEvent) {
        this.canvasCommandFactory = canvasCommandFactory;
        this.cpAcceptor = new StunnerControlPointsAcceptor(this, this::getEdge);
        this.selectionEvent = selectionEvent;
    }

    protected void doInit() {
        super.doInit();
        this.getWiresManager().setControlPointsAcceptor(this.cpAcceptor);
    }

    public void register(Element element) {
    }

    private boolean isConnector(Shape<?> shape) {
        return shape.getShapeView() instanceof IsConnector;
    }

    private boolean supportsControlPoints(Shape<?> shape) {
        return shape.getShapeView() instanceof HasControlPoints;
    }

    public void setCommandManagerProvider(RequiresCommandManager.CommandManagerProvider<AbstractCanvasHandler> provider) {
        this.commandManagerProvider = provider;
    }

    public void addControlPoints(Edge candidate, ControlPoint ... controlPoint) {
        this.selectionEvent.fire((Object)new CanvasSelectionEvent((CanvasHandler)this.canvasHandler, candidate.getUUID()));
        this.execute((Command<AbstractCanvasHandler, CanvasViolation>)this.canvasCommandFactory.addControlPoint(candidate, controlPoint));
    }

    public void bind(EditorSession session) {
    }

    private CanvasCommandManager<AbstractCanvasHandler> getCommandManager() {
        return this.commandManagerProvider.getCommandManager();
    }

    public void moveControlPoints(Edge candidate, Map<ControlPoint, Point2D> pointsLocation) {
        CompositeCommand command = null;
        if (pointsLocation.size() == 1) {
            Map.Entry<ControlPoint, Point2D> entry = pointsLocation.entrySet().iterator().next();
            command = this.newUpdateCPCommand(candidate, entry.getKey(), entry.getValue());
        } else if (pointsLocation.size() > 0) {
            CompositeCommand.Builder builder = new CompositeCommand.Builder().forward();
            pointsLocation.forEach((cp, location) -> builder.addCommand(this.newUpdateCPCommand(candidate, (ControlPoint)cp, (Point2D)location)));
            command = builder.build();
        }
        if (null != command) {
            this.execute((Command<AbstractCanvasHandler, CanvasViolation>)command);
        }
    }

    private CanvasCommand<AbstractCanvasHandler> newUpdateCPCommand(Edge candidate, ControlPoint controlPoint, Point2D location) {
        return this.canvasCommandFactory.updateControlPointPosition(candidate, controlPoint, Point2D.clone((Point2D)location));
    }

    public void removeControlPoint(Edge candidate, ControlPoint controlPoint) {
        if (ControlPointControlImpl.validateControlPointState(candidate)) {
            this.execute((Command<AbstractCanvasHandler, CanvasViolation>)this.canvasCommandFactory.deleteControlPoint(candidate, new ControlPoint[]{controlPoint}));
        }
    }

    RequiresCommandManager.CommandManagerProvider<AbstractCanvasHandler> getCommandManagerProvider() {
        return this.commandManagerProvider;
    }

    private CommandResult<CanvasViolation> execute(Command<AbstractCanvasHandler, CanvasViolation> command) {
        return this.getCommandManager().execute((Object)this.canvasHandler, command);
    }

    private static Optional<ControlPoint> getControlPointyByIndex(Edge edge, int index) {
        ViewConnector viewConnector = (ViewConnector)edge.getContent();
        return viewConnector.getControlPoints().stream().filter(cp -> Objects.nonNull(cp.getIndex())).filter(cp -> cp.getIndex() == index - 1).findFirst();
    }

    private static boolean validateControlPointState(Edge edge) {
        return Objects.nonNull(edge) && edge.getContent() instanceof ViewConnector;
    }

    private Edge getEdge(String uuid) {
        return this.canvasHandler.getGraphIndex().getEdge(uuid);
    }

    protected void doDestroy() {
        super.doDestroy();
        this.getWiresManager().setControlPointsAcceptor(IControlPointsAcceptor.ALL);
        this.commandManagerProvider = null;
    }

    private WiresManager getWiresManager() {
        return ((WiresCanvas)this.canvasHandler.getCanvas()).getWiresManager();
    }

    public static class StunnerControlPointsAcceptor
    implements IControlPointsAcceptor {
        private final ControlPointControl control;
        private final Function<String, Edge> connectorSupplier;

        public StunnerControlPointsAcceptor(ControlPointControl control, Function<String, Edge> connectorSupplier) {
            this.control = control;
            this.connectorSupplier = connectorSupplier;
        }

        public boolean add(WiresConnector connector, int index, com.ait.lienzo.client.core.types.Point2D locatoin) {
            Edge edge = this.getEdge(connector);
            if (ControlPointControlImpl.validateControlPointState(edge)) {
                this.control.addControlPoints(edge, new ControlPoint[]{ControlPoint.build((double)locatoin.getX(), (double)locatoin.getY(), (int)(index - 1))});
                return true;
            }
            return false;
        }

        public boolean move(WiresConnector connector, Point2DArray pointsLocation) {
            Edge edge = this.getEdge(connector);
            if (ControlPointControlImpl.validateControlPointState(edge)) {
                ViewConnector viewConnector = (ViewConnector)edge.getContent();
                List controlPoints = viewConnector.getControlPoints();
                HashMap<ControlPoint, Point2D> updatedCPs = new HashMap<ControlPoint, Point2D>(controlPoints.size());
                for (int i = 1; i < pointsLocation.size() - 1; ++i) {
                    com.ait.lienzo.client.core.types.Point2D targetLocation = pointsLocation.get(i);
                    ControlPoint controlPoint = (ControlPoint)controlPoints.get(i - 1);
                    if (StunnerControlPointsAcceptor.isAt(controlPoint, targetLocation)) continue;
                    updatedCPs.put(controlPoint, Point2D.create((double)targetLocation.getX(), (double)targetLocation.getY()));
                }
                this.control.moveControlPoints(edge, updatedCPs);
                return true;
            }
            return false;
        }

        public boolean delete(WiresConnector connector, int index) {
            Edge edge = this.getEdge(connector);
            if (ControlPointControlImpl.validateControlPointState(edge)) {
                Optional cp = ControlPointControlImpl.getControlPointyByIndex(edge, index);
                cp.ifPresent(instance -> this.control.removeControlPoint(edge, instance));
            }
            return false;
        }

        private Edge getEdge(WiresConnector connector) {
            return this.getEdge(StunnerControlPointsAcceptor.getUUID(connector));
        }

        private Edge getEdge(String uuid) {
            return this.connectorSupplier.apply(uuid);
        }

        private static boolean isAt(ControlPoint controlPoint, com.ait.lienzo.client.core.types.Point2D location) {
            Point2D cpLocation = controlPoint.getLocation();
            return cpLocation.getX() == location.getX() && cpLocation.getY() == location.getY();
        }

        private static String getUUID(WiresConnector connector) {
            return connector instanceof WiresConnectorView ? ((WiresConnectorView)connector).getUUID() : connector.uuid();
        }
    }
}

