/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.canvas.controls;

import com.ait.lienzo.client.core.shape.Shape;
import com.ait.lienzo.client.core.shape.wires.DefaultSelectionListener;
import com.ait.lienzo.client.core.shape.wires.SelectionListener;
import com.ait.lienzo.client.core.shape.wires.SelectionManager;
import com.ait.lienzo.client.core.shape.wires.WiresConnector;
import com.ait.lienzo.client.core.shape.wires.WiresManager;
import com.ait.lienzo.client.core.shape.wires.WiresShape;
import com.ait.lienzo.client.core.types.Point2D;
import com.google.gwt.event.dom.client.MouseEvent;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Default;
import javax.inject.Inject;
import org.kie.soup.commons.util.Lists;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.stunner.client.lienzo.canvas.wires.WiresCanvas;
import org.kie.workbench.common.stunner.client.lienzo.shape.view.wires.WiresConnectorView;
import org.kie.workbench.common.stunner.client.lienzo.shape.view.wires.WiresShapeView;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.select.AbstractSelectionControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.select.MapSelectionControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.select.MultipleSelection;
import org.kie.workbench.common.stunner.core.client.canvas.event.ShapeLocationsChangedEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasClearSelectionEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasSelectionEvent;

@Dependent
@MultipleSelection
@Default
public class LienzoMultipleSelectionControl<H extends AbstractCanvasHandler>
extends AbstractSelectionControl<H> {
    private final CursoredSelectionShapeProvider selectionShapeProvider;
    private final SelectionListener selectionListener = new SelectionListener(){
        private final DefaultSelectionListener defaultSelectionListener = new DefaultSelectionListener();

        public void onChanged(SelectionManager.SelectedItems selectedItems) {
            SelectionManager.ChangedItems changedItems = selectedItems.getChanged();
            LienzoMultipleSelectionControl.this.getSelectionControl().deselect((Collection)new Lists.Builder().addAll(AbstractSelectionControl.shapesToIdentifiers((Collection)changedItems.getRemovedShapes().toList())).addAll(AbstractSelectionControl.shapesToIdentifiers((Collection)changedItems.getRemovedConnectors().toList())).build());
            LienzoMultipleSelectionControl.this.getSelectionControl().select((Collection)new Lists.Builder().addAll(AbstractSelectionControl.shapesToIdentifiers((Collection)changedItems.getAddedShapes().toList())).addAll(AbstractSelectionControl.shapesToIdentifiers((Collection)changedItems.getAddedConnectors().toList())).build());
            this.defaultSelectionListener.onChanged(selectedItems);
        }
    };

    @Inject
    public LienzoMultipleSelectionControl(Event<CanvasSelectionEvent> canvasSelectionEvent, Event<CanvasClearSelectionEvent> clearSelectionEvent) {
        super(canvasSelectionEvent, clearSelectionEvent);
        this.selectionShapeProvider = new CursoredSelectionShapeProvider(this::getCanvasHandler);
    }

    LienzoMultipleSelectionControl(MapSelectionControl<H> selectionControl, Event<CanvasSelectionEvent> canvasSelectionEvent, Event<CanvasClearSelectionEvent> clearSelectionEvent, CursoredSelectionShapeProvider selectionShapeProvider) {
        super(selectionControl, canvasSelectionEvent, clearSelectionEvent);
        this.selectionShapeProvider = selectionShapeProvider;
    }

    protected void onEnable(H canvasHandler) {
        super.onEnable(canvasHandler);
        this.getWiresManager().enableSelectionManager().setSelectionShapeProvider((SelectionManager.SelectionShapeProvider)this.selectionShapeProvider).setSelectionListener(this.selectionListener);
    }

    private void rebuildSelectionArea() {
        if (null != this.selectionShapeProvider.getShape()) {
            this.getSelectionManager().getSelectedItems().rebuildBoundingBox();
            this.getSelectionManager().drawSelectionShapeForSelection();
        }
    }

    protected void onShapeLocationsChanged(@Observes ShapeLocationsChangedEvent event) {
        if (this.isSameCanvas(event.getCanvasHandler()) && this.areSelected(event.getUuids())) {
            this.rebuildSelectionArea();
        }
    }

    private boolean isSameCanvas(CanvasHandler handler) {
        AbstractCanvasHandler canvasHandler = this.getCanvasHandler();
        return null != canvasHandler && canvasHandler.equals(handler);
    }

    private boolean areSelected(Collection<String> uuids) {
        Collection selectedItems = this.getSelectedItems();
        if (uuids == null) {
            return false;
        }
        return uuids.stream().anyMatch(selectedItems::contains);
    }

    protected void onSelect(Collection<String> uuids) {
        super.onSelect(uuids);
        Collection shapeViews = uuids.stream().map(uuid -> this.getCanvasHandler().getCanvas().getShape(uuid)).filter(Objects::nonNull).map(org.kie.workbench.common.stunner.core.client.shape.Shape::getShapeView).collect(Collectors.toList());
        shapeViews.stream().filter(view -> view instanceof WiresShapeView).forEach(view -> this.getSelectionManager().getSelectedItems().add((WiresShape)view));
        shapeViews.stream().filter(view -> view instanceof WiresConnectorView).forEach(view -> this.getSelectionManager().getSelectedItems().add((WiresConnector)view));
    }

    protected void onClearSelection() {
        super.onClearSelection();
        if (Objects.nonNull(this.getSelectionControl().getCanvasHandler())) {
            this.getSelectionManager().clearSelection();
        }
    }

    protected void onDestroy() {
        this.getSelectionManager().destroy();
        this.selectionShapeProvider.destroy();
        super.onDestroy();
    }

    private AbstractCanvasHandler getCanvasHandler() {
        return this.getSelectionControl().getCanvasHandler();
    }

    private WiresManager getWiresManager() {
        return ((WiresCanvas)this.getSelectionControl().getCanvasHandler().getCanvas()).getWiresManager();
    }

    private SelectionManager getSelectionManager() {
        return this.getWiresManager().getSelectionManager();
    }

    void onCanvasSelection(@Observes CanvasSelectionEvent event) {
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        if (Objects.equals(this.getCanvasHandler(), event.getCanvasHandler())) {
            this.selectionShapeProvider.moveShapeToTop();
        }
    }

    static class CursoredSelectionShapeProvider
    implements SelectionManager.SelectionShapeProvider<CursoredSelectionShapeProvider> {
        private final SelectionManager.SelectionShapeProvider provider;
        private final Supplier<AbstractCanvasHandler> canvasHandlerSupplier;
        private HandlerRegistration mouseEnterHandlerReg;
        private HandlerRegistration mouseExitHandlerReg;

        private CursoredSelectionShapeProvider(Supplier<AbstractCanvasHandler> canvasHandlerSupplier) {
            this((SelectionManager.SelectionShapeProvider)new SelectionManager.RectangleSelectionProvider(), canvasHandlerSupplier);
        }

        CursoredSelectionShapeProvider(SelectionManager.SelectionShapeProvider provider, Supplier<AbstractCanvasHandler> canvasHandlerSupplier) {
            this.provider = provider;
            this.canvasHandlerSupplier = canvasHandlerSupplier;
        }

        public Shape<?> getShape() {
            return this.provider.getShape();
        }

        public CursoredSelectionShapeProvider build() {
            this.provider.build();
            this.clearHandlerRegs();
            this.mouseEnterHandlerReg = this.provider.getShape().addNodeMouseEnterHandler(event -> this.canvasHandlerSupplier.get().getAbstractCanvas().getView().setCursor(AbstractCanvas.Cursors.MOVE));
            this.mouseExitHandlerReg = this.provider.getShape().addNodeMouseExitHandler(event -> this.canvasHandlerSupplier.get().getAbstractCanvas().getView().setCursor(AbstractCanvas.Cursors.AUTO));
            return this;
        }

        public CursoredSelectionShapeProvider setLocation(Point2D location) {
            this.provider.setLocation(location);
            return this;
        }

        public CursoredSelectionShapeProvider setSize(double width, double height) {
            this.provider.setSize(width, height);
            return this;
        }

        public boolean isMultipleSelection(MouseEvent<? extends EventHandler> event) {
            return this.provider.isMultipleSelection(event);
        }

        public CursoredSelectionShapeProvider clear() {
            this.clearHandlerRegs();
            this.provider.clear();
            return this;
        }

        public void destroy() {
            this.clear();
            this.mouseEnterHandlerReg = null;
            this.mouseExitHandlerReg = null;
        }

        public CursoredSelectionShapeProvider moveShapeToTop() {
            if (null != this.getShape()) {
                this.getShape().moveToTop();
            }
            return this;
        }

        private void clearHandlerRegs() {
            if (null != this.mouseEnterHandlerReg) {
                this.mouseEnterHandlerReg.removeHandler();
            }
            if (null != this.mouseExitHandlerReg) {
                this.mouseExitHandlerReg.removeHandler();
            }
        }
    }
}

