/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.canvas.wires;

import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.shape.wires.WiresConnector;
import com.ait.lienzo.client.core.shape.wires.WiresContainer;
import com.ait.lienzo.client.core.shape.wires.WiresManager;
import com.ait.lienzo.client.core.shape.wires.WiresShape;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.client.lienzo.canvas.LienzoCanvasView;
import org.kie.workbench.common.stunner.client.lienzo.canvas.wires.WiresLayer;
import org.kie.workbench.common.stunner.client.lienzo.canvas.wires.WiresUtils;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeView;

@Dependent
public class WiresCanvasView
extends LienzoCanvasView<WiresLayer> {
    private final WiresLayer layer;

    @Inject
    public WiresCanvasView(WiresLayer layer) {
        this.layer = layer;
    }

    public void use(WiresManager wiresManager) {
        this.layer.use(wiresManager);
    }

    @Override
    public LienzoCanvasView add(ShapeView<?> shape) {
        if (WiresUtils.isWiresShape(shape)) {
            this.layer.add((WiresShape)shape);
        } else if (WiresUtils.isWiresConnector(shape)) {
            this.layer.add((WiresConnector)shape);
        } else {
            return super.add(shape);
        }
        return this;
    }

    public LienzoCanvasView addRoot(ShapeView<?> shape) {
        if (WiresUtils.isWiresShape(shape)) {
            this.layer.add((IPrimitive<?>)((WiresShape)shape).getGroup());
        } else if (WiresUtils.isWiresConnector(shape)) {
            this.layer.add((IPrimitive<?>)((WiresConnector)shape).getGroup());
        } else {
            return super.add(shape);
        }
        return this;
    }

    @Override
    public LienzoCanvasView delete(ShapeView<?> shape) {
        if (WiresUtils.isWiresShape(shape)) {
            this.layer.delete((WiresShape)shape);
        } else if (WiresUtils.isWiresConnector(shape)) {
            this.layer.delete((WiresConnector)shape);
        } else {
            return super.delete(shape);
        }
        return this;
    }

    public LienzoCanvasView deleteRoot(ShapeView<?> shape) {
        if (WiresUtils.isWiresShape(shape)) {
            this.layer.delete((IPrimitive<?>)((WiresShape)shape).getGroup());
        } else if (WiresUtils.isWiresConnector(shape)) {
            this.layer.delete((IPrimitive<?>)((WiresConnector)shape).getGroup());
        } else {
            return super.delete(shape);
        }
        return this;
    }

    public LienzoCanvasView addChild(ShapeView<?> parent, ShapeView<?> child) {
        WiresContainer parentShape = (WiresContainer)parent;
        WiresShape childShape = (WiresShape)child;
        this.layer.addChild(parentShape, childShape);
        return this;
    }

    public LienzoCanvasView deleteChild(ShapeView<?> parent, ShapeView<?> child) {
        WiresContainer parentShape = (WiresContainer)parent;
        WiresShape childShape = (WiresShape)child;
        this.layer.deleteChild(parentShape, childShape);
        return this;
    }

    public LienzoCanvasView dock(ShapeView<?> parent, ShapeView<?> child) {
        WiresContainer parentShape = (WiresContainer)parent;
        WiresShape childShape = (WiresShape)child;
        this.layer.dock(parentShape, childShape);
        return this;
    }

    public LienzoCanvasView undock(ShapeView<?> childParent, ShapeView<?> child) {
        WiresShape childShape = (WiresShape)child;
        this.layer.undock(childShape);
        return this;
    }

    @Override
    public WiresLayer getLayer() {
        return this.layer;
    }
}

