/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.shape.impl;

import com.ait.lienzo.client.core.types.Shadow;
import com.ait.lienzo.shared.core.types.ColorName;
import com.ait.lienzo.shared.core.types.IColor;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.kie.workbench.common.stunner.client.lienzo.shape.impl.ShapeStateAttributeAnimationHandler;
import org.kie.workbench.common.stunner.client.lienzo.shape.view.LienzoShapeView;
import org.kie.workbench.common.stunner.client.lienzo.util.ShapeViewUserDataEncoder;
import org.kie.workbench.common.stunner.core.client.shape.ShapeState;
import org.kie.workbench.common.stunner.core.client.shape.impl.ShapeStateAttributeHandler;
import org.kie.workbench.common.stunner.core.client.shape.impl.ShapeStateAttributesFactory;
import org.kie.workbench.common.stunner.core.client.shape.impl.ShapeStateHandler;
import org.kie.workbench.common.stunner.core.client.shape.view.HasShadow;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeView;

public class ShapeStateDefaultHandler
implements ShapeStateHandler {
    private static final Shadow SHADOW_HIGHLIGHT = new Shadow((IColor)ColorName.BLACK.getColor().setA(0.4), 10, 0.0, 0.0);
    private static final Shadow SHADOW_SELECTED = new Shadow((IColor)ColorName.BLACK.getColor().setA(0.4), 5, 2.0, 2.0);
    protected final ShapeStateAttributeAnimationHandler<LienzoShapeView<?>> handler;
    protected Supplier<LienzoShapeView<?>> backgroundShapeSupplier;
    protected Supplier<LienzoShapeView<?>> borderShapeSupplier;
    private ShapeViewUserDataEncoder shapeViewDataEncoder;

    public ShapeStateDefaultHandler() {
        this(new ShapeStateAttributeAnimationHandler());
    }

    ShapeStateDefaultHandler(ShapeStateAttributeAnimationHandler<LienzoShapeView<?>> handler) {
        this.handler = handler.onComplete(this::applyShadow);
        this.shapeViewDataEncoder = ShapeViewUserDataEncoder.get();
        this.setRenderType(RenderType.STROKE);
    }

    public ShapeStateDefaultHandler setRenderType(RenderType renderType) {
        this.handler.getAttributesHandler().useAttributes(renderType.stateAttributesProvider);
        this.shapeViewDataEncoder.applyShapeViewRenderType(this.borderShapeSupplier, renderType);
        return this;
    }

    public ShapeStateDefaultHandler setBorderShape(Supplier<LienzoShapeView<?>> shapeSupplier) {
        this.handler.getAttributesHandler().setView(shapeSupplier);
        this.borderShapeSupplier = shapeSupplier;
        this.shapeViewDataEncoder.applyShapeViewType(shapeSupplier, ShapeType.BORDER);
        return this;
    }

    public ShapeStateDefaultHandler setBackgroundShape(Supplier<LienzoShapeView<?>> shapeSupplier) {
        this.backgroundShapeSupplier = shapeSupplier;
        this.shapeViewDataEncoder.applyShapeViewType(shapeSupplier, ShapeType.BACKGROUND);
        return this;
    }

    public ShapeStateDefaultHandler setContainerShape(Supplier<LienzoShapeView<?>> shapeSupplier) {
        this.shapeViewDataEncoder.applyShapeViewType(shapeSupplier, ShapeType.CONTAINER);
        return this;
    }

    public void applyState(ShapeState shapeState) {
        this.handler.applyState(shapeState);
    }

    public ShapeStateHandler shapeAttributesChanged() {
        this.handler.shapeAttributesChanged();
        return this;
    }

    public ShapeState reset() {
        this.getShadowShape().ifPresent(this::removeShadow);
        return this.handler.reset();
    }

    public ShapeState getShapeState() {
        return this.handler.getShapeState();
    }

    private void applyShadow() {
        this.getShadowShape().ifPresent(this::updateShadow);
    }

    private void removeShadow(HasShadow shape) {
        shape.removeShadow();
    }

    private void updateShadow(HasShadow shape) {
        if (ShapeStateDefaultHandler.isStateSelected(this.handler.getShapeState())) {
            shape.setShadow(SHADOW_SELECTED.getColor(), SHADOW_SELECTED.getBlur(), SHADOW_SELECTED.getOffset().getX(), SHADOW_SELECTED.getOffset().getY());
        } else if (ShapeStateDefaultHandler.isStateHighlight(this.handler.getShapeState())) {
            shape.setShadow(SHADOW_HIGHLIGHT.getColor(), SHADOW_HIGHLIGHT.getBlur(), SHADOW_HIGHLIGHT.getOffset().getX(), SHADOW_HIGHLIGHT.getOffset().getY());
        } else {
            this.removeShadow(shape);
        }
    }

    private Optional<HasShadow> getShadowShape() {
        return this.getShadowShape(this.handler.getAttributesHandler().getShapeView());
    }

    private Optional<HasShadow> getShadowShape(ShapeView<?> shape) {
        ShapeView<?> candidate;
        ShapeView<?> shapeView = candidate = null != this.getBackgroundShape() ? this.getBackgroundShape() : shape;
        if (candidate instanceof HasShadow) {
            return Optional.of((HasShadow)candidate);
        }
        return Optional.empty();
    }

    LienzoShapeView<?> getBackgroundShape() {
        return null != this.backgroundShapeSupplier ? this.backgroundShapeSupplier.get() : null;
    }

    private static boolean isStateSelected(ShapeState state) {
        return ShapeState.SELECTED.equals((Object)state);
    }

    private static boolean isStateHighlight(ShapeState state) {
        return ShapeState.HIGHLIGHT.equals((Object)state);
    }

    public static enum ShapeType {
        BACKGROUND,
        BORDER,
        CONTAINER;

    }

    public static enum RenderType {
        FILL(ShapeStateAttributesFactory::buildFillAttributes),
        STROKE(ShapeStateAttributesFactory::buildStrokeAttributes);

        private final Function<ShapeState, ShapeStateAttributeHandler.ShapeStateAttributes> stateAttributesProvider = state -> {
            ShapeStateAttributeHandler.ShapeStateAttributes attributes = (ShapeStateAttributeHandler.ShapeStateAttributes)stateAttributesProvider.apply((ShapeState)state);
            if (ShapeStateDefaultHandler.isStateSelected(state)) {
                attributes.unset(ShapeStateAttributeHandler.ShapeStateAttribute.FILL_COLOR).unset(ShapeStateAttributeHandler.ShapeStateAttribute.STROKE_COLOR);
            }
            return attributes;
        };

        private RenderType(Function<ShapeState, ShapeStateAttributeHandler.ShapeStateAttributes> stateAttributesProvider) {
        }

        public Function<ShapeState, ShapeStateAttributeHandler.ShapeStateAttributes> stateAttributesProvider() {
            return this.stateAttributesProvider;
        }
    }
}

