/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.shape.view.wires;

import com.ait.lienzo.client.core.shape.IContainer;
import com.ait.lienzo.client.core.shape.IDrawable;
import com.ait.lienzo.client.core.shape.MultiPath;
import com.ait.lienzo.client.core.shape.Shape;
import com.ait.lienzo.client.core.shape.wires.LayoutContainer;
import com.ait.lienzo.client.core.shape.wires.OptionalBounds;
import com.ait.lienzo.client.core.shape.wires.WiresConnection;
import com.ait.lienzo.client.core.shape.wires.WiresLayoutContainer;
import com.ait.lienzo.client.core.shape.wires.WiresMagnet;
import com.ait.lienzo.client.core.shape.wires.WiresShape;
import com.ait.lienzo.client.core.shape.wires.handlers.WiresBoundsConstraintControl;
import com.ait.lienzo.client.core.types.Shadow;
import com.ait.tooling.nativetools.client.collection.NFastArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.kie.workbench.common.stunner.client.lienzo.canvas.wires.WiresUtils;
import org.kie.workbench.common.stunner.client.lienzo.shape.view.LienzoShapeView;
import org.kie.workbench.common.stunner.client.lienzo.util.LienzoShapeUtils;
import org.kie.workbench.common.stunner.client.lienzo.util.ShapeViewUserDataEncoder;
import org.kie.workbench.common.stunner.core.client.shape.view.BoundingBox;
import org.kie.workbench.common.stunner.core.client.shape.view.HasDragBounds;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;

public class WiresShapeView<T>
extends WiresShape
implements LienzoShapeView<T>,
HasDragBounds<T> {
    private String uuid;

    public WiresShapeView(MultiPath path) {
        this(path, null);
    }

    public WiresShapeView(MultiPath path, LayoutContainer layoutContainer) {
        super(path, (LayoutContainer)(null != layoutContainer ? layoutContainer : new WiresLayoutContainer()));
        this.setListening(false);
    }

    public Shape<?> getShape() {
        return this.getPath();
    }

    public T setUUID(String uuid) {
        this.uuid = uuid;
        ShapeViewUserDataEncoder.get().setShapeViewChildrenIds(uuid, (IContainer)this.getGroup());
        WiresUtils.assertShapeUUID(this.getGroup(), uuid);
        return this.cast();
    }

    public String getUUID() {
        return this.uuid;
    }

    public double getShapeX() {
        return this.getContainer().getAttributes().getX();
    }

    public double getShapeY() {
        return this.getContainer().getAttributes().getY();
    }

    public T setShapeLocation(Point2D location) {
        this.setLocation(new com.ait.lienzo.client.core.types.Point2D(location.getX(), location.getY()));
        this.shapeMoved();
        return this.cast();
    }

    public double getAlpha() {
        return this.getContainer().getAttributes().getAlpha();
    }

    public T setAlpha(double alpha) {
        this.getContainer().getAttributes().setAlpha(alpha);
        return this.cast();
    }

    public Point2D getShapeAbsoluteLocation() {
        return WiresUtils.getAbsolute(this.getContainer());
    }

    public String getFillColor() {
        return this.getShape().getFillColor();
    }

    public T setFillColor(String color) {
        this.getShape().setFillColor(color);
        return this.cast();
    }

    public double getFillAlpha() {
        return this.getShape().getFillAlpha();
    }

    public T setFillAlpha(double alpha) {
        this.getShape().setFillAlpha(alpha);
        return this.cast();
    }

    public String getStrokeColor() {
        return this.getShape().getStrokeColor();
    }

    public T setStrokeColor(String color) {
        this.getShape().setStrokeColor(color);
        return this.cast();
    }

    public double getStrokeAlpha() {
        return this.getShape().getStrokeAlpha();
    }

    public T setStrokeAlpha(double alpha) {
        this.getShape().setStrokeAlpha(alpha);
        return this.cast();
    }

    public double getStrokeWidth() {
        return this.getShape().getStrokeWidth();
    }

    public T setStrokeWidth(double width) {
        this.getShape().setStrokeWidth(width);
        return this.cast();
    }

    public T setDragEnabled(boolean draggable) {
        this.setDraggable(draggable);
        return this.cast();
    }

    public T setDragBounds(Bounds bounds) {
        this.ifLocationBoundsConstraintsSupported(() -> LienzoShapeUtils.translateBounds(bounds));
        return this.cast();
    }

    private void ifLocationBoundsConstraintsSupported(Supplier<OptionalBounds> wiresBounds) {
        if (null != this.getControl() && this.getControl() instanceof WiresBoundsConstraintControl.SupportsOptionalBounds) {
            ((WiresBoundsConstraintControl.SupportsOptionalBounds)this.getControl()).setLocationBounds(wiresBounds.get());
        }
    }

    private void unsetDragBounds() {
        this.ifLocationBoundsConstraintsSupported(OptionalBounds::createEmptyBounds);
    }

    public T moveToTop() {
        this.consumeChildrenAndConnectors(IDrawable::moveToTop);
        return this.cast();
    }

    public T moveToBottom() {
        this.consumeChildrenAndConnectors(IDrawable::moveToBottom);
        return this.cast();
    }

    public T moveUp() {
        this.consumeChildrenAndConnectors(IDrawable::moveUp);
        return this.cast();
    }

    public T moveDown() {
        this.consumeChildrenAndConnectors(IDrawable::moveDown);
        return this.cast();
    }

    public BoundingBox getBoundingBox() {
        com.ait.lienzo.client.core.types.BoundingBox bb = this.getGroup().getBoundingBox();
        return new BoundingBox(bb.getMinX(), bb.getMinY(), bb.getMaxX(), bb.getMaxY());
    }

    public void destroy() {
        super.destroy();
        this.unsetDragBounds();
    }

    public T setListening(boolean listening) {
        this.getPath().setFillBoundsForSelection(listening);
        this.listen(listening);
        return this.cast();
    }

    public List<Shape<?>> getDecorators() {
        return Collections.singletonList(this.getShape());
    }

    void consumeChildrenAndConnectors(Consumer<IDrawable> primConsumer) {
        int i;
        primConsumer.accept((IDrawable)this.getContainer());
        NFastArrayList childShapes = this.getChildShapes();
        if (null != childShapes) {
            for (i = 0; i < childShapes.size(); ++i) {
                WiresShape shape = (WiresShape)childShapes.get(i);
                if (shape instanceof WiresShapeView) {
                    ((WiresShapeView)shape).consumeChildrenAndConnectors(primConsumer);
                    continue;
                }
                primConsumer.accept((IDrawable)shape.getContainer());
            }
        }
        if (null != this.getMagnets()) {
            for (i = 0; i < this.getMagnets().size(); ++i) {
                WiresMagnet magnet = this.getMagnets().getMagnet(i);
                NFastArrayList connections = magnet.getConnections();
                if (null == connections) continue;
                for (int j = 0; j < connections.size(); ++j) {
                    WiresConnection connection = (WiresConnection)connections.get(j);
                    if (null == connection.getConnector()) continue;
                    primConsumer.accept((IDrawable)connection.getConnector().getGroup());
                }
            }
        }
    }

    private T cast() {
        return (T)this;
    }

    public T setShadow(String color, int blur, double offx, double offy) {
        this.getShape().setShadow(new Shadow(color, blur, offx, offx));
        return this.cast();
    }

    public T removeShadow() {
        this.getShape().setShadow(null);
        return this.cast();
    }

    public Object getUserData() {
        return this.getShape().getUserData();
    }

    public void setUserData(Object userData) {
        this.getShape().setUserData(userData);
    }
}

